/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5.enums;

import com.uwetrottmann.trakt5.enums.TraktEnum;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum SortBy implements TraktEnum
{
    RANK("rank"),
    ADDED("added"),
    TITLE("title"),
    RELEASED("released"),
    RUNTIME("runtime"),
    POPULARITY("popularity"),
    PERCENTAGE("percentage"),
    VOTES("votes"),
    MY_RATING("my_rating"),
    RANDOM("random");

    private final String value;
    private static final Map<String, SortBy> STRING_MAPPING;

    private SortBy(String value) {
        this.value = value;
    }

    public static SortBy fromValue(String value) {
        return STRING_MAPPING.get(value.toUpperCase(Locale.ROOT));
    }

    @Override
    public String toString() {
        return this.value;
    }

    static {
        STRING_MAPPING = new HashMap<String, SortBy>();
        for (SortBy via : SortBy.values()) {
            STRING_MAPPING.put(via.toString().toUpperCase(Locale.ROOT), via);
        }
    }
}

