/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTableUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;

public class TmmTableUI
extends BaseTableUI {
    public static ComponentUI createUI(JComponent c) {
        return new TmmTableUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.table.remove(this.rendererPane);
        this.rendererPane = this.createCustomCellRendererPane();
        this.table.add(this.rendererPane);
    }

    private CellRendererPane createCustomCellRendererPane() {
        return new CellRendererPane(){
            private static final long serialVersionUID = 7146435127995900923L;

            @Override
            public void paintComponent(Graphics graphics, Component component, Container container, int x, int y, int w, int h, boolean shouldValidate) {
                Point point = new Point(x, y);
                int rowAtPoint = TmmTableUI.this.table.rowAtPoint(point);
                int columnAtPoint = TmmTableUI.this.table.columnAtPoint(point);
                boolean isSelected = TmmTableUI.this.table.isRowSelected(rowAtPoint);
                Object prop = TmmTableUI.this.table.getClientProperty("borderNotToDraw");
                ArrayList colsNotToDraw = new ArrayList();
                if (prop != null && prop instanceof List) {
                    try {
                        colsNotToDraw.addAll((List)prop);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (component instanceof JComponent) {
                    JComponent jcomponent = (JComponent)component;
                    jcomponent.setOpaque(isSelected);
                    if (isSelected && !colsNotToDraw.contains(columnAtPoint)) {
                        jcomponent.setBorder(BorderFactory.createCompoundBorder(new RightSideBorder(AbstractLookAndFeel.getTheme().getSelectedGridColor()), jcomponent.getBorder()));
                    }
                }
                super.paintComponent(graphics, component, container, x, y, w, h, shouldValidate);
            }
        };
    }

    private static class RightSideBorder
    extends AbstractBorder {
        private final Color color;
        private final int thickness = 1;

        public RightSideBorder(Color color) {
            this.color = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(this.color);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(width - 1, 0, width - 1, height - 1);
            g2d.dispose();
        }
    }
}

