/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseSliderUI;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;

public class TmmSliderUI
extends BaseSliderUI {
    protected static int TRACK_WIDTH = 7;
    protected static int THUMB_SIZE = TRACK_WIDTH * 2 + 1;

    public TmmSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new TmmSliderUI((JSlider)c);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(THUMB_SIZE, THUMB_SIZE + 2);
    }

    @Override
    protected int getTrackWidth() {
        return TRACK_WIDTH;
    }

    @Override
    public void paintTrack(Graphics g) {
        int trackRight;
        int trackLeft;
        int trackBottom;
        boolean leftToRight = JTattooUtilities.isLeftToRight(this.slider);
        g.translate(this.trackRect.x, this.trackRect.y);
        int overhang = 5;
        int trackTop = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - overhang;
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackLeft = -TRACK_WIDTH / 2;
            trackRight = this.trackRect.width - 1 + TRACK_WIDTH / 2;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - overhang - this.getTrackWidth();
                trackRight = this.trackRect.width - overhang - 1;
            } else {
                trackLeft = overhang;
                trackRight = overhang + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        RenderingHints savedRenderingHints = g2D.getRenderingHints();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(AbstractLookAndFeel.getTheme().getTrackColors()[0]);
        g.fillRoundRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1, TRACK_WIDTH, TRACK_WIDTH);
        g.translate(-this.trackRect.x, -this.trackRect.y);
        g2D.setComposite(savedComposite);
        g2D.setRenderingHints(savedRenderingHints);
    }

    @Override
    public void paintThumb(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        RenderingHints savedRenderingHints = g2D.getRenderingHints();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.slider.isEnabled()) {
            g.setColor(AbstractLookAndFeel.getBackgroundColor());
            g.fillRect(this.thumbRect.x + 1, this.thumbRect.y + 1, this.thumbRect.width - 2, this.thumbRect.height - 2);
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
        }
        g.setColor(AbstractLookAndFeel.getTheme().getSliderColors()[0]);
        g.fillOval(this.thumbRect.x, this.thumbRect.y, THUMB_SIZE, THUMB_SIZE);
        g2D.setComposite(savedComposite);
        g2D.setRenderingHints(savedRenderingHints);
    }

    @Override
    public void paintFocus(Graphics g) {
    }
}

