/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.tinymediamanager.ui.plaf.TmmTheme;
import sun.swing.ImageIconUIResource;

public class TmmIcons
extends BaseIcons {
    public static Color COLOR = Color.GRAY;
    public static Color COLOR_HOVER = Color.WHITE;
    public static final ImageIcon EMPTY_IMAGE = new ImageIcon(TmmIcons.class.getResource("empty.png"));

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new CloseSymbol(COLOR, null, COLOR_HOVER);
        }
        return closeIcon;
    }

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = new IconSymbol(COLOR, null, COLOR_HOVER);
        }
        return iconIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = new MaxSymbol(COLOR, null, COLOR_HOVER);
        }
        return maxIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = new MaxSymbol(COLOR, null, COLOR_HOVER);
        }
        return minIcon;
    }

    public static Icon getTreeExpandedIcon() {
        if (treeExpandedIcon == null) {
            treeExpandedIcon = new TreeExpandedIcon();
        }
        return treeExpandedIcon;
    }

    public static Icon getTreeCollapsedIcon() {
        if (treeCollapsedIcon == null) {
            treeCollapsedIcon = new TreeCollapsedIcon();
        }
        return treeCollapsedIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new SquareCheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static ImageIcon createFontAwesomeIcon(char iconId) {
        return TmmIcons.createFontAwesomeIcon(iconId, TmmIcons.calculateFontIconSize(1.1667f), UIManager.getColor("Label.foreground"));
    }

    private static int calculateFontIconSize(float scaleFactor) {
        return (int)Math.floor((float)AbstractLookAndFeel.getDefaultFontSize() * scaleFactor);
    }

    public static ImageIcon createFontAwesomeIcon(char iconId, int size) {
        return TmmIcons.createFontAwesomeIcon(iconId, TmmIcons.calculateFontIconSize((float)size / 12.0f), UIManager.getColor("Label.foreground"));
    }

    public static ImageIcon createFontAwesomeIcon(char iconId, float scaleFactor) {
        return TmmIcons.createFontAwesomeIcon(iconId, TmmIcons.calculateFontIconSize(scaleFactor), UIManager.getColor("Label.foreground"));
    }

    public static ImageIcon createFontAwesomeIcon(char iconId, Color color) {
        return TmmIcons.createFontAwesomeIcon(iconId, TmmIcons.calculateFontIconSize(1.1667f), color);
    }

    public static ImageIcon createFontAwesomeIcon(char iconId, int size, Color color) {
        if (TmmTheme.FONT_AWESOME == null) {
            return EMPTY_IMAGE;
        }
        Font font = TmmTheme.FONT_AWESOME.deriveFont((float)size);
        return TmmIcons.createFontIcon(font, String.valueOf(iconId), color);
    }

    public static ImageIcon createTextIcon(String text, int size) {
        return TmmIcons.createTextIcon(text, size, UIManager.getColor("Label.foreground"));
    }

    public static ImageIcon createTextIcon(String text, int size, Color color) {
        Font defaultfont = (Font)UIManager.get("Label.font");
        if (defaultfont == null) {
            return null;
        }
        Font font = defaultfont.deriveFont(1, size);
        return TmmIcons.createFontIcon(font, text, color);
    }

    public static ImageIcon createFontIcon(Font font, String text, Color color) {
        try {
            BufferedImage tmp = new BufferedImage(1, 1, 2);
            Graphics2D g2 = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(tmp);
            g2.setFont(font);
            Rectangle2D defaultBounds = g2.getFontMetrics().getStringBounds("M", g2);
            Rectangle2D bounds = font.createGlyphVector(g2.getFontRenderContext(), text).getVisualBounds();
            int iconWidth = (int)Math.ceil(bounds.getWidth()) + 2;
            int iconHeight = (int)Math.ceil(bounds.getHeight()) + 2;
            if ((double)iconHeight < defaultBounds.getHeight()) {
                iconHeight = (int)Math.ceil(defaultBounds.getHeight());
            }
            g2.dispose();
            if (iconWidth < iconHeight) {
                iconWidth = iconHeight;
            }
            BufferedImage buffer = new BufferedImage(iconWidth, iconHeight, 2);
            g2 = (Graphics2D)buffer.getGraphics();
            Map desktopHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            if (desktopHints != null) {
                g2.setRenderingHints(desktopHints);
            }
            g2.setFont(font);
            g2.setColor(color);
            int y = (int)Math.floor(bounds.getY() - (defaultBounds.getHeight() - bounds.getHeight()) / 2.0);
            g2.drawString(text, (int)(((double)iconWidth - Math.ceil(bounds.getWidth())) / 2.0), -y);
            g2.dispose();
            return new ImageIcon(buffer);
        }
        catch (Exception exception) {
            return EMPTY_IMAGE;
        }
    }

    private static class SquareCheckBoxIcon
    implements Icon {
        private static final int SIZE = AbstractLookAndFeel.getDefaultFontSize() + 4;
        private static final ImageIcon SMALL_CHECK_ICON = TmmIcons.createFontAwesomeIcon('\uf00c', AbstractLookAndFeel.getTheme().getFocusColor());
        private static final ImageIcon TRI_STATE_ICON = TmmIcons.createFontAwesomeIcon('\uf068', AbstractLookAndFeel.getTheme().getFocusColor());

        private SquareCheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += 3;
            }
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            Graphics2D g2D = (Graphics2D)g;
            Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(AbstractLookAndFeel.getTheme().getBackgroundColorDark());
            g.fillRoundRect(x + 1, y + 1, SIZE, SIZE, SIZE / 2, SIZE / 2);
            g.setColor(AbstractLookAndFeel.getTheme().getInputBackgroundColor());
            g.fillRoundRect(x, y, SIZE, SIZE, SIZE / 2, SIZE / 2);
            ImageIcon icon = null;
            int offsetX = 0;
            if (this.isTriStateButtonModelStatusMixed(model)) {
                icon = TRI_STATE_ICON;
                offsetX = 2;
            } else if (model.isSelected()) {
                icon = SMALL_CHECK_ICON;
            }
            if (icon != null) {
                if (!model.isEnabled()) {
                    icon = new ImageIconUIResource(GrayFilter.createDisabledImage(SMALL_CHECK_ICON.getImage()));
                }
                icon.paintIcon(c, g, x + offsetX, y);
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        }

        private boolean isTriStateButtonModelStatusMixed(ButtonModel model) {
            if ("TriStateButtonModel".equals(model.getClass().getSimpleName())) {
                try {
                    Method method = model.getClass().getMethod("isMixed", new Class[0]);
                    if (((Boolean)method.invoke((Object)model, new Object[0])).booleanValue()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public int getIconWidth() {
            return SIZE + 2;
        }

        @Override
        public int getIconHeight() {
            return SIZE;
        }
    }

    private static class TreeExpandedIcon
    implements Icon {
        private TreeExpandedIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Polygon p = new Polygon();
            int size = this.getIconWidth();
            p.addPoint(x + size / 6, y + size / 3);
            p.addPoint(x + size - size / 6, y + size / 3);
            p.addPoint(x + size / 2, y + size - size / 3);
            g.fillPolygon(p);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        @Override
        public int getIconWidth() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 14;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 15;
            }
            return 18;
        }

        @Override
        public int getIconHeight() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 14;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 15;
            }
            return 18;
        }
    }

    private static class TreeCollapsedIcon
    implements Icon {
        private TreeCollapsedIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Polygon p = new Polygon();
            int size = this.getIconWidth();
            p.addPoint(x + size / 3, y + size / 6);
            p.addPoint(x + size / 3, y + size - size / 6);
            p.addPoint(x + size - size / 3, y + size / 2);
            g.fillPolygon(p);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        @Override
        public int getIconWidth() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 14;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 15;
            }
            return 18;
        }

        @Override
        public int getIconHeight() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 14;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 15;
            }
            return 18;
        }
    }

    private static class MaxSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public MaxSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.translate(this.insets.left, this.insets.top);
            int w = c.getWidth() - this.insets.left - this.insets.right;
            int h = c.getHeight() - this.insets.top - this.insets.bottom;
            boolean active = JTattooUtilities.isActive((JComponent)c);
            Color color = this.foregroundColor;
            if (!active) {
                color = this.inactiveForegroundColor;
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int lw = w / 12;
            int dx = w / 5 + 1;
            int dy = h / 5 + 1;
            Stroke savedStroke = g2D.getStroke();
            g2D.setStroke(new BasicStroke(lw, 0, 0));
            if (this.shadowColor != null) {
                if (!active) {
                    g2D.setColor(this.inactiveShadowColor);
                } else {
                    g2D.setColor(this.shadowColor);
                }
                g2D.drawRect(dx + 1, dy + 1, w - 2 * dx, h - 2 * dy);
                g2D.drawLine(dx + 1, dy + lw + 1, w - dx, dy + lw + 1);
            }
            g2D.setColor(color);
            g2D.drawRect(dx, dy, w - 2 * dx, h - 2 * dy);
            g2D.drawLine(dx + 1, dy + lw, w - dx, dy + lw);
            g2D.setStroke(savedStroke);
            g2D.translate(-this.insets.left, -this.insets.top);
        }
    }

    private static class IconSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Color rolloverColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public IconSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int dx;
            Graphics2D g2D = (Graphics2D)g;
            g2D.translate(this.insets.left, this.insets.top);
            int w = c.getWidth() - this.insets.left - this.insets.right;
            int h = c.getHeight() - this.insets.top - this.insets.bottom;
            boolean active = JTattooUtilities.isActive((JComponent)c);
            Color color = this.foregroundColor;
            if (!active) {
                color = this.inactiveForegroundColor;
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int lw = w / 12 + 1;
            int dy = dx = w / 5 + 1;
            Stroke savedStroke = g2D.getStroke();
            g2D.setStroke(new BasicStroke(lw, 0, 0));
            if (this.shadowColor != null) {
                if (!active) {
                    g2D.setColor(this.inactiveShadowColor);
                } else {
                    g2D.setColor(this.shadowColor);
                }
                g2D.drawLine(dx + 1, h - dy, w - dx + 1, h - dy);
            }
            g2D.setColor(color);
            g2D.drawLine(dx, h - dy - 1, w - dx, h - dy - 1);
            g2D.setStroke(savedStroke);
            g2D.translate(-this.insets.left, -this.insets.top);
        }
    }

    private static class CloseSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public CloseSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int dx;
            Graphics2D g2D = (Graphics2D)g;
            g2D.translate(this.insets.left, this.insets.top);
            int w = c.getWidth() - this.insets.left - this.insets.right;
            int h = c.getHeight() - this.insets.top - this.insets.bottom;
            boolean active = JTattooUtilities.isActive((JComponent)c);
            Color color = this.foregroundColor;
            if (!active) {
                color = this.inactiveForegroundColor;
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int lw = w / 12 + 1;
            int dy = dx = w / 5 + 1;
            Stroke savedStroke = g2D.getStroke();
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setStroke(new BasicStroke(lw, 1, 2));
            if (this.shadowColor != null) {
                if (!active) {
                    g2D.setColor(this.inactiveShadowColor);
                } else {
                    g2D.setColor(this.shadowColor);
                }
                g2D.drawLine(dx + 1, dy + 1, w - dx + 1, h - dy + 1);
                g2D.drawLine(w - dx + 1, dy + 1, dx + 1, h - dy + 1);
            }
            g2D.setColor(color);
            g2D.drawLine(dx, dy, w - dx, h - dy);
            g2D.drawLine(w - dx, dy, dx, h - dy);
            g2D.setStroke(savedStroke);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            g2D.translate(-this.insets.left, -this.insets.top);
        }
    }
}

