/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class TmmButtonUI
extends BaseButtonUI {
    protected boolean isFlatButton = false;
    protected int focusWidth = 2;

    public static ComponentUI createUI(JComponent c) {
        return new TmmButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Object prop = b.getClientProperty("flatButton");
        if (prop != null && prop instanceof Boolean) {
            this.isFlatButton = (Boolean)prop;
            if (this.isFlatButton) {
                b.setBorder(new EmptyBorder(3, 6, 3, 6));
            }
        }
        b.setOpaque(false);
        b.setFocusPainted(false);
    }

    @Override
    protected void paintBackground(Graphics g, AbstractButton b) {
        if (this.isFlatButton || !b.isContentAreaFilled() || b.getParent() instanceof JMenuBar) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = b.getWidth();
        int height = b.getHeight();
        int borderRadius = (int)((double)b.getHeight() * 0.7 - (double)(2 * this.focusWidth));
        int x = this.focusWidth;
        int y = this.focusWidth;
        int w = width - 2 * this.focusWidth;
        int h = height - 2 * this.focusWidth;
        ButtonModel model = b.getModel();
        if (b.isRolloverEnabled() && model.isRollover()) {
            g2D.setColor(AbstractLookAndFeel.getFocusColor());
            Composite oldComposite = g2D.getComposite();
            for (int i = this.focusWidth; i > 0; --i) {
                float opacity = 1.0f - 2.0f * (float)i * (float)i / 10.0f;
                g2D.setComposite(AlphaComposite.getInstance(3, opacity));
                g2D.fillRoundRect(x - i, y - i, w + 2 * i, h + 2 * i, borderRadius + i, borderRadius + i);
            }
            g2D.setComposite(oldComposite);
        }
        if (model.isPressed() && model.isArmed()) {
            g2D.setColor(AbstractLookAndFeel.getTheme().getPressedBackgroundColor());
        } else {
            g2D.setColor(AbstractLookAndFeel.getButtonBackgroundColor());
        }
        g2D.fillRoundRect(x, y, w, h, borderRadius, borderRadius);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = this.getFontMetrics(b, g, b.getFont());
        int mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b.getText(), model.getMnemonic());
        if (model.isEnabled()) {
            Object sc;
            Color foreground = b.getForeground();
            Color background = b.getBackground();
            int offs = 0;
            if (model.isArmed() && model.isPressed()) {
                offs = 0;
            }
            if (!(model.isPressed() && model.isArmed() || !((sc = b.getClientProperty("shadowColor")) instanceof Color))) {
                g.setColor((Color)sc);
                JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            }
            if (background instanceof ColorUIResource && !this.isFlatButton) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(AbstractLookAndFeel.getTheme().getPressedForegroundColor());
                } else if (model.isRollover()) {
                    g.setColor(AbstractLookAndFeel.getTheme().getRolloverForegroundColor());
                } else {
                    g.setColor(foreground);
                }
            } else {
                g.setColor(foreground);
            }
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
        } else {
            if (ColorHelper.getGrayValue(b.getForeground()) < 128) {
                g.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            }
            g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2D = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = this.getFontMetrics(b, g, b.getFont());
        Insets insets = c.getInsets();
        TmmButtonUI.viewRect.x = insets.left;
        TmmButtonUI.viewRect.y = insets.top;
        TmmButtonUI.viewRect.width = b.getWidth() - (insets.right + TmmButtonUI.viewRect.x);
        TmmButtonUI.viewRect.height = b.getHeight() - (insets.bottom + TmmButtonUI.viewRect.y);
        TmmButtonUI.textRect.height = 0;
        TmmButtonUI.textRect.width = 0;
        TmmButtonUI.textRect.y = 0;
        TmmButtonUI.textRect.x = 0;
        TmmButtonUI.iconRect.height = 0;
        TmmButtonUI.iconRect.width = 0;
        TmmButtonUI.iconRect.y = 0;
        TmmButtonUI.iconRect.x = 0;
        int iconTextGap = this.defaultTextIconGap;
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            iconTextGap = b.getIconTextGap();
        }
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : iconTextGap);
        this.paintBackground(g, b);
        if (b.getIcon() != null) {
            if (!b.isEnabled()) {
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                this.paintIcon(g, c, iconRect);
                g2D.setComposite(savedComposite);
            } else {
                this.paintIcon(g, c, iconRect);
            }
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                Object savedRenderingHint = null;
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                v.paint(g, textRect);
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
                }
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        return BasicGraphicsUtils.getPreferredButtonSize(b, b.getIconTextGap());
    }

    private FontMetrics getFontMetrics(JComponent c, Graphics g, Font font) {
        if (c != null) {
            return c.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }
}

