/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.util.LanguageUtils;

public enum MediaLanguages {
    al("Shqip"),
    ar("\u0627\u0644\u0639\u064e\u0631\u064e\u0628\u0650\u064a\u064e\u0651\u0629"),
    bg("\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 \u0435\u0437\u0438\u043a"),
    cs("\u010cesk\u00fd"),
    de("Deutsch"),
    da("Dansk"),
    el("\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"),
    en("English"),
    es("Espa\u00f1ol"),
    es_MX("Espa\u00f1ol (Mexico)"),
    et("eesti"),
    fa("\u0641\u0627\u0631\u0633\u06cc"),
    fi("Suomi"),
    fr("Fran\u00e7aise"),
    he("\u05e2\u05d1\u05e8\u05d9\u05ea"),
    hr("hrvatski jezik"),
    hu("Magyar"),
    hy("\u0540\u0561\u0575\u0565\u0580\u0565\u0576"),
    is("\u00cdslenska"),
    it("Italiano"),
    ja("\u65e5\u672c\u8a9e"),
    ka("\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8"),
    ko("\ud55c\uad6d\uc5b4"),
    nl("Nederlands, Vlaams"),
    no("Norsk"),
    pl("Polski"),
    pt("Portugu\u00eas"),
    pt_BR("Portugu\u00eas (Brasil)"),
    ro("Rom\u00e2n\u0103"),
    ru("\u0420\u0443\u0441\u0441\u043a\u0438\u0439"),
    sl("Sloven\u0161\u010dina"),
    sk("Sloven\u010dina"),
    sr("\u0441\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a"),
    sv("Svenska"),
    th("\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22"),
    tr("T\u00fcrk\u00e7e"),
    uk("\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"),
    vi("Ti\u1ebfng Vi\u1ec7t"),
    zh("\u534e\u8bed"),
    none("-");

    private String title;
    private String displayTitle;
    private static final Map<String, MediaLanguages> lookup;

    private static Map<String, MediaLanguages> prepareLookup() {
        HashMap<String, MediaLanguages> mlMap = new HashMap<String, MediaLanguages>();
        for (MediaLanguages lang : MediaLanguages.values()) {
            mlMap.put(lang.getTitle(), lang);
            mlMap.put(lang.name(), lang);
        }
        return mlMap;
    }

    public static MediaLanguages get(String title) {
        MediaLanguages entry = lookup.get(title);
        if (entry == null) {
            entry = lookup.get(LanguageUtils.getIso2LanguageFromLocalizedString(title));
        }
        if (entry == null) {
            entry = en;
        }
        return entry;
    }

    private MediaLanguages(String title) {
        this.title = title;
        Locale locale = Locale.forLanguageTag(this.name());
        this.displayTitle = locale != null && StringUtils.isNotBlank((CharSequence)locale.getDisplayLanguage()) && !this.name().equals(locale.getDisplayLanguage()) ? locale.getDisplayLanguage() : title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLanguage() {
        if (this == none) {
            return "";
        }
        return this.name().substring(0, 2);
    }

    public String toString() {
        return this.displayTitle;
    }

    public Locale toLocale() {
        if (this == none) {
            return null;
        }
        return LocaleUtils.toLocale((String)this.name());
    }

    public static MediaLanguages[] valuesSorted() {
        TreeMap<String, MediaLanguages> map = new TreeMap<String, MediaLanguages>(String.CASE_INSENSITIVE_ORDER);
        for (MediaLanguages ml : MediaLanguages.values()) {
            map.put(ml.toString(), ml);
        }
        return map.values().toArray(new MediaLanguages[0]);
    }

    static {
        lookup = MediaLanguages.prepareLookup();
    }
}

