/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.config;

import java.util.ArrayList;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaProviderConfigObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaProviderConfigObject.class);
    String key = "";
    String keyDescription = "";
    String value = "";
    String defaultValue = "";
    boolean returnListAsInt = false;
    boolean encrypt = false;
    boolean visible = true;
    ConfigType type = ConfigType.TEXT;
    ArrayList<String> possibleValues = new ArrayList();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKeyDescription() {
        return this.keyDescription.isEmpty() ? this.key : this.keyDescription;
    }

    public void setKeyDescription(String keyDescription) {
        this.keyDescription = keyDescription;
    }

    public boolean isEmpty() {
        return this.key.isEmpty();
    }

    public String getValue() {
        String ret = "";
        switch (this.type) {
            case SELECT: {
                ret = this.getValueAsString();
                break;
            }
            case SELECT_INDEX: {
                Integer i = this.getValueIndex();
                ret = i == null || i < 0 ? "" : String.valueOf(i);
                break;
            }
            case BOOL: {
                return String.valueOf(this.getValueAsBool());
            }
            default: {
                return this.value;
            }
        }
        return ret;
    }

    public String getValueAsString() {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(this.value)) {
            LOGGER.warn("Could not get value for key '" + this.key + "' - not in range; returning default " + this.defaultValue);
            return this.defaultValue;
        }
        return this.value;
    }

    public Boolean getValueAsBool() {
        Boolean bool = null;
        if (this.type != ConfigType.BOOL) {
            LOGGER.warn("This is not a boolean '" + this.key + "=" + this.value + "' - returning NULL ");
            return null;
        }
        if (this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("false")) {
            bool = Boolean.valueOf(this.value);
        } else {
            LOGGER.warn("This is not a Boolean '" + this.key + "=" + this.value + "' - returning default " + this.defaultValue);
            bool = Boolean.valueOf(this.defaultValue);
        }
        return bool;
    }

    public Integer getValueIndex() {
        Integer ret = null;
        if (this.type != ConfigType.SELECT && this.type != ConfigType.SELECT_INDEX) {
            LOGGER.warn("This is not a selectbox '" + this.key + "=" + this.value + "' - returning NULL ");
            return null;
        }
        ret = this.possibleValues.indexOf(this.value);
        if (ret == -1) {
            ret = this.possibleValues.indexOf(this.defaultValue);
            if (ret == -1) {
                ret = null;
            }
            LOGGER.warn("Could not get index for '" + this.key + "=" + this.value + "' - not in defined range! returning default " + ret);
        }
        return ret;
    }

    public void setValue(String value) {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(value)) {
            LOGGER.warn("Could not set '" + this.key + "=" + value + "' - not in defined range!");
            return;
        }
        this.value = value;
    }

    public void setValue(boolean value) {
        if (this.type != ConfigType.BOOL) {
            LOGGER.warn("This is not a boolean configuration object - seeting keep current value");
        } else {
            this.value = String.valueOf(value);
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(defaultValue)) {
            LOGGER.warn("Will not set defaultValue '" + this.key + "=" + defaultValue + "' - since it is not in the list of possible values!");
        } else {
            this.defaultValue = defaultValue;
        }
    }

    public boolean isReturnListAsInt() {
        return this.returnListAsInt;
    }

    public void setReturnListAsInt(boolean returnListAsInt) {
        this.returnListAsInt = returnListAsInt;
    }

    public ArrayList<String> getPossibleValues() {
        return this.possibleValues;
    }

    public void setPossibleValues(ArrayList<String> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public void addPossibleValues(String possibleValue) {
        this.possibleValues.add(possibleValue);
    }

    public ConfigType getType() {
        return this.type;
    }

    public void setType(ConfigType type) {
        this.type = type;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static enum ConfigType {
        TEXT,
        BOOL,
        SELECT,
        SELECT_INDEX;

    }
}

