/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaType;

public class MediaSearchOptions {
    protected MediaType type;
    private String query = "";
    private int year = 0;
    private HashMap<String, Object> ids = new HashMap();
    private Locale language = Locale.getDefault();
    private CountryCode country = CountryCode.getDefault();

    public MediaSearchOptions(MediaType type) {
        this.type = type;
    }

    public MediaSearchOptions(MediaType type, String query) {
        this.type = type;
        this.query = query;
    }

    public MediaType getMediaType() {
        return this.type;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getIdAsString(String providerId) {
        Object id = this.ids.get(providerId);
        if (id != null) {
            return String.valueOf(id);
        }
        return null;
    }

    public Integer getIdAsInteger(String providerId) {
        Object id = this.ids.get(providerId);
        if (id != null) {
            if (id instanceof Integer) {
                return (Integer)id;
            }
            if (id instanceof String) {
                try {
                    return Integer.parseInt((String)id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public int getIdAsInt(String providerId) {
        Integer id = this.getIdAsInteger(providerId);
        if (id == null) {
            return 0;
        }
        return id;
    }

    public int getIdAsIntOrDefault(String providerId, int defaultValue) {
        Integer id = this.getIdAsInteger(providerId);
        if (id == null) {
            return defaultValue;
        }
        return id;
    }

    public void setId(String providerId, String id) {
        this.ids.put(providerId, id);
    }

    public void setIds(Map<String, Object> newIds) {
        this.ids.clear();
        this.ids.putAll(newIds);
    }

    public String getImdbId() {
        Object obj = this.ids.get("imdb");
        if (obj == null && (obj = this.ids.get("imdbId")) == null) {
            return "";
        }
        return obj.toString();
    }

    public int getTmdbId() {
        Integer id = this.getIdAsInteger("tmdb");
        if (id == null || id == 0) {
            id = this.getIdAsInteger("tmdbId");
        }
        if (id != null) {
            return id;
        }
        return 0;
    }

    public void setImdbId(String imdbId) {
        this.ids.put("imdb", imdbId);
    }

    public void setTmdbId(int tmdbId) {
        this.ids.put("tmdb", tmdbId);
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public CountryCode getCountry() {
        return this.country;
    }

    public void setCountry(CountryCode country) {
        this.country = country;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

