/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.thetvdb;

import com.uwetrottmann.thetvdb.TheTvdb;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TheTvdbInterceptor
implements Interceptor {
    private TheTvdb theTvdb;

    public TheTvdbInterceptor(TheTvdb theTvdb) {
        this.theTvdb = theTvdb;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return TheTvdbInterceptor.handleIntercept(chain, this.jsonWebToken());
    }

    public static Response handleIntercept(Interceptor.Chain chain, @Nullable String jsonWebToken) throws IOException {
        Request request = chain.request();
        if (!"api.thetvdb.com".equals(request.url().host())) {
            return chain.proceed(request);
        }
        Request.Builder builder = request.newBuilder();
        builder.header("Accept", "application/vnd.thetvdb.v2.2.0");
        if (TheTvdbInterceptor.hasNoAuthorizationHeader(request) && TheTvdbInterceptor.jsonWebTokenIsNotEmpty(jsonWebToken)) {
            builder.header("Authorization", "Bearer " + jsonWebToken);
        }
        return chain.proceed(builder.build());
    }

    @Nullable
    public String jsonWebToken() {
        return this.theTvdb.jsonWebToken();
    }

    private static boolean hasNoAuthorizationHeader(Request request) {
        return request.header("Authorization") == null;
    }

    private static boolean jsonWebTokenIsNotEmpty(@Nullable String jsonWebToken) {
        return jsonWebToken != null && jsonWebToken.length() != 0;
    }
}

