/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2;

import com.uwetrottmann.tmdb2.Tmdb;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TmdbInterceptor
implements Interceptor {
    private final Tmdb tmdb;

    public TmdbInterceptor(Tmdb tmdb) {
        this.tmdb = tmdb;
    }

    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        return TmdbInterceptor.handleIntercept(chain, this.tmdb);
    }

    public static Response handleIntercept(Interceptor.Chain chain, Tmdb tmdb) throws IOException {
        String retryHeader;
        List pathSegments;
        Request request = chain.request();
        if (!"api.themoviedb.org".equals(request.url().host())) {
            return chain.proceed(request);
        }
        HttpUrl.Builder urlBuilder = request.url().newBuilder();
        urlBuilder.setEncodedQueryParameter("api_key", tmdb.apiKey());
        if (tmdb.isLoggedIn() && ((pathSegments = request.url().pathSegments()).size() >= 2 && ((String)pathSegments.get(1)).equals("account") || ((String)pathSegments.get(pathSegments.size() - 1)).equals("account_states") || ((String)pathSegments.get(pathSegments.size() - 1)).equals("rating") || !request.method().equals("GET"))) {
            TmdbInterceptor.addSessionToken(tmdb, urlBuilder);
        }
        Request.Builder builder = request.newBuilder();
        builder.url(urlBuilder.build());
        Response response = chain.proceed(builder.build());
        if (!response.isSuccessful() && (retryHeader = response.header("Retry-After")) != null) {
            try {
                int retry = Integer.parseInt(retryHeader);
                Thread.sleep((int)(((double)retry + 0.5) * 1000.0));
                if (response.body() != null) {
                    response.body().close();
                }
                return TmdbInterceptor.handleIntercept(chain, tmdb);
            }
            catch (InterruptedException | NumberFormatException exception) {
                // empty catch block
            }
        }
        return response;
    }

    private static void addSessionToken(Tmdb tmdb, HttpUrl.Builder urlBuilder) {
        if (tmdb.getSessionId() != null) {
            urlBuilder.addEncodedQueryParameter("session_id", tmdb.getSessionId());
        } else if (tmdb.getGuestSessionId() != null) {
            urlBuilder.addEncodedQueryParameter("guest_session_id", tmdb.getGuestSessionId());
        }
    }
}

