/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2;

import com.google.gson.Gson;
import com.uwetrottmann.tmdb2.DiscoverMovieBuilder;
import com.uwetrottmann.tmdb2.DiscoverTvBuilder;
import com.uwetrottmann.tmdb2.TmdbAuthenticator;
import com.uwetrottmann.tmdb2.TmdbHelper;
import com.uwetrottmann.tmdb2.TmdbInterceptor;
import com.uwetrottmann.tmdb2.entities.Status;
import com.uwetrottmann.tmdb2.exceptions.TmdbAuthenticationFailedException;
import com.uwetrottmann.tmdb2.exceptions.TmdbDuplicateEntryException;
import com.uwetrottmann.tmdb2.exceptions.TmdbInvalidParametersException;
import com.uwetrottmann.tmdb2.exceptions.TmdbNotFoundException;
import com.uwetrottmann.tmdb2.exceptions.TmdbServiceErrorException;
import com.uwetrottmann.tmdb2.services.AccountService;
import com.uwetrottmann.tmdb2.services.AuthenticationService;
import com.uwetrottmann.tmdb2.services.CertificationsService;
import com.uwetrottmann.tmdb2.services.ChangesService;
import com.uwetrottmann.tmdb2.services.CollectionsService;
import com.uwetrottmann.tmdb2.services.CompaniesService;
import com.uwetrottmann.tmdb2.services.ConfigurationService;
import com.uwetrottmann.tmdb2.services.CreditsService;
import com.uwetrottmann.tmdb2.services.DiscoverService;
import com.uwetrottmann.tmdb2.services.FindService;
import com.uwetrottmann.tmdb2.services.GenresService;
import com.uwetrottmann.tmdb2.services.GuestSessionService;
import com.uwetrottmann.tmdb2.services.KeywordsService;
import com.uwetrottmann.tmdb2.services.ListsService;
import com.uwetrottmann.tmdb2.services.MoviesService;
import com.uwetrottmann.tmdb2.services.NetworksService;
import com.uwetrottmann.tmdb2.services.PeopleService;
import com.uwetrottmann.tmdb2.services.ReviewsService;
import com.uwetrottmann.tmdb2.services.SearchService;
import com.uwetrottmann.tmdb2.services.TimezonesService;
import com.uwetrottmann.tmdb2.services.TvEpisodesService;
import com.uwetrottmann.tmdb2.services.TvSeasonsService;
import com.uwetrottmann.tmdb2.services.TvService;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Tmdb {
    public static final String API_HOST = "api.themoviedb.org";
    public static final String API_VERSION = "3";
    public static final String API_URL = "https://api.themoviedb.org/3/";
    public static final String PARAM_API_KEY = "api_key";
    public static final String PARAM_SESSION_ID = "session_id";
    public static final String PARAM_GUEST_SESSION_ID = "guest_session_id";
    public static final String PATH_AUTHENTICATION = "authentication";
    @Nullable
    private OkHttpClient okHttpClient;
    @Nullable
    private Retrofit retrofit;
    private String apiKey;
    private boolean useGuestSession = false;
    private boolean useAccountSession = false;
    @Nullable
    private String username;
    @Nullable
    private String password;
    @Nullable
    private String sessionId;
    @Nullable
    private String guestSessionId;

    public Tmdb(String apiKey) {
        this.apiKey = apiKey;
    }

    public void accountSession(String username, String password) {
        this.username = username;
        this.password = password;
        this.useAccountSession = true;
    }

    public void guestSession() {
        this.useGuestSession = true;
    }

    public void clearSessions() {
        this.username = null;
        this.password = null;
        this.useAccountSession = false;
        this.useGuestSession = false;
        this.setSessionId(null);
        this.setGuestSessionId(null);
    }

    public boolean useAccountSession() {
        return this.useAccountSession;
    }

    public boolean useGuestSession() {
        return this.useGuestSession;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    @Nullable
    public String getGuestSessionId() {
        return this.guestSessionId;
    }

    public void setGuestSessionId(@Nullable String guestSessionId) {
        this.guestSessionId = guestSessionId;
    }

    public boolean isLoggedIn() {
        return this.getSessionId() != null || this.getGuestSessionId() != null;
    }

    public void apiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String apiKey() {
        return this.apiKey;
    }

    protected Retrofit.Builder retrofitBuilder() {
        return new Retrofit.Builder().baseUrl(API_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)TmdbHelper.getGsonBuilder().create())).client(this.okHttpClient());
    }

    protected synchronized OkHttpClient okHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            this.setOkHttpClientDefaults(builder);
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }

    protected void setOkHttpClientDefaults(OkHttpClient.Builder builder) {
        builder.addInterceptor((Interceptor)new TmdbInterceptor(this)).authenticator((Authenticator)new TmdbAuthenticator(this));
    }

    protected Retrofit getRetrofit() {
        if (this.retrofit == null) {
            this.retrofit = this.retrofitBuilder().build();
        }
        return this.retrofit;
    }

    public void throwOnKnownError(Response response) throws IOException {
        if (response.isSuccessful()) {
            return;
        }
        ResponseBody responseBody = response.errorBody();
        if (responseBody == null) {
            return;
        }
        Status status = (Status)this.getRetrofit().responseBodyConverter(Status.class, Status.class.getAnnotations()).convert((Object)responseBody);
        if (status == null) {
            return;
        }
        Integer code = status.status_code;
        String message = status.status_message;
        switch (code) {
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 24: {
                throw new TmdbServiceErrorException(code, message);
            }
            case 3: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                throw new TmdbAuthenticationFailedException(code, message);
            }
            case 5: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: {
                throw new TmdbInvalidParametersException(code, message);
            }
            case 6: 
            case 34: {
                throw new TmdbNotFoundException(code, message);
            }
            case 8: {
                throw new TmdbDuplicateEntryException(code, message);
            }
        }
    }

    public AccountService accountService() {
        return (AccountService)this.getRetrofit().create(AccountService.class);
    }

    public AuthenticationService authenticationService() {
        return (AuthenticationService)this.getRetrofit().create(AuthenticationService.class);
    }

    public CertificationsService certificationsService() {
        return (CertificationsService)this.getRetrofit().create(CertificationsService.class);
    }

    public ChangesService changesService() {
        return (ChangesService)this.getRetrofit().create(ChangesService.class);
    }

    public CollectionsService collectionService() {
        return (CollectionsService)this.getRetrofit().create(CollectionsService.class);
    }

    public CompaniesService companiesService() {
        return (CompaniesService)this.getRetrofit().create(CompaniesService.class);
    }

    public ConfigurationService configurationService() {
        return (ConfigurationService)this.getRetrofit().create(ConfigurationService.class);
    }

    public CreditsService creditsService() {
        return (CreditsService)this.getRetrofit().create(CreditsService.class);
    }

    public DiscoverService discoverService() {
        return (DiscoverService)this.getRetrofit().create(DiscoverService.class);
    }

    public FindService findService() {
        return (FindService)this.getRetrofit().create(FindService.class);
    }

    public GenresService genreService() {
        return (GenresService)this.getRetrofit().create(GenresService.class);
    }

    public GuestSessionService guestSessionService() {
        return (GuestSessionService)this.getRetrofit().create(GuestSessionService.class);
    }

    public KeywordsService keywordsService() {
        return (KeywordsService)this.getRetrofit().create(KeywordsService.class);
    }

    public ListsService listsService() {
        return (ListsService)this.getRetrofit().create(ListsService.class);
    }

    public MoviesService moviesService() {
        return (MoviesService)this.getRetrofit().create(MoviesService.class);
    }

    public NetworksService networksService() {
        return (NetworksService)this.getRetrofit().create(NetworksService.class);
    }

    public PeopleService personService() {
        return (PeopleService)this.getRetrofit().create(PeopleService.class);
    }

    public ReviewsService reviewsService() {
        return (ReviewsService)this.getRetrofit().create(ReviewsService.class);
    }

    public SearchService searchService() {
        return (SearchService)this.getRetrofit().create(SearchService.class);
    }

    public TimezonesService timezonesService() {
        return (TimezonesService)this.getRetrofit().create(TimezonesService.class);
    }

    public TvService tvService() {
        return (TvService)this.getRetrofit().create(TvService.class);
    }

    public TvSeasonsService tvSeasonsService() {
        return (TvSeasonsService)this.getRetrofit().create(TvSeasonsService.class);
    }

    public TvEpisodesService tvEpisodesService() {
        return (TvEpisodesService)this.getRetrofit().create(TvEpisodesService.class);
    }

    public DiscoverMovieBuilder discoverMovie() {
        return new DiscoverMovieBuilder(this.discoverService());
    }

    public DiscoverTvBuilder discoverTv() {
        return new DiscoverTvBuilder(this.discoverService());
    }
}

