/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.anidb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.mediaprovider.IMediaArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.RingBuffer;
import org.tinymediamanager.scraper.util.Similarity;
import org.tinymediamanager.scraper.util.StrgUtils;

@PluginImplementation
public class AniDBMetadataProvider
implements ITvShowMetadataProvider,
IMediaArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AniDBMetadataProvider.class);
    private static final String IMAGE_SERVER = "http://img7.anidb.net/pics/anime/";
    private static final RingBuffer<Long> connectionCounter = new RingBuffer(1);
    private static MediaProviderInfo providerInfo = AniDBMetadataProvider.createMediaProviderInfo();
    private HashMap<String, List<AniDBShow>> showsForLookup = new HashMap();

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("anidb", "aniDB", "<html><h3>aniDB</h3><br />AniDB stands for Anime DataBase. AniDB is a non-profit anime database that is open freely to the public.</html>", AniDBMetadataProvider.class.getResource("/anidb_net.png"));
        providerInfo.setVersion(AniDBMetadataProvider.class);
        return providerInfo;
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions mediaScrapeOptions) throws ScrapeException, MissingIdException, NothingFoundException, UnsupportedMediaTypeException {
        switch (mediaScrapeOptions.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(mediaScrapeOptions);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(mediaScrapeOptions);
            }
        }
        throw new UnsupportedMediaTypeException(mediaScrapeOptions.getType());
    }

    private MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        InMemoryCachedUrl cachedUrl;
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        String langu = options.getLanguage().getLanguage();
        String id = options.getIdAsString(providerInfo.getId());
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{"anidb"});
        }
        Document doc = null;
        try {
            cachedUrl = new InMemoryCachedUrl("http://api.anidb.net:9001/httpapi?request=anime&client=tinymediamanager&clientver=2&protover=1&aid=" + id);
        }
        catch (Exception e) {
            LOGGER.error("failed to get TV show metadata: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        AniDBMetadataProvider.trackConnections();
        try {
            InputStream is = cachedUrl.getInputStream();
            Object object = null;
            try {
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("failed to get TV show metadata: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (doc == null || doc.children().isEmpty()) {
            throw new NothingFoundException();
        }
        md.setId(providerInfo.getId(), (Object)id);
        Element anime = doc.child(0);
        for (Element e : anime.children()) {
            if ("startdate".equalsIgnoreCase(e.tagName())) {
                try {
                    Date date = StrgUtils.parseDate((String)e.text());
                    md.setReleaseDate(date);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    md.setYear(calendar.get(1));
                }
                catch (ParseException date) {
                    // empty catch block
                }
            }
            if ("titles".equalsIgnoreCase(e.tagName())) {
                this.parseTitle(md, langu, e);
            }
            if ("description".equalsIgnoreCase(e.tagName())) {
                md.setPlot(e.text());
            }
            if ("ratings".equalsIgnoreCase(e.tagName())) {
                this.getRating(md, e);
            }
            if ("picture".equalsIgnoreCase(e.tagName())) {
                MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setPreviewUrl(IMAGE_SERVER + e.text());
                ma.setDefaultUrl(IMAGE_SERVER + e.text());
                ma.setLanguage(options.getLanguage().getLanguage());
                md.addMediaArt(ma);
            }
            if (!"characters".equalsIgnoreCase(e.tagName())) continue;
            this.getActors(md, e);
        }
        md.addGenre(MediaGenres.ANIME);
        return md;
    }

    private void getActors(MediaMetadata md, Element e) {
        for (Element character : e.children()) {
            MediaCastMember member = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            for (Element characterInfo : character.children()) {
                if ("name".equalsIgnoreCase(characterInfo.tagName())) {
                    member.setCharacter(characterInfo.text());
                }
                if (!"seiyuu".equalsIgnoreCase(characterInfo.tagName())) continue;
                member.setName(characterInfo.text());
                String image = characterInfo.attr("picture");
                if (!StringUtils.isNotBlank((CharSequence)image)) continue;
                member.setImageUrl(IMAGE_SERVER + image);
            }
            md.addCastMember(member);
        }
    }

    private void getRating(MediaMetadata md, Element e) {
        for (Element rating : e.children()) {
            if (!"temporary".equalsIgnoreCase(rating.tagName())) continue;
            try {
                MediaRating mediaRating = new MediaRating("anidb");
                mediaRating.setRating(Float.parseFloat(rating.text()));
                mediaRating.setVoteCount(Integer.parseInt(rating.attr("count")));
                mediaRating.setMaxValue(10);
                md.addRating(mediaRating);
                break;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
    }

    private void parseTitle(MediaMetadata md, String langu, Element e) {
        String titleEN = "";
        String titleScraperLangu = "";
        String titleFirst = "";
        for (Element title : e.children()) {
            if (StringUtils.isBlank((CharSequence)titleFirst)) {
                titleFirst = title.text();
            }
            if ("en".equalsIgnoreCase(title.attr("xml:lang"))) {
                titleEN = title.text();
            }
            if (!langu.equalsIgnoreCase(title.attr("xml:lang"))) continue;
            titleScraperLangu = title.text();
        }
        if (StringUtils.isNotBlank((CharSequence)titleScraperLangu)) {
            md.setTitle(titleScraperLangu);
        } else if (StringUtils.isNotBlank((CharSequence)titleEN)) {
            md.setTitle(titleEN);
        } else {
            md.setTitle(titleFirst);
        }
    }

    private MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException, UnsupportedMediaTypeException {
        MediaMetadata md = null;
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            throw new MissingIdException(new String[]{"seasonNr", "episodeNr"});
        }
        List<MediaMetadata> episodes = this.getEpisodeList(options);
        for (MediaMetadata episode : episodes) {
            if (episode.getEpisodeNumber() != episodeNr || episode.getSeasonNumber() != seasonNr) continue;
            md = episode;
            break;
        }
        if (md == null) {
            throw new NothingFoundException();
        }
        return md;
    }

    private List<Episode> parseEpisodes(Document doc) {
        ArrayList<Episode> episodes = new ArrayList<Episode>();
        Element anime = doc.child(0);
        Element eps = null;
        for (Element e : anime.children()) {
            if (!"episodes".equalsIgnoreCase(e.tagName())) continue;
            eps = e;
            break;
        }
        if (eps == null) {
            return episodes;
        }
        for (Element e : eps.children()) {
            if (!"episode".equals(e.tagName())) continue;
            Episode episode = new Episode();
            try {
                episode.id = Integer.parseInt(e.attr("id"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (Element episodeInfo : e.children()) {
                if ("epno".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.episode = Integer.parseInt(episodeInfo.text());
                        if ("1".equals(episodeInfo.attr("type"))) {
                            episode.season = 1;
                            continue;
                        }
                        episode.season = 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("length".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.runtime = Integer.parseInt(episodeInfo.text());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("airdate".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.airdate = StrgUtils.parseDate((String)episodeInfo.text());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ("rating".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.rating = Float.parseFloat(episodeInfo.text());
                        episode.votes = Integer.parseInt(episodeInfo.attr("votes"));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("title".equalsIgnoreCase(episodeInfo.tagName())) {
                    try {
                        episode.titles.put(episodeInfo.attr("xml:lang").toLowerCase(Locale.ROOT), episodeInfo.text());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!"summary".equalsIgnoreCase(episodeInfo.tagName())) continue;
                episode.summary = episodeInfo.text();
            }
            episodes.add(episode);
        }
        return episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaSearchResult> search(MediaSearchOptions options) throws UnsupportedMediaTypeException {
        LOGGER.debug("search() " + options.toString());
        if (options.getMediaType() != MediaType.TV_SHOW) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        Class<AniDBMetadataProvider> clazz = AniDBMetadataProvider.class;
        synchronized (AniDBMetadataProvider.class) {
            if (this.showsForLookup.size() == 0) {
                this.buildTitleHashMap();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ArrayList<MediaSearchResult> results = new ArrayList<MediaSearchResult>();
            String searchString = "";
            if (StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
                searchString = options.getQuery();
            }
            if (StringUtils.isEmpty((CharSequence)searchString)) {
                return results;
            }
            ArrayList<Integer> foundIds = new ArrayList<Integer>();
            for (Map.Entry<String, List<AniDBShow>> entry : this.showsForLookup.entrySet()) {
                String title = entry.getKey();
                float score = Similarity.compareStrings((String)title, (String)searchString);
                if (!((double)score > 0.4)) continue;
                for (AniDBShow show : entry.getValue()) {
                    if (foundIds.contains(show.aniDbId)) continue;
                    MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), MediaType.TV_SHOW);
                    result.setId(String.valueOf(show.aniDbId));
                    result.setTitle(show.title);
                    results.add(result);
                    result.setScore(score);
                    foundIds.add(show.aniDbId);
                }
            }
            Collections.sort(results);
            Collections.reverse(results);
            return results;
        }
    }

    public List<MediaMetadata> getEpisodeList(MediaScrapeOptions options) throws ScrapeException, MissingIdException, UnsupportedMediaTypeException {
        InMemoryCachedUrl url;
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        switch (options.getType()) {
            case TV_SHOW: 
            case TV_EPISODE: {
                break;
            }
            default: {
                throw new UnsupportedMediaTypeException(options.getType());
            }
        }
        String langu = options.getLanguage().getLanguage();
        String id = options.getIdAsString(providerInfo.getId());
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{providerInfo.getId()});
        }
        Document doc = null;
        try {
            url = new InMemoryCachedUrl("http://api.anidb.net:9001/httpapi?request=anime&client=tinymediamanager&clientver=2&protover=1&aid=" + id);
        }
        catch (Exception e) {
            LOGGER.error("error getting episode list: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        AniDBMetadataProvider.trackConnections();
        try (InputStream is = url.getInputStream();){
            doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("error getting episode list: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (doc == null || doc.children().isEmpty()) {
            return episodes;
        }
        for (Episode ep : this.parseEpisodes(doc)) {
            MediaMetadata md = new MediaMetadata(this.getProviderInfo().getId());
            md.setTitle(ep.titles.get(langu));
            md.setSeasonNumber(ep.season);
            md.setEpisodeNumber(ep.episode);
            if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                md.setTitle(ep.titles.get("en"));
            }
            if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                md.setTitle(ep.titles.get("x-jat"));
            }
            md.setPlot(ep.summary);
            if (ep.rating > 0.0f) {
                MediaRating rating = new MediaRating(this.getProviderInfo().getId());
                rating.setRating(ep.rating);
                rating.setVoteCount(ep.votes);
                rating.setMaxValue(10);
                md.addRating(rating);
            }
            md.setRuntime(ep.runtime);
            md.setReleaseDate(ep.airdate);
            md.setId(providerInfo.getId(), (Object)ep.id);
            episodes.add(md);
        }
        return episodes;
    }

    private void buildTitleHashMap() {
        OnDiskCachedUrl animeList;
        Pattern pattern = Pattern.compile("^(?!#)(\\d+)[|](\\d)[|]([\\w-]+)[|](.+)$");
        try {
            animeList = new OnDiskCachedUrl("http://anidb.net/api/anime-titles.dat.gz", 2, TimeUnit.DAYS);
        }
        catch (Exception e) {
            LOGGER.error("error getting AniDB index: {}", (Object)e.getMessage());
            return;
        }
        try (InputStream is = animeList.getInputStream();
             Scanner scanner = new Scanner((InputStream)new GZIPInputStream(is), "UTF-8");){
            while (scanner.hasNextLine()) {
                Matcher matcher = pattern.matcher(scanner.nextLine());
                if (!matcher.matches()) continue;
                AniDBShow show = new AniDBShow();
                show.aniDbId = Integer.parseInt(matcher.group(1));
                show.language = matcher.group(3);
                show.title = matcher.group(4);
                List shows = this.showsForLookup.computeIfAbsent(show.title, k -> new ArrayList());
                shows.add(show);
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOGGER.error("error getting AniDB index: {}", (Throwable)e);
        }
    }

    private static synchronized void trackConnections() {
        Long oldestConnection;
        Long currentTime = System.currentTimeMillis();
        if (connectionCounter.count() == connectionCounter.maxSize() && (oldestConnection = (Long)connectionCounter.getTailItem()) > currentTime - 2000L) {
            LOGGER.debug("connection limit reached, throttling " + connectionCounter);
            try {
                Thread.sleep(2000L - (currentTime - oldestConnection));
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        currentTime = System.currentTimeMillis();
        connectionCounter.add((Object)currentTime);
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        String id = "";
        if (options.getMetadata() != null) {
            id = (String)options.getMetadata().getId(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = options.getIdAsString(providerInfo.getId());
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new MissingIdException(new String[]{providerInfo.getId()});
        }
        switch (options.getArtworkType()) {
            case ALL: 
            case POSTER: {
                MediaMetadata md;
                try {
                    md = this.getTvShowMetadata(options);
                }
                catch (Exception e) {
                    LOGGER.error("could not get artwork: {}", (Object)e.getMessage());
                    throw new ScrapeException((Throwable)e);
                }
                artwork.addAll(md.getMediaArt(MediaArtwork.MediaArtworkType.POSTER));
                break;
            }
            default: {
                return artwork;
            }
        }
        return artwork;
    }

    private static class Episode {
        int id = -1;
        int episode = -1;
        int season = -1;
        int runtime = 0;
        Date airdate = null;
        float rating = 0.0f;
        int votes = 0;
        String summary = "";
        HashMap<String, String> titles = new HashMap();

        private Episode() {
        }
    }

    private static class AniDBShow {
        int aniDbId;
        String language;
        String title;

        private AniDBShow() {
        }
    }
}

