/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part15;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitReaderBuffer;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitWriterBuffer;
import org.mp4parser.tools.Hex;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

public class AvcDecoderConfigurationRecord {
    public int configurationVersion;
    public int avcProfileIndication;
    public int profileCompatibility;
    public int avcLevelIndication;
    public int lengthSizeMinusOne;
    public List<ByteBuffer> sequenceParameterSets = new ArrayList<ByteBuffer>();
    public List<ByteBuffer> pictureParameterSets = new ArrayList<ByteBuffer>();
    public boolean hasExts = true;
    public int chromaFormat = 1;
    public int bitDepthLumaMinus8 = 0;
    public int bitDepthChromaMinus8 = 0;
    public List<ByteBuffer> sequenceParameterSetExts = new ArrayList<ByteBuffer>();
    public int lengthSizeMinusOnePaddingBits = 63;
    public int numberOfSequenceParameterSetsPaddingBits = 7;
    public int chromaFormatPaddingBits = 31;
    public int bitDepthLumaMinus8PaddingBits = 31;
    public int bitDepthChromaMinus8PaddingBits = 31;

    public AvcDecoderConfigurationRecord() {
    }

    public AvcDecoderConfigurationRecord(ByteBuffer content) {
        this.configurationVersion = IsoTypeReader.readUInt8(content);
        this.avcProfileIndication = IsoTypeReader.readUInt8(content);
        this.profileCompatibility = IsoTypeReader.readUInt8(content);
        this.avcLevelIndication = IsoTypeReader.readUInt8(content);
        BitReaderBuffer brb = new BitReaderBuffer(content);
        this.lengthSizeMinusOnePaddingBits = brb.readBits(6);
        this.lengthSizeMinusOne = brb.readBits(2);
        this.numberOfSequenceParameterSetsPaddingBits = brb.readBits(3);
        int numberOfSeuqenceParameterSets = brb.readBits(5);
        int i = 0;
        while (i < numberOfSeuqenceParameterSets) {
            int sequenceParameterSetLength = IsoTypeReader.readUInt16(content);
            byte[] sequenceParameterSetNALUnit = new byte[sequenceParameterSetLength];
            content.get(sequenceParameterSetNALUnit);
            this.sequenceParameterSets.add(ByteBuffer.wrap(sequenceParameterSetNALUnit));
            ++i;
        }
        long numberOfPictureParameterSets = IsoTypeReader.readUInt8(content);
        int i2 = 0;
        while ((long)i2 < numberOfPictureParameterSets) {
            int pictureParameterSetLength = IsoTypeReader.readUInt16(content);
            byte[] pictureParameterSetNALUnit = new byte[pictureParameterSetLength];
            content.get(pictureParameterSetNALUnit);
            this.pictureParameterSets.add(ByteBuffer.wrap(pictureParameterSetNALUnit));
            ++i2;
        }
        if (content.remaining() < 4) {
            this.hasExts = false;
        }
        if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
            brb = new BitReaderBuffer(content);
            this.chromaFormatPaddingBits = brb.readBits(6);
            this.chromaFormat = brb.readBits(2);
            this.bitDepthLumaMinus8PaddingBits = brb.readBits(5);
            this.bitDepthLumaMinus8 = brb.readBits(3);
            this.bitDepthChromaMinus8PaddingBits = brb.readBits(5);
            this.bitDepthChromaMinus8 = brb.readBits(3);
            long numOfSequenceParameterSetExt = IsoTypeReader.readUInt8(content);
            int i3 = 0;
            while ((long)i3 < numOfSequenceParameterSetExt) {
                int sequenceParameterSetExtLength = IsoTypeReader.readUInt16(content);
                byte[] sequenceParameterSetExtNALUnit = new byte[sequenceParameterSetExtLength];
                content.get(sequenceParameterSetExtNALUnit);
                this.sequenceParameterSetExts.add(ByteBuffer.wrap(sequenceParameterSetExtNALUnit));
                ++i3;
            }
        } else {
            this.chromaFormat = -1;
            this.bitDepthLumaMinus8 = -1;
            this.bitDepthChromaMinus8 = -1;
        }
    }

    public void getContent(ByteBuffer byteBuffer) {
        IsoTypeWriter.writeUInt8(byteBuffer, this.configurationVersion);
        IsoTypeWriter.writeUInt8(byteBuffer, this.avcProfileIndication);
        IsoTypeWriter.writeUInt8(byteBuffer, this.profileCompatibility);
        IsoTypeWriter.writeUInt8(byteBuffer, this.avcLevelIndication);
        BitWriterBuffer bwb = new BitWriterBuffer(byteBuffer);
        bwb.writeBits(this.lengthSizeMinusOnePaddingBits, 6);
        bwb.writeBits(this.lengthSizeMinusOne, 2);
        bwb.writeBits(this.numberOfSequenceParameterSetsPaddingBits, 3);
        bwb.writeBits(this.pictureParameterSets.size(), 5);
        for (ByteBuffer sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            IsoTypeWriter.writeUInt16(byteBuffer, sequenceParameterSetNALUnit.limit());
            byteBuffer.put((ByteBuffer)sequenceParameterSetNALUnit.rewind());
        }
        IsoTypeWriter.writeUInt8(byteBuffer, this.pictureParameterSets.size());
        for (ByteBuffer pictureParameterSetNALUnit : this.pictureParameterSets) {
            IsoTypeWriter.writeUInt16(byteBuffer, pictureParameterSetNALUnit.limit());
            byteBuffer.put((ByteBuffer)pictureParameterSetNALUnit.rewind());
        }
        if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
            bwb = new BitWriterBuffer(byteBuffer);
            bwb.writeBits(this.chromaFormatPaddingBits, 6);
            bwb.writeBits(this.chromaFormat, 2);
            bwb.writeBits(this.bitDepthLumaMinus8PaddingBits, 5);
            bwb.writeBits(this.bitDepthLumaMinus8, 3);
            bwb.writeBits(this.bitDepthChromaMinus8PaddingBits, 5);
            bwb.writeBits(this.bitDepthChromaMinus8, 3);
            for (ByteBuffer sequenceParameterSetExtNALUnit : this.sequenceParameterSetExts) {
                IsoTypeWriter.writeUInt16(byteBuffer, sequenceParameterSetExtNALUnit.limit());
                byteBuffer.put((ByteBuffer)sequenceParameterSetExtNALUnit.reset());
            }
        }
    }

    public long getContentSize() {
        long size = 5L;
        ++size;
        for (ByteBuffer sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            size += 2L;
            size += (long)sequenceParameterSetNALUnit.limit();
        }
        ++size;
        for (ByteBuffer pictureParameterSetNALUnit : this.pictureParameterSets) {
            size += 2L;
            size += (long)pictureParameterSetNALUnit.limit();
        }
        if (this.hasExts && (this.avcProfileIndication == 100 || this.avcProfileIndication == 110 || this.avcProfileIndication == 122 || this.avcProfileIndication == 144)) {
            size += 4L;
            for (ByteBuffer sequenceParameterSetExtNALUnit : this.sequenceParameterSetExts) {
                size += 2L;
                size += (long)sequenceParameterSetExtNALUnit.limit();
            }
        }
        return size;
    }

    public List<String> getSequenceParameterSetsAsStrings() {
        ArrayList<String> result = new ArrayList<String>(this.sequenceParameterSets.size());
        for (ByteBuffer parameterSet : this.sequenceParameterSets) {
            result.add(Hex.encodeHex(parameterSet));
        }
        return result;
    }

    public List<String> getSequenceParameterSetExtsAsStrings() {
        ArrayList<String> result = new ArrayList<String>(this.sequenceParameterSetExts.size());
        for (ByteBuffer parameterSet : this.sequenceParameterSetExts) {
            result.add(Hex.encodeHex(parameterSet));
        }
        return result;
    }

    public List<String> getPictureParameterSetsAsStrings() {
        ArrayList<String> result = new ArrayList<String>(this.pictureParameterSets.size());
        for (ByteBuffer parameterSet : this.pictureParameterSets) {
            result.add(Hex.encodeHex(parameterSet));
        }
        return result;
    }

    public String toString() {
        return "AvcDecoderConfigurationRecord{configurationVersion=" + this.configurationVersion + ", avcProfileIndication=" + this.avcProfileIndication + ", profileCompatibility=" + this.profileCompatibility + ", avcLevelIndication=" + this.avcLevelIndication + ", lengthSizeMinusOne=" + this.lengthSizeMinusOne + ", hasExts=" + this.hasExts + ", chromaFormat=" + this.chromaFormat + ", bitDepthLumaMinus8=" + this.bitDepthLumaMinus8 + ", bitDepthChromaMinus8=" + this.bitDepthChromaMinus8 + ", lengthSizeMinusOnePaddingBits=" + this.lengthSizeMinusOnePaddingBits + ", numberOfSequenceParameterSetsPaddingBits=" + this.numberOfSequenceParameterSetsPaddingBits + ", chromaFormatPaddingBits=" + this.chromaFormatPaddingBits + ", bitDepthLumaMinus8PaddingBits=" + this.bitDepthLumaMinus8PaddingBits + ", bitDepthChromaMinus8PaddingBits=" + this.bitDepthChromaMinus8PaddingBits + '}';
    }
}

