/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Movie;
import com.uwetrottmann.trakt5.entities.MovieTranslation;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

class TraktMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktMovieMetadataProvider.class);
    private final TraktV2 api;

    TraktMovieMetadataProvider(TraktV2 api) {
        this.api = api;
    }

    List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException, UnsupportedMediaTypeException {
        String searchString = "";
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            searchString = options.getQuery();
        }
        String year = null;
        if (options.getYear() > 1800) {
            year = String.valueOf(options.getYear());
        }
        ArrayList<MediaSearchResult> results = new ArrayList<MediaSearchResult>();
        List searchResults = null;
        String lang = options.getLanguage().getLanguage();
        lang = lang + ",en";
        try {
            Response response = this.api.search().textQueryMovie(searchString, year, null, lang, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute();
            if (!response.isSuccessful()) {
                LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                throw new HttpException(response.code(), response.message());
            }
            searchResults = (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("Problem scraping for {} - {}", (Object)searchString, (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.info("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, result);
            m.setScore(MetadataUtil.calculateScore((String)searchString, (String)m.getTitle()));
            results.add(m);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata scrape(MediaScrapeOptions options) throws ScrapeException, UnsupportedMediaTypeException, MissingIdException, NothingFoundException {
        MovieTranslation trans;
        LOGGER.debug("getMetadata() - {}", (Object)options.toString());
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        if (options.getType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getType());
        }
        String id = options.getIdAsString(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"imdb", TraktMetadataProvider.providerInfo.getId()});
        }
        LOGGER.debug("Trakt.tv: getMetadata: id = {}", (Object)id);
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        Movie movie = null;
        Credits credits = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.movies().summary(id, Extended.FULL).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                movie = (Movie)response.body();
                if (!"en".equals(lang)) {
                    translations = (List)this.api.movies().translation(id, lang).execute().body();
                }
                credits = (Credits)this.api.movies().people(id).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
        if (movie == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        MovieTranslation movieTranslation = trans = translations == null || translations.isEmpty() ? null : (MovieTranslation)translations.get(0);
        if (trans != null) {
            md.setTitle(trans.title.isEmpty() ? movie.title : trans.title);
            md.setTagline(trans.tagline.isEmpty() ? movie.tagline : trans.tagline);
            md.setPlot(trans.overview.isEmpty() ? movie.overview : trans.overview);
        } else {
            md.setTitle(movie.title);
            md.setTagline(movie.tagline);
            md.setPlot(movie.overview);
        }
        md.setYear(movie.year);
        md.setRuntime(movie.runtime);
        md.addCertification(Certification.findCertification((String)movie.certification));
        md.setReleaseDate(TraktUtils.toDate(movie.released));
        MediaRating rating = new MediaRating("trakt");
        rating.setRating((double)Math.round(movie.rating * 10.0) / 10.0);
        rating.setVoteCount(movie.votes.intValue());
        rating.setMaxValue(10);
        md.addRating(rating);
        md.setId(TraktMetadataProvider.providerInfo.getId(), (Object)movie.ids.trakt);
        if (movie.ids.tmdb != null && movie.ids.tmdb > 0) {
            md.setId("tmdb", (Object)movie.ids.tmdb);
        }
        if (StringUtils.isNotBlank((CharSequence)movie.ids.imdb)) {
            md.setId("imdb", (Object)movie.ids.imdb);
        }
        for (String genreAsString : ListUtils.nullSafe((Iterable)movie.genres)) {
            md.addGenre(MediaGenres.getGenre((String)genreAsString));
        }
        if (credits != null) {
            for (CastMember cast : ListUtils.nullSafe((Iterable)credits.cast)) {
                md.addCastMember(TraktUtils.toTmmCast(cast, MediaCastMember.CastType.ACTOR));
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.directing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.DIRECTOR));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.production)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.PRODUCER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.writing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.WRITER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.costumeAndMakeUp)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.OTHER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.sound)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.OTHER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.camera)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.OTHER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.art)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.OTHER));
                }
            }
        }
        return md;
    }
}

