/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.universal_movie;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.events.PluginLoaded;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.config.MediaProviderConfig;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieTmdbMetadataProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;

@PluginImplementation
public class UniversalMovieMetadataProvider
implements IMovieMetadataProvider {
    private static final String UNDEFINED = "-";
    private static final String SEARCH = "search";
    private static final String RATINGS = "ratings";
    private static final Logger LOGGER = LoggerFactory.getLogger(UniversalMovieMetadataProvider.class);
    private final MediaProviderInfo providerInfo = UniversalMovieMetadataProvider.createMediaProviderInfo();
    private static final Map<String, IMovieMetadataProvider> compatibleScrapers = new HashMap<String, IMovieMetadataProvider>();

    @PluginLoaded
    public static void add(IMovieMetadataProvider plugin) {
        if ((plugin instanceof IMovieTmdbMetadataProvider || plugin instanceof IMovieImdbMetadataProvider) && !compatibleScrapers.containsKey(plugin.getProviderInfo().getId())) {
            compatibleScrapers.put(plugin.getProviderInfo().getId(), plugin);
        }
    }

    public void afterInitialization() {
        MediaProviderConfig config = this.providerInfo.getConfig();
        ArrayList<String> compatibleScraperIds = new ArrayList<String>(compatibleScrapers.keySet());
        compatibleScraperIds.add(0, UNDEFINED);
        config.addSelect(SEARCH, compatibleScraperIds, UNDEFINED);
        config.addSelect("title", "metatag.title", compatibleScraperIds, UNDEFINED);
        config.addSelect("originalTitle", "metatag.originaltitle", compatibleScraperIds, UNDEFINED);
        config.addSelect("tagline", "metatag.tagline", compatibleScraperIds, UNDEFINED);
        config.addSelect("year", "metatag.year", compatibleScraperIds, UNDEFINED);
        config.addSelect("releaseDate", "metatag.releasedate", compatibleScraperIds, UNDEFINED);
        config.addSelect("plot", "metatag.plot", compatibleScraperIds, UNDEFINED);
        config.addSelect("runtime", "metatag.runtime", compatibleScraperIds, UNDEFINED);
        config.addSelect(RATINGS, "metatag.rating", compatibleScraperIds, UNDEFINED);
        config.addSelect("top250", "metatag.top250", compatibleScraperIds.contains("imdb") ? Arrays.asList(UNDEFINED, "imdb") : Collections.singletonList(UNDEFINED), UNDEFINED);
        config.addSelect("genres", "metatag.genre", compatibleScraperIds, UNDEFINED);
        config.addSelect("certifications", "metatag.certification", compatibleScraperIds, UNDEFINED);
        config.addSelect("productionCompanies", "metatag.production", compatibleScraperIds, UNDEFINED);
        config.addSelect("castMembers", "metatag.cast", compatibleScraperIds, UNDEFINED);
        config.addSelect("spokenLanguages", "metatag.spokenlanguages", compatibleScraperIds, UNDEFINED);
        config.addSelect("countries", "metatag.country", compatibleScraperIds, UNDEFINED);
        config.addSelect("tags", "metatag.tags", compatibleScraperIds, UNDEFINED);
        config.addSelect("mediaArt", "metatag.artwork", compatibleScraperIds, UNDEFINED);
        config.addSelect("collectionName", "metatag.movieset", compatibleScraperIds.contains("tmdb") ? Arrays.asList(UNDEFINED, "tmdb") : Collections.singletonList(UNDEFINED), UNDEFINED);
        config.load();
    }

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("universal_movie", "Universal movie scraper", "<html><h3>Universal movie scraper</h3><br />A meta scraper which allows to collect data from several other scrapers</html>", UniversalMovieMetadataProvider.class.getResource("/logo.png"));
        providerInfo.setVersion(UniversalMovieMetadataProvider.class);
        return providerInfo;
    }

    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException, UnsupportedMediaTypeException {
        LOGGER.debug("search() " + options.toString());
        if (options.getMediaType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        IMovieMetadataProvider mp = compatibleScrapers.get(this.providerInfo.getConfig().getValue(SEARCH));
        if (mp == null) {
            return resultList;
        }
        try {
            for (MediaSearchResult result : mp.search(options)) {
                result.setProviderId(this.providerInfo.getId());
                resultList.add(result);
            }
        }
        catch (ScrapeException | UnsupportedMediaTypeException e) {
            LOGGER.warn("Could not call search method of " + mp.getProviderInfo().getId() + " : " + e.getMessage());
            throw e;
        }
        return resultList;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws UnsupportedMediaTypeException, NothingFoundException {
        String imdbId;
        LOGGER.debug("getMetadata() " + options.toString());
        if (options.getType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getType());
        }
        MediaMetadata md = new MediaMetadata(this.providerInfo.getId());
        Set<IMovieMetadataProvider> metadataProviders = this.getRelevantMetadataProviders();
        if (metadataProviders.isEmpty()) {
            return md;
        }
        if (!MetadataUtil.isValidImdbId((String)options.getImdbId()) && options.getTmdbId() > 0 && StringUtils.isNotBlank((CharSequence)(imdbId = MetadataUtil.getImdbIdViaTmdbId((int)options.getTmdbId())))) {
            options.setImdbId(imdbId);
        }
        Map<String, MediaMetadata> metadataMap = this.getMetadataMap(metadataProviders, options);
        this.assignResults(md, metadataMap);
        if (md.getIds().isEmpty()) {
            throw new NothingFoundException();
        }
        return md;
    }

    private Set<IMovieMetadataProvider> getRelevantMetadataProviders() {
        HashSet<IMovieMetadataProvider> metadataProviders = new HashSet<IMovieMetadataProvider>();
        for (Map.Entry entry : this.providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            IMovieMetadataProvider mp;
            if (UNDEFINED.equals(entry.getValue()) || (mp = compatibleScrapers.get(entry.getValue())) == null) continue;
            metadataProviders.add(mp);
        }
        return metadataProviders;
    }

    private Map<String, MediaMetadata> getMetadataMap(Set<IMovieMetadataProvider> metadataProviders, MediaScrapeOptions options) {
        String imdbId = options.getImdbId();
        int tmdbId = options.getTmdbId();
        HashMap<String, MediaMetadata> metadataMap = new HashMap<String, MediaMetadata>();
        for (IMovieMetadataProvider mp : metadataProviders) {
            if (mp instanceof IMovieImdbMetadataProvider && MetadataUtil.isValidImdbId((String)imdbId) || mp instanceof IMovieTmdbMetadataProvider && tmdbId > 0 || tmdbId <= 0 && !MetadataUtil.isValidImdbId((String)imdbId)) continue;
            MediaMetadata md = (MediaMetadata)metadataMap.get("tmdb");
            if (md == null) {
                try {
                    IMovieMetadataProvider tmdb = compatibleScrapers.get("tmdb");
                    if (tmdb != null && (md = tmdb.getMetadata(options)) != null) {
                        metadataMap.put("tmdb", md);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Could not get a result from scraper: " + e.getMessage());
                }
            }
            if (md == null) continue;
            if (tmdbId == 0) {
                try {
                    tmdbId = Integer.parseInt((String)md.getId("tmdb"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (MetadataUtil.isValidImdbId((String)imdbId) || !MetadataUtil.isValidImdbId((String)((String)md.getId("imdb")))) continue;
            imdbId = (String)md.getId("imdb");
        }
        if (MetadataUtil.isValidImdbId((String)imdbId)) {
            options.setImdbId(imdbId);
        }
        if (tmdbId > 0) {
            options.setTmdbId(tmdbId);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(metadataProviders.size());
        ExecutorCompletionService<MediaMetadata> completionService = new ExecutorCompletionService<MediaMetadata>(executorService);
        ArrayList<Future<MediaMetadata>> futures = new ArrayList<Future<MediaMetadata>>();
        for (IMovieMetadataProvider iMovieMetadataProvider : metadataProviders) {
            if (metadataMap.get(iMovieMetadataProvider.getProviderInfo().getId()) != null) continue;
            futures.add(completionService.submit(new MetadataProviderWorker(iMovieMetadataProvider, options)));
        }
        for (Future future : futures) {
            try {
                MediaMetadata mediaMetadata = (MediaMetadata)future.get();
                if (mediaMetadata == null) continue;
                metadataMap.put(mediaMetadata.getProviderId(), mediaMetadata);
            }
            catch (Exception e) {
                LOGGER.warn("Could not get a result from scraper: " + e.getMessage());
            }
        }
        return metadataMap;
    }

    private void assignResults(MediaMetadata md, Map<String, MediaMetadata> metadataMap) {
        for (Map.Entry<String, MediaMetadata> entry : metadataMap.entrySet()) {
            for (Map.Entry id : entry.getValue().getIds().entrySet()) {
                md.setId((String)id.getKey(), id.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : this.providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            if (SEARCH.equals(entry.getKey()) || UNDEFINED.equals(entry.getValue())) continue;
            MediaMetadata mediaMetadata = metadataMap.get(entry.getValue());
            if (mediaMetadata != null) {
                try {
                    Method getter = new PropertyDescriptor(entry.getKey(), MediaMetadata.class).getReadMethod();
                    Method setter = new PropertyDescriptor(entry.getKey(), MediaMetadata.class).getWriteMethod();
                    setter.invoke((Object)md, getter.invoke((Object)mediaMetadata, new Object[0]));
                }
                catch (Exception e) {
                    LOGGER.warn("Problem assigning " + entry.getKey() + " : " + e.getMessage());
                }
            }
            if (!RATINGS.equals(entry.getKey())) continue;
            for (Map.Entry<String, MediaMetadata> mediaMetadataEntry : metadataMap.entrySet()) {
                if (mediaMetadataEntry.getKey().equals(entry.getValue())) continue;
                for (MediaRating rating : mediaMetadataEntry.getValue().getRatings()) {
                    if (md.getRatings().contains(rating)) continue;
                    md.addRating(rating);
                }
            }
        }
    }

    protected class MetadataProviderWorker
    implements Callable<MediaMetadata> {
        private final IMovieMetadataProvider metadataProvider;
        private final MediaScrapeOptions mediaScrapeOptions;

        MetadataProviderWorker(IMovieMetadataProvider metadataProvider, MediaScrapeOptions mediaScrapeOptions) {
            this.metadataProvider = metadataProvider;
            this.mediaScrapeOptions = mediaScrapeOptions;
        }

        @Override
        public MediaMetadata call() throws Exception {
            return this.metadataProvider.getMetadata(this.mediaScrapeOptions);
        }
    }
}

