/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.spi;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.api.FileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AbstractFileSystem<T extends FileEntry>
implements FileSystem<T> {
    private RandomAccessFile channel;

    protected AbstractFileSystem(File file, boolean readOnly) throws IOException {
        if (!readOnly) {
            throw new IllegalArgumentException("Currrently, only read-only is supported");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
        this.channel = new RandomAccessFile(file, "r");
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.channel.close();
        }
        finally {
            this.channel = null;
        }
    }

    public synchronized boolean isClosed() {
        return null == this.channel;
    }

    protected final void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("File has been closed");
        }
    }

    protected final void seek(long pos) throws IOException {
        this.ensureOpen();
        this.channel.seek(pos);
    }

    protected final int read(byte[] buffer, int offset, int length) throws IOException {
        this.ensureOpen();
        return this.readFully(buffer, offset, length);
    }

    private int readFully(byte[] buffer, int offset, int length) throws IOException {
        int remaining;
        int bytesRead;
        for (remaining = length; remaining != 0 && (bytesRead = this.channel.read(buffer, offset, remaining)) != -1; remaining -= bytesRead) {
            offset += bytesRead;
        }
        int totalBytesRead = length - remaining;
        return totalBytesRead;
    }
}

