/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.jsonrpc.io.Base64;

public class JsonApiRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonApiRequest.class);
    private static final String TAG = JsonApiRequest.class.getSimpleName();
    private static final int REQUEST_TIMEOUT = 5000;
    private static final ObjectMapper OM = new ObjectMapper();

    public static ObjectNode execute(HostConfig config, ObjectNode entity) throws ApiException {
        String response = JsonApiRequest.postRequest(config, entity.toString());
        LOGGER.debug("Response: {}", (Object)response);
        return JsonApiRequest.parseResponse(response);
    }

    private static String postRequest(HostConfig config, String entity) throws ApiException {
        try {
            URL url = new URL("http", config.getAddress(), config.getHttpPort(), "/jsonrpc");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            if (config.getUsername() != null && !config.getUsername().isEmpty() && config.getPassword() != null && !config.getPassword().isEmpty()) {
                String token = Base64.encodeToString((config.getUsername() + ":" + config.getPassword()).getBytes(), false);
                conn.setRequestProperty("Authorization", "Basic " + token);
            }
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("User-Agent", JsonApiRequest.buildUserAgent());
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setDoOutput(true);
            LOGGER.debug("Request: {}", (Object)entity.toString());
            try {
                OutputStreamWriter output = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
                output.write(entity);
                output.close();
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiException(9, "Unable to convert request to UTF-8", e);
            }
            StringBuilder response = new StringBuilder();
            BufferedReader reader = null;
            int code = conn.getResponseCode();
            if (code == 200) {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"), 8192);
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new ApiException(9, "Unable to convert HTTP response to UTF-8", e);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                return response.toString();
            }
            switch (code) {
                case 400: {
                    throw new ApiException(19, "Server says \"400 Bad HTTP request\".");
                }
                case 401: {
                    throw new ApiException(20, "Server says \"401 Unauthorized\".");
                }
                case 403: {
                    throw new ApiException(21, "Server says \"403 Forbidden\".");
                }
                case 404: {
                    throw new ApiException(22, "Server says \"404 Not Found\".");
                }
            }
            if (code >= 100 && code < 200) {
                throw new ApiException(14, "Server returned informational code " + code + " instead of 200.");
            }
            if (code >= 200 && code < 300) {
                throw new ApiException(15, "Server returned success code " + code + " instead of 200.");
            }
            if (code >= 300 && code < 400) {
                throw new ApiException(16, "Server returned redirection code " + code + " instead of 200.");
            }
            if (code >= 400 && code < 500) {
                throw new ApiException(17, "Server returned client error " + code + ".");
            }
            if (code >= 500 && code < 600) {
                throw new ApiException(18, "Server returned server error " + code + ".");
            }
            throw new ApiException(13, "Server returned unspecified code " + code + ".");
        }
        catch (MalformedURLException e) {
            throw new ApiException(1, e.getMessage(), e);
        }
        catch (SocketTimeoutException e) {
            throw new ApiException(6, e.getMessage(), e);
        }
        catch (ConnectException e) {
            throw new ApiException(5, e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiException(2, e.getMessage(), e);
        }
    }

    private static ObjectNode parseResponse(String response) throws ApiException {
        try {
            ObjectNode node = (ObjectNode)OM.readTree(response.toString());
            if (node.has("error")) {
                if (node.get("error").isTextual()) {
                    TextNode error = (TextNode)node.get("error");
                    throw new ApiException(12, "Error: " + error.getTextValue(), null);
                }
                ObjectNode error = (ObjectNode)node.get("error");
                throw new ApiException(12, "Error " + error.get("code").getIntValue() + ": " + error.get("message").getTextValue(), null);
            }
            if (!node.has("result")) {
                throw new ApiException(11, "Neither result nor error object found in response.", null);
            }
            if (node.get("result").isNull()) {
                return null;
            }
            return node;
        }
        catch (JsonProcessingException e) {
            throw new ApiException(10, "Parse error: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiException(10, "Parse error: " + e.getMessage(), e);
        }
    }

    private static String buildUserAgent() {
        return "tinyMediaManager-jsonrpclib-kodi";
    }
}

