/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.io;

import org.codehaus.jackson.JsonNode;

public class ApiException
extends Exception {
    private static final String TAG = ApiException.class.getSimpleName();
    public static final int MALFORMED_URL = 1;
    public static final int IO_EXCEPTION = 2;
    public static final int IO_EXCEPTION_WHILE_READING = 3;
    public static final int IO_EXCEPTION_WHILE_WRITING = 4;
    public static final int IO_EXCEPTION_WHILE_OPENING = 5;
    public static final int IO_SOCKETTIMEOUT = 6;
    public static final int IO_UNKNOWN_HOST = 7;
    public static final int IO_DISCONNECTED = 8;
    public static final int UNSUPPORTED_ENCODING = 9;
    public static final int JSON_EXCEPTION = 10;
    public static final int RESPONSE_ERROR = 11;
    public static final int API_ERROR = 12;
    public static final int HTTP_UNKNOWN = 13;
    public static final int HTTP_INFO = 14;
    public static final int HTTP_SUCCESS = 15;
    public static final int HTTP_REDIRECTION = 16;
    public static final int HTTP_CLIENT_ERROR = 17;
    public static final int HTTP_SERVER_ERROR = 18;
    public static final int HTTP_BAD_REQUEST = 19;
    public static final int HTTP_UNAUTHORIZED = 20;
    public static final int HTTP_FORBIDDEN = 21;
    public static final int HTTP_NOT_FOUND = 22;
    public static final String EXTRA_ERROR_CODE = "org.xbmc.android.jsonprc.extra.ERROR_CODE";
    public static final String EXTRA_ERROR_MESSAGE = "org.xbmc.android.jsonprc.extra.ERROR_MESSAGE";
    public static final String EXTRA_ERROR_HINT = "org.xbmc.android.jsonprc.extra.ERROR_HINT";
    private int code;
    private static final long serialVersionUID = -8668163106123710291L;

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public ApiException(JsonNode node) {
        super(node.get("error").get("message").getValueAsText());
        StringBuilder sb = new StringBuilder("API Error: ");
        try {
            this.code = 12;
            sb.append("Error in ");
            sb.append(node.get("error").get("data").get("method").getValueAsText());
            sb.append(" for ");
            sb.append(node.get("error").get("data").get("stack").get("name").getValueAsText());
            sb.append(": ");
            sb.append(node.get("error").get("data").get("stack").get("property").get("message").getValueAsText());
        }
        catch (NullPointerException e) {
            throw new RuntimeException(node.toString());
        }
    }

    public int getCode() {
        return this.code;
    }
}

