/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.config;

import java.util.Locale;

public class HostConfig {
    public final String mAddress;
    public final int mHttpPort;
    public final int mTcpPort;
    public final String mUsername;
    public final String mPassword;
    private static int DEFAULT_HTTP_PORT = 8080;

    public HostConfig(String address) {
        this(address, DEFAULT_HTTP_PORT);
    }

    public HostConfig(String address, int httpPort) {
        this(address, httpPort, 9090);
    }

    public HostConfig(String address, int httpPort, int tcpPort) {
        this(address, httpPort, tcpPort, null, null);
    }

    public HostConfig(String address, int httpPort, String username, String password) {
        this(address, httpPort, 9090, username, password);
    }

    public HostConfig(String address, String httpPort, String tcpPort, String username, String password) {
        int h = 0;
        int t = 0;
        try {
            h = Integer.parseInt(httpPort);
            t = Integer.parseInt(tcpPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mAddress = address;
        this.mHttpPort = h == 0 ? DEFAULT_HTTP_PORT : h;
        this.mTcpPort = t == 0 ? 9090 : t;
        this.mUsername = username;
        this.mPassword = password;
    }

    public HostConfig(String address, int httpPort, int tcpPort, String username, String password) {
        this.mAddress = address;
        this.mHttpPort = httpPort == 0 ? DEFAULT_HTTP_PORT : httpPort;
        this.mTcpPort = tcpPort == 0 ? 9090 : tcpPort;
        this.mUsername = username;
        this.mPassword = password;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public int getHttpPort() {
        return this.mHttpPort;
    }

    public int getTcpPort() {
        return this.mTcpPort;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    static {
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows")) {
            DEFAULT_HTTP_PORT = 80;
        }
    }
}

