/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class TexturesModel {

    public static interface TextureFields {
        public static final String URL = "url";
        public static final String CACHEDURL = "cachedurl";
        public static final String LASTHASHCHECK = "lasthashcheck";
        public static final String IMAGEHASH = "imagehash";
        public static final String SIZES = "sizes";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("url", "cachedurl", "lasthashcheck", "imagehash", "sizes"));
    }

    public static class TextureDetail
    extends AbstractModel {
        public static final String API_TYPE = "Textures.Details.Texture";
        public static final String CACHEDURL = "cachedurl";
        public static final String IMAGEHASH = "imagehash";
        public static final String LASTHASHCHECK = "lasthashcheck";
        public static final String SIZES = "sizes";
        public static final String TEXTUREID = "textureid";
        public static final String URL = "url";
        public final String cachedurl;
        public final String imagehash;
        public final String lasthashcheck;
        public final List<SizeDetail> sizes;
        public final Integer textureid;
        public final String url;

        public TextureDetail(String cachedurl, String imagehash, String lasthashcheck, List<SizeDetail> sizes, Integer textureid, String url) {
            this.cachedurl = cachedurl;
            this.imagehash = imagehash;
            this.lasthashcheck = lasthashcheck;
            this.sizes = sizes;
            this.textureid = textureid;
            this.url = url;
        }

        public TextureDetail(JsonNode node) {
            this.cachedurl = TextureDetail.parseString(node, CACHEDURL);
            this.imagehash = TextureDetail.parseString(node, IMAGEHASH);
            this.lasthashcheck = TextureDetail.parseString(node, LASTHASHCHECK);
            this.sizes = SizeDetail.getTexturesModelSizeDetailList(node, SIZES);
            this.textureid = TextureDetail.parseInt(node, TEXTUREID);
            this.url = TextureDetail.parseString(node, URL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(CACHEDURL, this.cachedurl);
            node.put(IMAGEHASH, this.imagehash);
            node.put(LASTHASHCHECK, this.lasthashcheck);
            ArrayNode sizesArray = OM.createArrayNode();
            for (SizeDetail item : this.sizes) {
                sizesArray.add(item.toJsonNode());
            }
            node.put(SIZES, (JsonNode)sizesArray);
            node.put(TEXTUREID, this.textureid);
            node.put(URL, this.url);
            return node;
        }

        static List<TextureDetail> getTexturesModelTextureDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<TextureDetail> l = new ArrayList<TextureDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new TextureDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<TextureDetail>(0);
        }
    }

    public static class SizeDetail
    extends AbstractModel {
        public static final String API_TYPE = "Textures.Details.Size";
        public static final String HEIGHT = "height";
        public static final String LASTUSED = "lastused";
        public static final String SIZE = "size";
        public static final String USECOUNT = "usecount";
        public static final String WIDTH = "width";
        public final Integer height;
        public final String lastused;
        public final Integer size;
        public final Integer usecount;
        public final Integer width;

        public SizeDetail(Integer height, String lastused, Integer size, Integer usecount, Integer width) {
            this.height = height;
            this.lastused = lastused;
            this.size = size;
            this.usecount = usecount;
            this.width = width;
        }

        public SizeDetail(JsonNode node) {
            this.height = SizeDetail.parseInt(node, HEIGHT);
            this.lastused = SizeDetail.parseString(node, LASTUSED);
            this.size = SizeDetail.parseInt(node, SIZE);
            this.usecount = SizeDetail.parseInt(node, USECOUNT);
            this.width = SizeDetail.parseInt(node, WIDTH);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(HEIGHT, this.height);
            node.put(LASTUSED, this.lastused);
            node.put(SIZE, this.size);
            node.put(USECOUNT, this.usecount);
            node.put(WIDTH, this.width);
            return node;
        }

        static List<SizeDetail> getTexturesModelSizeDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<SizeDetail> l = new ArrayList<SizeDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new SizeDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<SizeDetail>(0);
        }
    }
}

