/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;

public final class PVRModel {

    public static interface TimerState {
        public static final String UNKNOWN = "unknown";
        public static final String NEW = "new";
        public static final String SCHEDULED = "scheduled";
        public static final String RECORDING = "recording";
        public static final String COMPLETED = "completed";
        public static final String ABORTED = "aborted";
        public static final String CANCELLED = "cancelled";
        public static final String CONFLICT_OK = "conflict_ok";
        public static final String CONFLICT_NOTOK = "conflict_notok";
        public static final String ERROR = "error";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "new", "scheduled", "recording", "completed", "aborted", "cancelled", "conflict_ok", "conflict_notok", "error"));
    }

    public static interface PropertyName {
        public static final String AVAILABLE = "available";
        public static final String RECORDING = "recording";
        public static final String SCANNING = "scanning";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("available", "recording", "scanning"));
    }

    public static interface TimerFields {
        public static final String TITLE = "title";
        public static final String SUMMARY = "summary";
        public static final String CHANNELID = "channelid";
        public static final String ISRADIO = "isradio";
        public static final String REPEATING = "repeating";
        public static final String STARTTIME = "starttime";
        public static final String ENDTIME = "endtime";
        public static final String RUNTIME = "runtime";
        public static final String LIFETIME = "lifetime";
        public static final String FIRSTDAY = "firstday";
        public static final String WEEKDAYS = "weekdays";
        public static final String PRIORITY = "priority";
        public static final String STARTMARGIN = "startmargin";
        public static final String ENDMARGIN = "endmargin";
        public static final String STATE = "state";
        public static final String FILE = "file";
        public static final String DIRECTORY = "directory";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "summary", "channelid", "isradio", "repeating", "starttime", "endtime", "runtime", "lifetime", "firstday", "weekdays", "priority", "startmargin", "endmargin", "state", "file", "directory"));
    }

    public static interface RecordingFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String GENRE = "genre";
        public static final String PLAYCOUNT = "playcount";
        public static final String RESUME = "resume";
        public static final String CHANNEL = "channel";
        public static final String STARTTIME = "starttime";
        public static final String ENDTIME = "endtime";
        public static final String RUNTIME = "runtime";
        public static final String LIFETIME = "lifetime";
        public static final String ICON = "icon";
        public static final String ART = "art";
        public static final String STREAMURL = "streamurl";
        public static final String FILE = "file";
        public static final String DIRECTORY = "directory";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "plotoutline", "genre", "playcount", "resume", "channel", "starttime", "endtime", "runtime", "lifetime", "icon", "art", "streamurl", "file", "directory"));
    }

    public static interface ChannelFields {
        public static final String THUMBNAIL = "thumbnail";
        public static final String CHANNELTYPE = "channeltype";
        public static final String HIDDEN = "hidden";
        public static final String LOCKED = "locked";
        public static final String CHANNEL = "channel";
        public static final String LASTPLAYED = "lastplayed";
        public static final String BROADCASTNOW = "broadcastnow";
        public static final String BROADCASTNEXT = "broadcastnext";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("thumbnail", "channeltype", "hidden", "locked", "channel", "lastplayed", "broadcastnow", "broadcastnext"));
    }

    public static interface BroadcastFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String STARTTIME = "starttime";
        public static final String ENDTIME = "endtime";
        public static final String RUNTIME = "runtime";
        public static final String PROGRESS = "progress";
        public static final String PROGRESSPERCENTAGE = "progresspercentage";
        public static final String GENRE = "genre";
        public static final String EPISODENAME = "episodename";
        public static final String EPISODENUM = "episodenum";
        public static final String EPISODEPART = "episodepart";
        public static final String FIRSTAIRED = "firstaired";
        public static final String HASTIMER = "hastimer";
        public static final String ISACTIVE = "isactive";
        public static final String PARENTALRATING = "parentalrating";
        public static final String WASACTIVE = "wasactive";
        public static final String THUMBNAIL = "thumbnail";
        public static final String RATING = "rating";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "plotoutline", "starttime", "endtime", "runtime", "progress", "progresspercentage", "genre", "episodename", "episodenum", "episodepart", "firstaired", "hastimer", "isactive", "parentalrating", "wasactive", "thumbnail", "rating"));
    }

    public static interface ChannelType {
        public static final String TV = "tv";
        public static final String RADIO = "radio";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("tv", "radio"));
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "PVR.Property.Value";
        public static final String AVAILABLE = "available";
        public static final String RECORDING = "recording";
        public static final String SCANNING = "scanning";
        public final Boolean available;
        public final Boolean recording;
        public final Boolean scanning;

        public PropertyValue(Boolean available, Boolean recording, Boolean scanning) {
            this.available = available;
            this.recording = recording;
            this.scanning = scanning;
        }

        public PropertyValue(JsonNode node) {
            this.available = PropertyValue.parseBoolean(node, AVAILABLE);
            this.recording = PropertyValue.parseBoolean(node, RECORDING);
            this.scanning = PropertyValue.parseBoolean(node, SCANNING);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = OM.createObjectNode();
            node.put(AVAILABLE, this.available);
            node.put(RECORDING, this.recording);
            node.put(SCANNING, this.scanning);
            return node;
        }

        static List<PropertyValue> getPVRModelPropertyValueList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<PropertyValue> l = new ArrayList<PropertyValue>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new PropertyValue(a.get(i)));
                }
                return l;
            }
            return new ArrayList<PropertyValue>(0);
        }
    }

    public static class TimerDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.Timer";
        public static final String CHANNELID = "channelid";
        public static final String DIRECTORY = "directory";
        public static final String ENDMARGIN = "endmargin";
        public static final String ENDTIME = "endtime";
        public static final String FILE = "file";
        public static final String FIRSTDAY = "firstday";
        public static final String ISRADIO = "isradio";
        public static final String LIFETIME = "lifetime";
        public static final String PRIORITY = "priority";
        public static final String REPEATING = "repeating";
        public static final String RUNTIME = "runtime";
        public static final String STARTMARGIN = "startmargin";
        public static final String STARTTIME = "starttime";
        public static final String STATE = "state";
        public static final String SUMMARY = "summary";
        public static final String TIMERID = "timerid";
        public static final String TITLE = "title";
        public static final String WEEKDAYS = "weekdays";
        public final Integer channelid;
        public final String directory;
        public final Integer endmargin;
        public final String endtime;
        public final String file;
        public final String firstday;
        public final Boolean isradio;
        public final Integer lifetime;
        public final Integer priority;
        public final Boolean repeating;
        public final Integer runtime;
        public final Integer startmargin;
        public final String starttime;
        public final String state;
        public final String summary;
        public final Integer timerid;
        public final String title;
        public final String weekdays;

        public TimerDetail(JsonNode node) {
            super(node);
            this.channelid = TimerDetail.parseInt(node, CHANNELID);
            this.directory = TimerDetail.parseString(node, DIRECTORY);
            this.endmargin = TimerDetail.parseInt(node, ENDMARGIN);
            this.endtime = TimerDetail.parseString(node, ENDTIME);
            this.file = TimerDetail.parseString(node, FILE);
            this.firstday = TimerDetail.parseString(node, FIRSTDAY);
            this.isradio = TimerDetail.parseBoolean(node, ISRADIO);
            this.lifetime = TimerDetail.parseInt(node, LIFETIME);
            this.priority = TimerDetail.parseInt(node, PRIORITY);
            this.repeating = TimerDetail.parseBoolean(node, REPEATING);
            this.runtime = TimerDetail.parseInt(node, RUNTIME);
            this.startmargin = TimerDetail.parseInt(node, STARTMARGIN);
            this.starttime = TimerDetail.parseString(node, STARTTIME);
            this.state = TimerDetail.parseString(node, STATE);
            this.summary = TimerDetail.parseString(node, SUMMARY);
            this.timerid = TimerDetail.parseInt(node, TIMERID);
            this.title = TimerDetail.parseString(node, TITLE);
            this.weekdays = TimerDetail.parseString(node, WEEKDAYS);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(CHANNELID, this.channelid);
            node.put(DIRECTORY, this.directory);
            node.put(ENDMARGIN, this.endmargin);
            node.put(ENDTIME, this.endtime);
            node.put(FILE, this.file);
            node.put(FIRSTDAY, this.firstday);
            node.put(ISRADIO, this.isradio);
            node.put(LIFETIME, this.lifetime);
            node.put(PRIORITY, this.priority);
            node.put(REPEATING, this.repeating);
            node.put(RUNTIME, this.runtime);
            node.put(STARTMARGIN, this.startmargin);
            node.put(STARTTIME, this.starttime);
            node.put(STATE, this.state);
            node.put(SUMMARY, this.summary);
            node.put(TIMERID, this.timerid);
            node.put(TITLE, this.title);
            node.put(WEEKDAYS, this.weekdays);
            return node;
        }

        static List<TimerDetail> getPVRModelTimerDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<TimerDetail> l = new ArrayList<TimerDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new TimerDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<TimerDetail>(0);
        }

        public static interface Weekday {
            public static final String MONDAY = "monday";
            public static final String TUESDAY = "tuesday";
            public static final String WEDNESDAY = "wednesday";
            public static final String THURSDAY = "thursday";
            public static final String FRIDAY = "friday";
            public static final String SATURDAY = "saturday";
            public static final String SUNDAY = "sunday";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"));
        }

        public static interface State {
            public static final String UNKNOWN = "unknown";
            public static final String NEW = "new";
            public static final String SCHEDULED = "scheduled";
            public static final String RECORDING = "recording";
            public static final String COMPLETED = "completed";
            public static final String ABORTED = "aborted";
            public static final String CANCELLED = "cancelled";
            public static final String CONFLICT_OK = "conflict_ok";
            public static final String CONFLICT_NOTOK = "conflict_notok";
            public static final String ERROR = "error";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "new", "scheduled", "recording", "completed", "aborted", "cancelled", "conflict_ok", "conflict_notok", "error"));
        }
    }

    public static class RecordingDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.Recording";
        public static final String ART = "art";
        public static final String CHANNEL = "channel";
        public static final String DIRECTORY = "directory";
        public static final String ENDTIME = "endtime";
        public static final String FILE = "file";
        public static final String GENRE = "genre";
        public static final String ICON = "icon";
        public static final String LIFETIME = "lifetime";
        public static final String PLAYCOUNT = "playcount";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String RECORDINGID = "recordingid";
        public static final String RESUME = "resume";
        public static final String RUNTIME = "runtime";
        public static final String STARTTIME = "starttime";
        public static final String STREAMURL = "streamurl";
        public static final String TITLE = "title";
        public final MediaModel.Artwork art;
        public final String channel;
        public final String directory;
        public final String endtime;
        public final String file;
        public final String genre;
        public final String icon;
        public final Integer lifetime;
        public final Integer playcount;
        public final String plot;
        public final String plotoutline;
        public final Integer recordingid;
        public final VideoModel.Resume resume;
        public final Integer runtime;
        public final String starttime;
        public final String streamurl;
        public final String title;

        public RecordingDetail(JsonNode node) {
            super(node);
            this.art = node.has(ART) ? new MediaModel.Artwork(node.get(ART)) : null;
            this.channel = RecordingDetail.parseString(node, CHANNEL);
            this.directory = RecordingDetail.parseString(node, DIRECTORY);
            this.endtime = RecordingDetail.parseString(node, ENDTIME);
            this.file = RecordingDetail.parseString(node, FILE);
            this.genre = RecordingDetail.parseString(node, GENRE);
            this.icon = RecordingDetail.parseString(node, ICON);
            this.lifetime = RecordingDetail.parseInt(node, LIFETIME);
            this.playcount = RecordingDetail.parseInt(node, PLAYCOUNT);
            this.plot = RecordingDetail.parseString(node, PLOT);
            this.plotoutline = RecordingDetail.parseString(node, PLOTOUTLINE);
            this.recordingid = RecordingDetail.parseInt(node, RECORDINGID);
            this.resume = node.has(RESUME) ? new VideoModel.Resume(node.get(RESUME)) : null;
            this.runtime = RecordingDetail.parseInt(node, RUNTIME);
            this.starttime = RecordingDetail.parseString(node, STARTTIME);
            this.streamurl = RecordingDetail.parseString(node, STREAMURL);
            this.title = RecordingDetail.parseString(node, TITLE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(ART, this.art == null ? null : this.art.toJsonNode());
            node.put(CHANNEL, this.channel);
            node.put(DIRECTORY, this.directory);
            node.put(ENDTIME, this.endtime);
            node.put(FILE, this.file);
            node.put(GENRE, this.genre);
            node.put(ICON, this.icon);
            node.put(LIFETIME, this.lifetime);
            node.put(PLAYCOUNT, this.playcount);
            node.put(PLOT, this.plot);
            node.put(PLOTOUTLINE, this.plotoutline);
            node.put(RECORDINGID, this.recordingid);
            node.put(RESUME, this.resume == null ? null : this.resume.toJsonNode());
            node.put(RUNTIME, this.runtime);
            node.put(STARTTIME, this.starttime);
            node.put(STREAMURL, this.streamurl);
            node.put(TITLE, this.title);
            return node;
        }

        static List<RecordingDetail> getPVRModelRecordingDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<RecordingDetail> l = new ArrayList<RecordingDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new RecordingDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<RecordingDetail>(0);
        }
    }

    public static class ChannelGroupExtendedDetail
    extends ChannelGroupDetail {
        public static final String API_TYPE = "PVR.Details.ChannelGroup.Extended";
        public static final String CHANNELS = "channels";
        public static final String LIMITS = "limits";
        public final List<ChannelDetail> channels;
        public final ListModel.LimitsReturned limits;

        public ChannelGroupExtendedDetail(JsonNode node) {
            super(node);
            this.channels = ChannelDetail.getPVRModelChannelDetailList(node, CHANNELS);
            this.limits = node.has(LIMITS) ? new ListModel.LimitsReturned(node.get(LIMITS)) : null;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            ArrayNode channelsArray = OM.createArrayNode();
            for (ChannelDetail item : this.channels) {
                channelsArray.add(item.toJsonNode());
            }
            node.put(CHANNELS, (JsonNode)channelsArray);
            node.put(LIMITS, this.limits == null ? null : this.limits.toJsonNode());
            return node;
        }

        static List<ChannelGroupExtendedDetail> getPVRModelChannelGroupExtendedDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ChannelGroupExtendedDetail> l = new ArrayList<ChannelGroupExtendedDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ChannelGroupExtendedDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ChannelGroupExtendedDetail>(0);
        }
    }

    public static class ChannelGroupDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.ChannelGroup";
        public static final String CHANNELGROUPID = "channelgroupid";
        public static final String CHANNELTYPE = "channeltype";
        public final Integer channelgroupid;
        public final String channeltype;

        public ChannelGroupDetail(JsonNode node) {
            super(node);
            this.channelgroupid = ChannelGroupDetail.parseInt(node, CHANNELGROUPID);
            this.channeltype = ChannelGroupDetail.parseString(node, CHANNELTYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(CHANNELGROUPID, this.channelgroupid);
            node.put(CHANNELTYPE, this.channeltype);
            return node;
        }

        static List<ChannelGroupDetail> getPVRModelChannelGroupDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ChannelGroupDetail> l = new ArrayList<ChannelGroupDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ChannelGroupDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ChannelGroupDetail>(0);
        }

        public static interface Channeltype {
            public static final String TV = "tv";
            public static final String RADIO = "radio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("tv", "radio"));
        }
    }

    public static class ChannelDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.Channel";
        public static final String BROADCASTNEXT = "broadcastnext";
        public static final String BROADCASTNOW = "broadcastnow";
        public static final String CHANNEL = "channel";
        public static final String CHANNELID = "channelid";
        public static final String CHANNELTYPE = "channeltype";
        public static final String HIDDEN = "hidden";
        public static final String LASTPLAYED = "lastplayed";
        public static final String LOCKED = "locked";
        public static final String THUMBNAIL = "thumbnail";
        public final BroadcastDetail broadcastnext;
        public final BroadcastDetail broadcastnow;
        public final String channel;
        public final Integer channelid;
        public final String channeltype;
        public final Boolean hidden;
        public final String lastplayed;
        public final Boolean locked;
        public final String thumbnail;

        public ChannelDetail(JsonNode node) {
            super(node);
            this.broadcastnext = node.has(BROADCASTNEXT) ? new BroadcastDetail(node.get(BROADCASTNEXT)) : null;
            this.broadcastnow = node.has(BROADCASTNOW) ? new BroadcastDetail(node.get(BROADCASTNOW)) : null;
            this.channel = ChannelDetail.parseString(node, CHANNEL);
            this.channelid = ChannelDetail.parseInt(node, CHANNELID);
            this.channeltype = ChannelDetail.parseString(node, CHANNELTYPE);
            this.hidden = ChannelDetail.parseBoolean(node, HIDDEN);
            this.lastplayed = ChannelDetail.parseString(node, LASTPLAYED);
            this.locked = ChannelDetail.parseBoolean(node, LOCKED);
            this.thumbnail = ChannelDetail.parseString(node, THUMBNAIL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(BROADCASTNEXT, this.broadcastnext == null ? null : this.broadcastnext.toJsonNode());
            node.put(BROADCASTNOW, this.broadcastnow == null ? null : this.broadcastnow.toJsonNode());
            node.put(CHANNEL, this.channel);
            node.put(CHANNELID, this.channelid);
            node.put(CHANNELTYPE, this.channeltype);
            node.put(HIDDEN, this.hidden);
            node.put(LASTPLAYED, this.lastplayed);
            node.put(LOCKED, this.locked);
            node.put(THUMBNAIL, this.thumbnail);
            return node;
        }

        static List<ChannelDetail> getPVRModelChannelDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<ChannelDetail> l = new ArrayList<ChannelDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new ChannelDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<ChannelDetail>(0);
        }

        public static interface Channeltype {
            public static final String TV = "tv";
            public static final String RADIO = "radio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("tv", "radio"));
        }
    }

    public static class BroadcastDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.Broadcast";
        public static final String BROADCASTID = "broadcastid";
        public static final String ENDTIME = "endtime";
        public static final String EPISODENAME = "episodename";
        public static final String EPISODENUM = "episodenum";
        public static final String EPISODEPART = "episodepart";
        public static final String FIRSTAIRED = "firstaired";
        public static final String GENRE = "genre";
        public static final String HASTIMER = "hastimer";
        public static final String ISACTIVE = "isactive";
        public static final String PARENTALRATING = "parentalrating";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String PROGRESS = "progress";
        public static final String PROGRESSPERCENTAGE = "progresspercentage";
        public static final String RATING = "rating";
        public static final String RUNTIME = "runtime";
        public static final String STARTTIME = "starttime";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TITLE = "title";
        public static final String WASACTIVE = "wasactive";
        public final Integer broadcastid;
        public final String endtime;
        public final String episodename;
        public final Integer episodenum;
        public final Integer episodepart;
        public final String firstaired;
        public final String genre;
        public final Boolean hastimer;
        public final Boolean isactive;
        public final Integer parentalrating;
        public final String plot;
        public final String plotoutline;
        public final Integer progress;
        public final Double progresspercentage;
        public final Integer rating;
        public final Integer runtime;
        public final String starttime;
        public final String thumbnail;
        public final String title;
        public final Boolean wasactive;

        public BroadcastDetail(JsonNode node) {
            super(node);
            this.broadcastid = BroadcastDetail.parseInt(node, BROADCASTID);
            this.endtime = BroadcastDetail.parseString(node, ENDTIME);
            this.episodename = BroadcastDetail.parseString(node, EPISODENAME);
            this.episodenum = BroadcastDetail.parseInt(node, EPISODENUM);
            this.episodepart = BroadcastDetail.parseInt(node, EPISODEPART);
            this.firstaired = BroadcastDetail.parseString(node, FIRSTAIRED);
            this.genre = BroadcastDetail.parseString(node, GENRE);
            this.hastimer = BroadcastDetail.parseBoolean(node, HASTIMER);
            this.isactive = BroadcastDetail.parseBoolean(node, ISACTIVE);
            this.parentalrating = BroadcastDetail.parseInt(node, PARENTALRATING);
            this.plot = BroadcastDetail.parseString(node, PLOT);
            this.plotoutline = BroadcastDetail.parseString(node, PLOTOUTLINE);
            this.progress = BroadcastDetail.parseInt(node, PROGRESS);
            this.progresspercentage = BroadcastDetail.parseDouble(node, PROGRESSPERCENTAGE);
            this.rating = BroadcastDetail.parseInt(node, RATING);
            this.runtime = BroadcastDetail.parseInt(node, RUNTIME);
            this.starttime = BroadcastDetail.parseString(node, STARTTIME);
            this.thumbnail = BroadcastDetail.parseString(node, THUMBNAIL);
            this.title = BroadcastDetail.parseString(node, TITLE);
            this.wasactive = BroadcastDetail.parseBoolean(node, WASACTIVE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode node = (ObjectNode)super.toJsonNode();
            node.put(BROADCASTID, this.broadcastid);
            node.put(ENDTIME, this.endtime);
            node.put(EPISODENAME, this.episodename);
            node.put(EPISODENUM, this.episodenum);
            node.put(EPISODEPART, this.episodepart);
            node.put(FIRSTAIRED, this.firstaired);
            node.put(GENRE, this.genre);
            node.put(HASTIMER, this.hastimer);
            node.put(ISACTIVE, this.isactive);
            node.put(PARENTALRATING, this.parentalrating);
            node.put(PLOT, this.plot);
            node.put(PLOTOUTLINE, this.plotoutline);
            node.put(PROGRESS, this.progress);
            node.put(PROGRESSPERCENTAGE, this.progresspercentage);
            node.put(RATING, this.rating);
            node.put(RUNTIME, this.runtime);
            node.put(STARTTIME, this.starttime);
            node.put(THUMBNAIL, this.thumbnail);
            node.put(TITLE, this.title);
            node.put(WASACTIVE, this.wasactive);
            return node;
        }

        static List<BroadcastDetail> getPVRModelBroadcastDetailList(JsonNode node, String key) {
            if (node.has(key)) {
                ArrayNode a = (ArrayNode)node.get(key);
                ArrayList<BroadcastDetail> l = new ArrayList<BroadcastDetail>(a.size());
                for (int i = 0; i < a.size(); ++i) {
                    l.add(new BroadcastDetail(a.get(i)));
                }
                return l;
            }
            return new ArrayList<BroadcastDetail>(0);
        }
    }

    public static class ChannelGroupId
    extends AbstractModel {
        public static final String API_TYPE = "PVR.ChannelGroup.Id";
        public final Integer id;
        public final String stringArg;

        public ChannelGroupId(Integer id) {
            this.id = id;
            this.stringArg = null;
        }

        public ChannelGroupId(String stringArg) {
            this.stringArg = stringArg;
            this.id = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.id != null) {
                return new IntNode(this.id.intValue());
            }
            if (this.stringArg != null) {
                return new TextNode(this.stringArg);
            }
            return null;
        }

        public static interface StringArg {
            public static final String ALLTV = "alltv";
            public static final String ALLRADIO = "allradio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("alltv", "allradio"));
        }
    }
}

