/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.ProfilesModel;

public final class Profiles {

    public static class LoadProfile
    extends AbstractCall<String> {
        public static final String API_TYPE = "Profiles.LoadProfile";

        public LoadProfile(String profile, Boolean prompt, ProfilesModel.Password password) {
            this.addParameter("profile", profile);
            this.addParameter("prompt", prompt);
            this.addParameter("password", (AbstractModel)password);
        }

        public LoadProfile(String profile) {
            this.addParameter("profile", profile);
        }

        public LoadProfile(String profile, Boolean prompt) {
            this.addParameter("profile", profile);
            this.addParameter("prompt", prompt);
        }

        public LoadProfile(String profile, ProfilesModel.Password password) {
            this.addParameter("profile", profile);
            this.addParameter("password", (AbstractModel)password);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetProfiles
    extends AbstractCall<ProfilesModel.ProfileDetail> {
        public static final String API_TYPE = "Profiles.GetProfiles";
        public static final String RESULT = "profiles";

        public GetProfiles(ListModel.Limits limits, ListModel.Sort sort, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", properties);
        }

        public GetProfiles(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetProfiles(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<ProfilesModel.ProfileDetail> parseMany(JsonNode node) {
            ArrayNode profiles = this.parseResults(node, RESULT);
            if (profiles != null) {
                ArrayList<ProfilesModel.ProfileDetail> ret = new ArrayList<ProfilesModel.ProfileDetail>(profiles.size());
                for (int i = 0; i < profiles.size(); ++i) {
                    ObjectNode item = (ObjectNode)profiles.get(i);
                    ret.add(new ProfilesModel.ProfileDetail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<ProfilesModel.ProfileDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetCurrentProfile
    extends AbstractCall<ProfilesModel.ProfileDetail> {
        public static final String API_TYPE = "Profiles.GetCurrentProfile";

        public GetCurrentProfile(String ... properties) {
            this.addParameter("properties", properties);
        }

        @Override
        protected ProfilesModel.ProfileDetail parseOne(JsonNode node) {
            return new ProfilesModel.ProfileDetail(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

