/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.GUIModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;

public final class GUI {

    public static class ShowNotification
    extends AbstractCall<String> {
        public static final String API_TYPE = "GUI.ShowNotification";

        public ShowNotification(String title, String message, String image, Integer displaytime) {
            this.addParameter("title", title);
            this.addParameter("message", message);
            this.addParameter("image", image);
            this.addParameter("displaytime", displaytime);
        }

        public ShowNotification(String title, String message) {
            this.addParameter("title", title);
            this.addParameter("message", message);
        }

        public ShowNotification(String title, String message, String image) {
            this.addParameter("title", title);
            this.addParameter("message", message);
            this.addParameter("image", image);
        }

        public ShowNotification(String title, String message, Integer displaytime) {
            this.addParameter("title", title);
            this.addParameter("message", message);
            this.addParameter("displaytime", displaytime);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class SetStereoscopicMode
    extends AbstractCall<String> {
        public static final String API_TYPE = "GUI.SetStereoscopicMode";

        public SetStereoscopicMode(String mode) {
            this.addParameter("mode", mode);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static interface Mode {
            public static final String TOGGLE = "toggle";
            public static final String TOMONO = "tomono";
            public static final String NEXT = "next";
            public static final String PREVIOUS = "previous";
            public static final String SELECT = "select";
            public static final String OFF = "off";
            public static final String SPLIT_VERTICAL = "split_vertical";
            public static final String SPLIT_HORIZONTAL = "split_horizontal";
            public static final String ROW_INTERLEAVED = "row_interleaved";
            public static final String HARDWARE_BASED = "hardware_based";
            public static final String ANAGLYPH_CYAN_RED = "anaglyph_cyan_red";
            public static final String ANAGLYPH_GREEN_MAGENTA = "anaglyph_green_magenta";
            public static final String MONOSCOPIC = "monoscopic";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("toggle", "tomono", "next", "previous", "select", "off", "split_vertical", "split_horizontal", "row_interleaved", "hardware_based", "anaglyph_cyan_red", "anaglyph_green_magenta", "monoscopic"));
        }
    }

    public static class SetFullscreen
    extends AbstractCall<Boolean> {
        public static final String API_TYPE = "GUI.SetFullscreen";

        public SetFullscreen(GlobalModel.Toggle fullscreen) {
            this.addParameter("fullscreen", (AbstractModel)fullscreen);
        }

        @Override
        protected Boolean parseOne(JsonNode node) {
            return node.getBooleanValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetStereoscopicModes
    extends AbstractCall<GUIModel.StereoscopyMode> {
        public static final String API_TYPE = "GUI.GetStereoscopicModes";
        public static final String RESULT = "stereoscopicmodes";

        @Override
        protected ArrayList<GUIModel.StereoscopyMode> parseMany(JsonNode node) {
            ArrayNode stereoscopicmodes = this.parseResults(node, RESULT);
            if (stereoscopicmodes != null) {
                ArrayList<GUIModel.StereoscopyMode> ret = new ArrayList<GUIModel.StereoscopyMode>(stereoscopicmodes.size());
                for (int i = 0; i < stereoscopicmodes.size(); ++i) {
                    ObjectNode item = (ObjectNode)stereoscopicmodes.get(i);
                    ret.add(new GUIModel.StereoscopyMode((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<GUIModel.StereoscopyMode>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetProperties
    extends AbstractCall<GUIModel.PropertyValue> {
        public static final String API_TYPE = "GUI.GetProperties";

        public GetProperties(String ... properties) {
            this.addParameter("properties", properties);
        }

        @Override
        protected GUIModel.PropertyValue parseOne(JsonNode node) {
            return new GUIModel.PropertyValue(node);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class ActivateWindow
    extends AbstractCall<String> {
        public static final String API_TYPE = "GUI.ActivateWindow";

        public ActivateWindow(String window, String ... parameters) {
            this.addParameter("window", window);
            this.addParameter("parameters", parameters);
        }

        public ActivateWindow(String window) {
            this.addParameter("window", window);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

