/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.AddonModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;

public final class Addons {

    public static class SetAddonEnabled
    extends AbstractCall<String> {
        public static final String API_TYPE = "Addons.SetAddonEnabled";

        public SetAddonEnabled(String addonid, GlobalModel.Toggle enabled) {
            this.addParameter("addonid", addonid);
            this.addParameter("enabled", (AbstractModel)enabled);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetAddons
    extends AbstractCall<AddonModel.Detail> {
        public static final String API_TYPE = "Addons.GetAddons";
        public static final String RESULT = "addons";

        public GetAddons(String type, String content, Boolean enabled, ListModel.Limits limits, String ... properties) {
            this.addParameter("type", type);
            this.addParameter("content", content);
            this.addParameter("enabled", enabled);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetAddons(String ... properties) {
            this.addParameter("properties", properties);
        }

        public GetAddons(String type, String ... properties) {
            this.addParameter("type", type);
            this.addParameter("properties", properties);
        }

        public GetAddons(String type, String content, String ... properties) {
            this.addParameter("type", type);
            this.addParameter("content", content);
            this.addParameter("properties", properties);
        }

        public GetAddons(Boolean enabled, String ... properties) {
            this.addParameter("enabled", enabled);
            this.addParameter("properties", properties);
        }

        public GetAddons(String type, String content, Boolean enabled, String ... properties) {
            this.addParameter("type", type);
            this.addParameter("content", content);
            this.addParameter("enabled", enabled);
            this.addParameter("properties", properties);
        }

        public GetAddons(ListModel.Limits limits, String ... properties) {
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        public GetAddons(Boolean enabled, ListModel.Limits limits, String ... properties) {
            this.addParameter("enabled", enabled);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", properties);
        }

        @Override
        protected ArrayList<AddonModel.Detail> parseMany(JsonNode node) {
            ArrayNode addons = this.parseResults(node, RESULT);
            if (addons != null) {
                ArrayList<AddonModel.Detail> ret = new ArrayList<AddonModel.Detail>(addons.size());
                for (int i = 0; i < addons.size(); ++i) {
                    ObjectNode item = (ObjectNode)addons.get(i);
                    ret.add(new AddonModel.Detail((JsonNode)item));
                }
                return ret;
            }
            return new ArrayList<AddonModel.Detail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static interface Enabled {
            public static final String ALL = "all";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("all"));
        }
    }

    public static class GetAddonDetails
    extends AbstractCall<AddonModel.Detail> {
        public static final String API_TYPE = "Addons.GetAddonDetails";
        public static final String RESULT = "addon";

        public GetAddonDetails(String addonid, String ... properties) {
            this.addParameter("addonid", addonid);
            this.addParameter("properties", properties);
        }

        @Override
        protected AddonModel.Detail parseOne(JsonNode node) {
            return new AddonModel.Detail((JsonNode)((ObjectNode)node.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class ExecuteAddon
    extends AbstractCall<String> {
        public static final String API_TYPE = "Addons.ExecuteAddon";

        public ExecuteAddon(String addonid, HashMap<String, String> params, Boolean wait) {
            this.addParameter("addonid", addonid);
            this.addParameter("params", params);
            this.addParameter("wait", wait);
        }

        public ExecuteAddon(String addonid, String[] params, Boolean wait) {
            this.addParameter("addonid", addonid);
            this.addParameter("params", params);
            this.addParameter("wait", wait);
        }

        public ExecuteAddon(String addonid, String params, Boolean wait) {
            this.addParameter("addonid", addonid);
            this.addParameter("params", params);
            this.addParameter("wait", wait);
        }

        public ExecuteAddon(String addonid) {
            this.addParameter("addonid", addonid);
        }

        public ExecuteAddon(String addonid, HashMap<String, String> params) {
            this.addParameter("addonid", addonid);
            this.addParameter("params", params);
        }

        public ExecuteAddon(String addonid, Boolean wait) {
            this.addParameter("addonid", addonid);
            this.addParameter("wait", wait);
        }

        public ExecuteAddon(String addonid, String ... params) {
            this.addParameter("addonid", addonid);
            this.addParameter("params", params);
        }

        public ExecuteAddon(String addonid, String params) {
            this.addParameter("addonid", addonid);
            this.addParameter("params", params);
        }

        @Override
        protected String parseOne(JsonNode node) {
            return node.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

