/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public abstract class AbstractCall<T> {
    public static final String RESULT = "result";
    private static final Random RND = new Random(System.currentTimeMillis());
    protected static final ObjectMapper OM = new ObjectMapper();
    public static final String LIMITS = "limits";
    private static final String PARAMS = "params";
    public ObjectNode mRequest = OM.createObjectNode();
    protected T mResult = null;
    protected ArrayList<T> mResults = null;
    private final String mId;

    public abstract String getName();

    protected abstract boolean returnsList();

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    protected AbstractCall() {
        ObjectNode request = this.mRequest;
        this.mId = String.valueOf(RND.nextLong());
        request.put("jsonrpc", "2.0");
        request.put("id", this.mId);
        request.put("method", this.getName());
    }

    public ObjectNode getRequest() {
        return this.mRequest;
    }

    public void setResponse(JsonNode response) {
        if (this.returnsList()) {
            this.mResults = this.parseMany(response.findValue(RESULT));
        } else {
            this.mResult = this.parseOne(response.findValue(RESULT));
        }
    }

    public void copyResponse(AbstractCall<?> call) {
        if (this.returnsList()) {
            this.mResults = call.getResults();
        } else {
            this.mResult = call.getResult();
        }
    }

    public T getResult() {
        if (this.returnsList()) {
            return this.mResults.get(0);
        }
        return this.mResult;
    }

    public ArrayList<T> getResults() {
        if (!this.returnsList()) {
            ArrayList<T> results = new ArrayList<T>(1);
            results.add(this.mResult);
            return results;
        }
        return this.mResults;
    }

    public String getId() {
        return this.mId;
    }

    protected JsonNode parseResult(JsonNode obj) {
        return obj.findValue(RESULT);
    }

    protected ArrayNode parseResults(JsonNode obj, String key) {
        if (obj.findValue(key) instanceof NullNode) {
            return null;
        }
        return (ArrayNode)obj.findValue(key);
    }

    protected T parseOne(JsonNode obj) {
        return null;
    }

    protected ArrayList<T> parseMany(JsonNode obj) {
        return null;
    }

    protected void addParameter(String name, String value) {
        if (value != null) {
            this.getParameters().put(name, value);
        }
    }

    protected void addParameter(String name, Integer value) {
        if (value != null) {
            this.getParameters().put(name, value);
        }
    }

    protected void addParameter(String name, Boolean value) {
        if (value != null) {
            this.getParameters().put(name, value);
        }
    }

    protected void addParameter(String name, Double value) {
        if (value != null) {
            this.getParameters().put(name, value);
        }
    }

    protected void addParameter(String name, AbstractModel value) {
        if (value != null) {
            this.getParameters().put(name, value.toJsonNode());
        }
    }

    protected void addParameter(String name, AbstractModel ... values) {
        if (values != null) {
            for (AbstractModel value : values) {
                this.getParameters().put(name, value.toJsonNode());
            }
        }
    }

    protected void addParameter(String name, String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        ArrayNode props = OM.createArrayNode();
        for (String value : values) {
            props.add(value);
        }
        this.getParameters().put(name, (JsonNode)props);
    }

    protected void addParameter(String name, HashMap<String, String> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        ObjectNode props = OM.createObjectNode();
        for (String key : map.values()) {
            props.put(key, map.get(key));
        }
        this.getParameters().put(name, (JsonNode)props);
    }

    private ObjectNode getParameters() {
        ObjectNode request = this.mRequest;
        if (request.has(PARAMS)) {
            return (ObjectNode)request.get(PARAMS);
        }
        ObjectNode parameters = OM.createObjectNode();
        request.put(PARAMS, (JsonNode)parameters);
        return parameters;
    }
}

