/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.kodi.AbstractKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiUrl;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.DOMUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KodiTvShowMetadataProvider
extends AbstractKodiMetadataProvider
implements ITvShowMetadataProvider,
ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiTvShowMetadataProvider.class);
    private static final String EPISODEGUIDE = "episodeguide";

    public KodiTvShowMetadataProvider(KodiScraper scraper) {
        super(scraper);
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException {
        List<MediaSearchResult> results = this._search(options);
        if (results.isEmpty() && options.getYear() > 0) {
            LOGGER.info("Search found nothing, try again without year...");
            options.setYear(0);
            results = this._search(options);
        }
        return results;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws ScrapeException, UnsupportedMediaTypeException {
        LOGGER.debug("Kodi: getMetadata(): " + options);
        switch (options.getType()) {
            case TV_SHOW: {
                return this._getMetadata(options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(options);
            }
        }
        throw new UnsupportedMediaTypeException(options.getType());
    }

    @Override
    protected void processXmlContent(String xmlDetails, MediaMetadata md, MediaSearchResult result) throws Exception {
        if (xmlDetails == null || StringUtils.isEmpty((CharSequence)xmlDetails)) {
            LOGGER.warn("Cannot process empty Xml Contents.");
            return;
        }
        LOGGER.debug("******* BEGIN XML ***********");
        LOGGER.debug(xmlDetails);
        LOGGER.debug("******* END XML ***********");
        Document xml = this.parseXmlString(xmlDetails);
        this.addMetadata(md, xml.getDocumentElement());
        String showId = md.getId(this.scraper.getProviderInfo().getId()).toString();
        String episodeUrl = this.innerXml(DOMUtils.getElementByTagName((Element)xml.getDocumentElement(), (String)EPISODEGUIDE));
        if (StringUtils.isEmpty((CharSequence)episodeUrl)) {
            LOGGER.error("No Episode Data!");
        } else {
            KodiMetadataProvider.XML_CACHE.put((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_EPISODEGUIDE_URL"), (Object)episodeUrl);
            md.addExtraData(EPISODEGUIDE, (Object)episodeUrl);
            result.setMetadata(md);
        }
        LOGGER.debug("MetaData: " + md.toString());
        KodiMetadataProvider.XML_CACHE.put((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_" + result.getId()), (Object)xmlDetails);
    }

    private MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) {
        MediaMetadata md = new MediaMetadata(this.scraper.getProviderInfo().getId());
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            seasonNr = options.getIdAsIntOrDefault("dvdSeasonNr", -1);
            episodeNr = options.getIdAsIntOrDefault("dvdEpisodeNr", -1);
        }
        if (seasonNr == -1 || episodeNr == -1) {
            LOGGER.warn("no aired date/season number/episode number found");
            return md;
        }
        LOGGER.debug("search for S{} E{}", (Object)this.lz(seasonNr), (Object)this.lz(episodeNr));
        String showId = options.getIdAsString(this.scraper.getProviderInfo().getId());
        if (showId == null) {
            LOGGER.error("Could not find showId - please scrape show first!");
            return null;
        }
        String epXml = (String)KodiMetadataProvider.XML_CACHE.get((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_S" + this.lz(seasonNr) + "_E" + this.lz(episodeNr)));
        if (epXml == null) {
            MediaScrapeOptions mso = new MediaScrapeOptions(MediaType.TV_SHOW);
            mso.setId(this.scraper.getProviderInfo().getId(), showId);
            try {
                this.getEpisodeList(mso);
                epXml = (String)KodiMetadataProvider.XML_CACHE.get((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_S" + this.lz(seasonNr) + "_E" + this.lz(episodeNr)));
            }
            catch (Exception e) {
                LOGGER.error("Could not fetch episodeslist!", (Throwable)e);
            }
        }
        try {
            Document epListDoc = this.parseXmlString(epXml);
            Element el = epListDoc.getDocumentElement();
            int season = DOMUtils.getElementIntValue((Element)el, (String)"season");
            int ep = DOMUtils.getElementIntValue((Element)el, (String)"epnum");
            String id = DOMUtils.getElementValue((Element)el, (String)"id");
            String title = DOMUtils.getElementValue((Element)el, (String)"title");
            KodiUrl epUrl = new KodiUrl(DOMUtils.getElementValue((Element)el, (String)"url"));
            LOGGER.info("Getting episode details S" + this.lz(season) + " E" + this.lz(ep) + " - " + title);
            String xmlDetails = this.processor.getEpisodeDetails(epUrl, id);
            LOGGER.debug("******** BEGIN EPISODE DETAILS XML ***********");
            LOGGER.debug(xmlDetails);
            LOGGER.debug("******** END EPISODE DETAILS XML ***********");
            Document epDetailXml = this.parseXmlString(xmlDetails);
            Element epXmlEl = epDetailXml.getDocumentElement();
            this.addMetadata(md, epXmlEl);
            md.setEpisodeNumber(ep);
            md.setSeasonNumber(season);
            LOGGER.debug("MetaData: " + md.toString());
            KodiMetadataProvider.XML_CACHE.put((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_S" + this.lz(season) + "_E" + this.lz(ep) + "_DETAIL"), (Object)xmlDetails);
        }
        catch (Exception e) {
            LOGGER.error("Could not get episode details!");
        }
        return md;
    }

    public List<MediaMetadata> getEpisodeList(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        ArrayList<MediaMetadata> episodeList = new ArrayList<MediaMetadata>();
        String showId = options.getIdAsString(this.scraper.getProviderInfo().getId());
        if (StringUtils.isBlank((CharSequence)showId)) {
            LOGGER.error("Could not find showId - please scrape show first!");
            throw new MissingIdException(new String[]{"Could not find showId - please scrape show first!"});
        }
        String episodeguide = (String)KodiMetadataProvider.XML_CACHE.get((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_EPISODEGUIDE_URL"));
        if (episodeguide == null || episodeguide.isEmpty()) {
            if (options.getMetadata() != null) {
                episodeguide = options.getMetadata().getExtraData(EPISODEGUIDE).toString();
            }
            if (episodeguide == null || episodeguide.isEmpty()) {
                LOGGER.error("Could not find episodenguid url - you wanna scrape the show first!");
                return episodeList;
            }
        }
        try {
            String epListXml = (String)KodiMetadataProvider.XML_CACHE.get((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_" + EPISODEGUIDE));
            if (epListXml == null) {
                KodiUrl url = new KodiUrl(episodeguide);
                epListXml = this.processor.getEpisodeList(url);
                KodiMetadataProvider.XML_CACHE.put((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_" + EPISODEGUIDE), (Object)epListXml);
            }
            LOGGER.debug("******** BEGIN EPISODE LIST XML ***********");
            LOGGER.debug(epListXml);
            LOGGER.debug("******** END EPISODE LIST XML ***********");
            Document epListDoc = this.parseXmlString(epListXml);
            NodeList nl = epListDoc.getElementsByTagName("episode");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                int season = DOMUtils.getElementIntValue((Element)el, (String)"season");
                int ep = DOMUtils.getElementIntValue((Element)el, (String)"epnum");
                String epXml = this.elementToString(el);
                if (epXml != null) {
                    KodiMetadataProvider.XML_CACHE.put((Object)(this.scraper.getProviderInfo().getId() + "_" + showId + "_S" + this.lz(season) + "_E" + this.lz(ep)), (Object)epXml);
                }
                MediaMetadata md = new MediaMetadata(this.scraper.getProviderInfo().getId());
                md.setEpisodeNumber(ep);
                md.setSeasonNumber(season);
                md.setTitle(DOMUtils.getElementValue((Element)el, (String)"title"));
                md.setId(this.scraper.getProviderInfo().getId(), (Object)DOMUtils.getElementValue((Element)el, (String)"id"));
                try {
                    md.setReleaseDate(StrgUtils.parseDate((String)DOMUtils.getElementValue((Element)el, (String)"aired")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                episodeList.add(md);
            }
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: " + e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (episodeList.isEmpty()) {
            LOGGER.warn("Could not find episodes - did you scrape the show recently?");
        }
        return episodeList;
    }

    public List<IMediaProvider> getPluginsForType(MediaType type) {
        return null;
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions arg0) throws ScrapeException {
        LOGGER.debug("******* BEGIN ARTWORK XML FOR " + arg0.getArtworkType() + " ***********");
        ArrayList<MediaArtwork> mas = new ArrayList<MediaArtwork>();
        try {
            MediaMetadata md = this.getMetadata(arg0);
            mas.addAll(md.getMediaArt(arg0.getArtworkType()));
            LOGGER.debug("******* END ARTWORK XML FOR " + arg0.getArtworkType() + " ***********");
        }
        catch (Exception e) {
            LOGGER.error("error getting artwork: " + e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        return mas;
    }
}

