/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.kodi.Expression;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiUtil;
import org.tinymediamanager.scraper.kodi.RegExp;
import org.tinymediamanager.scraper.kodi.RegExpContainer;
import org.tinymediamanager.scraper.kodi.ScraperFunction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class KodiScraperParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiScraperParser.class);

    KodiScraperParser() {
    }

    public KodiScraper parseScraper(KodiScraper scraper, List<File> common) throws Exception {
        Document xml;
        LOGGER.debug("Preparing Kodi scraper: " + scraper.getProviderInfo().getName());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        File scraperFile = new File(scraper.getFolder(), scraper.getScraperXml());
        String xmlFile = FileUtils.readFileToString((File)scraperFile, (String)"UTF-8");
        xmlFile = KodiUtil.fixXmlHeader(xmlFile);
        xmlFile = KodiUtil.fixXmlAttributes(xmlFile);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(xmlFile.getBytes(StandardCharsets.UTF_8));
            xml = parser.parse(stream);
        }
        catch (SAXException e) {
            LOGGER.warn("Error parsing " + scraperFile + " - trying fallback");
            for (String[] ent : EntityArrays.ISO8859_1_UNESCAPE()) {
                xmlFile = xmlFile.replace(ent[0], ent[1]);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(xmlFile.getBytes(StandardCharsets.UTF_8));
            xml = parser.parse(stream);
        }
        Element docEl = xml.getDocumentElement();
        NodeList nl = docEl.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            Element el = (Element)n;
            ScraperFunction func = new ScraperFunction();
            func.setName(el.getNodeName());
            func.setClearBuffers(this.parseBoolean(el.getAttribute("clearbuffers"), true));
            func.setAppendBuffer(this.parseAppendBuffer(el.getAttribute("dest")));
            func.setDest(this.parseInt(el.getAttribute("dest")));
            scraper.addFunction(func);
            this.processRegexps(func, el);
        }
        this.readScraperFunctions(scraper, common);
        return scraper;
    }

    private boolean parseAppendBuffer(String attribute) {
        if (attribute == null) {
            return false;
        }
        return attribute.trim().endsWith("+");
    }

    private void processRegexps(RegExpContainer container, Element el) {
        NodeList regEls = el.getChildNodes();
        int regElsLen = regEls.getLength();
        for (int k = 0; k < regElsLen; ++k) {
            RegExp regexp;
            Element expEl;
            Node nn = regEls.item(k);
            if ("RegExp".equals(nn.getNodeName())) {
                expEl = (Element)nn;
                regexp = new RegExp();
                regexp.setInput(expEl.getAttribute("input"));
                regexp.setOutput(expEl.getAttribute("output"));
                regexp.setAppendBuffer(this.parseAppendBuffer(expEl.getAttribute("dest")));
                regexp.setDest(this.parseInt(expEl.getAttribute("dest")));
                regexp.setConditional(expEl.getAttribute("conditional"));
                container.addRegExp(regexp);
                this.processRegexps(regexp, (Element)nn);
                continue;
            }
            if (!"expression".equals(nn.getNodeName())) continue;
            expEl = (Element)nn;
            try {
                regexp = (RegExp)container;
                Expression exp = new Expression();
                exp.setExpression(nn.getTextContent());
                exp.setNoClean(expEl.getAttribute("noclean"));
                exp.setRepeat(this.parseBoolean(expEl.getAttribute("repeat"), false));
                exp.setClear(this.parseBoolean(expEl.getAttribute("clear"), false));
                regexp.setExpression(exp);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("unparseable expression! " + container);
            }
        }
    }

    private int parseInt(String attribute) {
        if (attribute == null || attribute.trim().length() == 0) {
            return 0;
        }
        if (attribute.endsWith("+")) {
            attribute = attribute.substring(0, attribute.length() - 1);
        }
        return Integer.parseInt(attribute);
    }

    private boolean parseBoolean(String attribute, boolean defaultNull) {
        if (attribute == null || attribute.trim().length() == 0) {
            return defaultNull;
        }
        if ("yes".equalsIgnoreCase(attribute)) {
            return true;
        }
        if ("no".equalsIgnoreCase(attribute)) {
            return false;
        }
        return Boolean.parseBoolean(attribute);
    }

    private void readScraperFunctions(KodiScraper scraper, List<File> common) {
        for (File file : common) {
            for (String imp : scraper.imports) {
                if (!file.getPath().contains(imp)) continue;
                try {
                    LOGGER.debug("parsing imports from " + file);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder parser = factory.newDocumentBuilder();
                    Document xml = parser.parse(file);
                    Element docEl = xml.getDocumentElement();
                    if (!"scraperfunctions".equals(docEl.getNodeName())) continue;
                    NodeList nl = docEl.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node n = nl.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element el = (Element)n;
                        ScraperFunction func = new ScraperFunction();
                        func.setName(el.getNodeName());
                        func.setClearBuffers(this.parseBoolean(el.getAttribute("clearbuffers"), true));
                        func.setAppendBuffer(this.parseAppendBuffer(el.getAttribute("dest")));
                        func.setDest(this.parseInt(el.getAttribute("dest")));
                        scraper.addFunction(func);
                        this.processRegexps(func, el);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem parsing scraper function", (Throwable)e);
                }
            }
        }
    }
}

