/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.iso9660.EntryInputStream;
import com.github.stephenc.javaisotools.loopfs.iso9660.EntryIterator;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660VolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.spi.AbstractBlockFileSystem;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class Iso9660FileSystem
extends AbstractBlockFileSystem<Iso9660FileEntry> {
    public Iso9660FileSystem(File file, boolean readOnly) throws IOException {
        super(file, readOnly, 2048, 16);
    }

    public String getEncoding() {
        return ((Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet()).getEncoding();
    }

    public InputStream getInputStream(Iso9660FileEntry entry) {
        this.ensureOpen();
        return new EntryInputStream(entry, this);
    }

    byte[] getBytes(Iso9660FileEntry entry) throws IOException {
        int size = (int)entry.getSize();
        byte[] buf = new byte[size];
        this.readBytes(entry, 0L, buf, 0, size);
        return buf;
    }

    public int readBytes(Iso9660FileEntry entry, long entryOffset, byte[] buffer, int bufferOffset, int len) throws IOException {
        long startPos = entry.getStartBlock() * 2048L + entryOffset;
        return this.readData(startPos, buffer, bufferOffset, len);
    }

    protected Iterator<Iso9660FileEntry> iterator(Iso9660FileEntry rootEntry) {
        return new EntryIterator(this, rootEntry);
    }

    protected VolumeDescriptorSet<Iso9660FileEntry> createVolumeDescriptorSet() {
        return new Iso9660VolumeDescriptorSet(this);
    }
}

