/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mpdbtv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaTrailer;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.entities.Actor;
import org.tinymediamanager.scraper.mpdbtv.entities.Director;
import org.tinymediamanager.scraper.mpdbtv.entities.DiscArt;
import org.tinymediamanager.scraper.mpdbtv.entities.Fanart;
import org.tinymediamanager.scraper.mpdbtv.entities.Genre;
import org.tinymediamanager.scraper.mpdbtv.entities.HDClearArt;
import org.tinymediamanager.scraper.mpdbtv.entities.HDLogo;
import org.tinymediamanager.scraper.mpdbtv.entities.MovieEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.Poster;
import org.tinymediamanager.scraper.mpdbtv.entities.Producer;
import org.tinymediamanager.scraper.mpdbtv.entities.SearchEntity;
import org.tinymediamanager.scraper.mpdbtv.entities.Studio;
import org.tinymediamanager.scraper.mpdbtv.entities.Trailer;
import org.tinymediamanager.scraper.mpdbtv.services.Controller;
import org.tinymediamanager.scraper.util.ApiKey;

@PluginImplementation
public class MpdbMetadataProvider
implements IMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpdbMetadataProvider.class);
    private static final MediaProviderInfo providerInfo = MpdbMetadataProvider.createMediaProviderInfo();
    private static final String API_KEY = ApiKey.decryptApikey((String)"DdSGUTZn24ml7rZRBihKb9ea3svKUDnU3GZdhgf+XMrfE8IdLinpy6eAPLrmkZWu");
    private static final String FORMAT = "json";
    private Controller controller = new Controller(false);

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("mpdbtv", "mpdb.tv", "<html><h3>MPDB.tv</h3><br />The MPDB.tv API is a RESTful web service to obtain movie information, all content and images on the site are contributed and maintained by our users. <br /><br />This is a private meta data provider, you may need to become a member there to use this service (more infos at http://www.mpdb.tv/)<br /><br />Available languages: FR</html>\"", MpdbMetadataProvider.class.getResource("/mpdbtv.png"));
        providerInfo.setVersion(MpdbMetadataProvider.class);
        providerInfo.getConfig().addText("aboKey", "", false);
        providerInfo.getConfig().addText("username", "", false);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    public List<MediaSearchResult> search(MediaSearchOptions mediaSearchOptions) throws ScrapeException {
        List<SearchEntity> searchResult;
        LOGGER.debug("search() {} ", (Object)mediaSearchOptions);
        ArrayList<MediaSearchResult> mediaResult = new ArrayList<MediaSearchResult>();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getAboKey(), this.getUserName()})) {
            LOGGER.warn("no username/ABO Key found");
            throw new ScrapeException((Throwable)new HttpException(401, "Unauthorized"));
        }
        LOGGER.info("========= BEGIN MPDB.tv Scraper Search for Movie: {} ", (Object)mediaSearchOptions.getQuery());
        try {
            searchResult = this.controller.getSearchInformation(API_KEY, this.getEncodedUserName(), this.getSubscriptionKey(), mediaSearchOptions.getQuery(), mediaSearchOptions.getLanguage(), true, FORMAT);
        }
        catch (IOException e) {
            LOGGER.error("error searching: {} ", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (searchResult == null) {
            LOGGER.warn("no result from MPDB.tv");
            return mediaResult;
        }
        for (SearchEntity entity : searchResult) {
            MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), MediaType.MOVIE);
            result.setId(providerInfo.getId(), entity.id);
            result.setOriginalTitle(StringEscapeUtils.unescapeHtml4((String)entity.original_title));
            if (StringUtils.isEmpty((CharSequence)entity.title)) {
                result.setTitle(StringEscapeUtils.unescapeHtml4((String)entity.original_title));
            } else {
                result.setTitle(StringEscapeUtils.unescapeHtml4((String)entity.title));
            }
            result.setYear(entity.year);
            result.setId("imdb_id", entity.id_imdb);
            result.setId("allocine_id", entity.id_allocine);
            result.setUrl(entity.url);
            result.setPosterUrl(entity.posterUrl);
            mediaResult.add(result);
        }
        return mediaResult;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions mediaScrapeOptions) throws ScrapeException {
        MediaArtwork mediaArtwork;
        MediaCastMember mediaCastMember;
        MovieEntity scrapeResult;
        LOGGER.debug("scrape() {}", (Object)mediaScrapeOptions);
        MediaMetadata metadata = new MediaMetadata(providerInfo.getId());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.getAboKey(), this.getUserName()})) {
            LOGGER.warn("no username/ABO Key found");
            throw new ScrapeException((Throwable)new HttpException(401, "Unauthorized"));
        }
        LOGGER.info("========= BEGIN MPDB.tv scraping");
        try {
            scrapeResult = this.controller.getScrapeInformation(API_KEY, this.getEncodedUserName(), this.getSubscriptionKey(), Integer.parseInt(mediaScrapeOptions.getIdAsString(providerInfo.getId())), mediaScrapeOptions.getLanguage(), null, FORMAT);
        }
        catch (IOException e) {
            LOGGER.error("error searching: {} ", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (scrapeResult == null) {
            LOGGER.warn("no result from MPDB.tv");
            return metadata;
        }
        if (scrapeResult.rating != null) {
            MediaRating rating = new MediaRating(providerInfo.getId());
            rating.setRating(scrapeResult.rating.doubleValue());
            rating.setVoteCount(scrapeResult.ratingVotes.intValue());
            rating.setMaxValue(10);
            metadata.addRating(rating);
        }
        ArrayList<MediaGenres> mediaGenres = new ArrayList<MediaGenres>();
        for (Genre genre : scrapeResult.genres) {
            mediaGenres.add(MediaGenres.getGenre((String)genre.name));
        }
        metadata.setGenres(mediaGenres);
        ArrayList<MediaTrailer> mediaTrailers = new ArrayList<MediaTrailer>();
        for (Trailer trailer : scrapeResult.trailers) {
            MediaTrailer mt = new MediaTrailer();
            mt.setName(scrapeResult.title);
            mt.setUrl(trailer.url);
            mt.setQuality(trailer.quality);
            mediaTrailers.add(mt);
        }
        metadata.setTrailers(mediaTrailers);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Studio studio : scrapeResult.studios) {
            arrayList.add(studio.name);
        }
        metadata.setProductionCompanies(arrayList);
        ArrayList<MediaCastMember> arrayList2 = new ArrayList<MediaCastMember>();
        for (Director director : scrapeResult.directors) {
            mediaCastMember = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
            mediaCastMember.setName(director.name);
            mediaCastMember.setPart(director.departement);
            mediaCastMember.setImageUrl(director.thumb);
            mediaCastMember.setCharacter(director.role);
            mediaCastMember.setId(providerInfo.getId(), (Object)director.id);
            arrayList2.add(mediaCastMember);
        }
        for (Actor actor : scrapeResult.actors) {
            mediaCastMember = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            mediaCastMember.setId(providerInfo.getId(), (Object)actor.id);
            mediaCastMember.setName(actor.name);
            mediaCastMember.setPart(actor.departement);
            mediaCastMember.setImageUrl(actor.thumb);
            mediaCastMember.setCharacter(actor.role);
            arrayList2.add(mediaCastMember);
        }
        for (Producer producer : scrapeResult.producers) {
            mediaCastMember = new MediaCastMember(MediaCastMember.CastType.PRODUCER);
            mediaCastMember.setId(providerInfo.getId(), (Object)producer.id);
            mediaCastMember.setName(producer.name);
            mediaCastMember.setPart(producer.departement);
            mediaCastMember.setImageUrl(producer.thumb);
            mediaCastMember.setCharacter(producer.role);
            arrayList2.add(mediaCastMember);
        }
        metadata.setCastMembers(arrayList2);
        for (Poster poster : scrapeResult.posters) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            mediaArtwork.setPreviewUrl(poster.preview);
            mediaArtwork.setDefaultUrl(poster.original);
            mediaArtwork.setLikes(poster.votes.intValue());
            metadata.addMediaArt(mediaArtwork);
        }
        for (Fanart fanart : scrapeResult.fanarts) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
            mediaArtwork.setPreviewUrl(fanart.preview);
            mediaArtwork.setDefaultUrl(fanart.original);
            mediaArtwork.setLikes(fanart.votes.intValue());
            metadata.addMediaArt(mediaArtwork);
        }
        for (DiscArt discArt : scrapeResult.discarts) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.DISC);
            mediaArtwork.setPreviewUrl(discArt.preview);
            mediaArtwork.setDefaultUrl(discArt.original);
            mediaArtwork.setLikes(discArt.votes.intValue());
            metadata.addMediaArt(mediaArtwork);
        }
        for (HDClearArt hdClearArt : scrapeResult.hdcleararts) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.CLEARART);
            mediaArtwork.setPreviewUrl(hdClearArt.preview);
            mediaArtwork.setDefaultUrl(hdClearArt.original);
            mediaArtwork.setLikes(hdClearArt.votes.intValue());
            metadata.addMediaArt(mediaArtwork);
        }
        for (HDLogo hdLogo : scrapeResult.hdlogos) {
            mediaArtwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.CLEARLOGO);
            mediaArtwork.setPreviewUrl(hdLogo.preview);
            mediaArtwork.setDefaultUrl(hdLogo.original);
            mediaArtwork.setLikes(hdLogo.votes.intValue());
        }
        metadata.setId("allocine", (Object)scrapeResult.idAllocine);
        metadata.setId("imdb", (Object)scrapeResult.idImdb);
        metadata.setId("tmdb", (Object)scrapeResult.idTmdb);
        metadata.setTagline(scrapeResult.tagline);
        metadata.setReleaseDate(new Date(scrapeResult.firstRelease.intValue()));
        metadata.setTitle(scrapeResult.title);
        metadata.setOriginalTitle(scrapeResult.originalTitle);
        metadata.setRuntime(scrapeResult.runtime);
        metadata.setPlot(scrapeResult.plot);
        return metadata;
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    private String getAboKey() {
        return providerInfo.getConfig().getValue("aboKey");
    }

    private String getUserName() {
        return providerInfo.getConfig().getValue("username");
    }

    private String getEncodedUserName() {
        return Base64.getUrlEncoder().encodeToString(this.getUserName().getBytes());
    }

    private String getSubscriptionKey() {
        return DigestUtils.shaHex((String)(this.getUserName() + API_KEY + this.getAboKey()));
    }
}

