/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.imdb.ImdbSiteDefinition;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.PluginManager;

public class ImdbTvShowParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbTvShowParser.class);
    private static final Pattern UNWANTED_SEARCH_RESULTS = Pattern.compile(".*\\((TV Movies|TV Episode|Short|Video Game)\\).*");
    private ImdbSiteDefinition imdbSite;

    ImdbTvShowParser(ImdbSiteDefinition imdbSite) {
        super(MediaType.TV_SHOW);
        this.imdbSite = imdbSite;
    }

    @Override
    protected Pattern getUnwantedSearchResultPattern() {
        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("filterUnwantedCategories").booleanValue()) {
            return UNWANTED_SEARCH_RESULTS;
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected ImdbSiteDefinition getImdbSite() {
        return this.imdbSite;
    }

    @Override
    protected MediaMetadata getMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        switch (options.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(options);
            }
        }
        return new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
    }

    @Override
    protected String getSearchCategory() {
        return "&s=tt&ttype=tv&ref_=fn_tv";
    }

    MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        String imdbId = "";
        if (options.getResult() != null) {
            imdbId = options.getResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - no imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): {}", (Object)imdbId);
        Future<MediaMetadata> futureTmdb = null;
        if (this.isUseTmdbForTvShows()) {
            ExecutorCompletionService<MediaMetadata> compSvcTmdb = new ExecutorCompletionService<MediaMetadata>(ImdbMetadataProvider.executor);
            TmdbTvShowWorker worker2 = new TmdbTvShowWorker(imdbId, options.getLanguage(), options.getCountry());
            futureTmdb = compSvcTmdb.submit(worker2);
        }
        ExecutorCompletionService<Document> compSvcImdb = new ExecutorCompletionService<Document>(ImdbMetadataProvider.executor);
        String url = this.imdbSite.getSite() + "title/" + imdbId + "/reference";
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), options.getCountry().getAlpha2(), this.imdbSite);
        Future<Document> futureReference = compSvcImdb.submit(worker);
        url = this.imdbSite.getSite() + "title/" + imdbId + "/plotsummary";
        worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), options.getCountry().getAlpha2(), this.imdbSite);
        Future<Document> futurePlotsummary = compSvcImdb.submit(worker);
        try {
            Document doc = futureReference.get();
            this.parseReferencePage(doc, options, md);
            doc = futurePlotsummary.get();
            this.parsePlotsummaryPage(doc, options, md);
            md.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)imdbId);
        }
        catch (Exception e) {
            LOGGER.error("problem while scraping: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (md.getIds().isEmpty()) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        md.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)imdbId);
        if (futureTmdb != null) {
            try {
                MediaMetadata tmdbMd = futureTmdb.get();
                if (tmdbMd != null) {
                    for (Map.Entry entry : tmdbMd.getIds().entrySet()) {
                        md.setId((String)entry.getKey(), entry.getValue());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                        md.setTitle(tmdbMd.getTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                        md.setOriginalTitle(tmdbMd.getOriginalTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                        md.setTagline(tmdbMd.getTagline());
                    }
                    if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                        md.setPlot(tmdbMd.getPlot());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return md;
    }

    MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        String imdbId = "";
        if (options.getResult() != null) {
            imdbId = options.getResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - no imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            throw new MissingIdException(new String[]{"episodeNr", "seasonNr"});
        }
        List<MediaMetadata> episodes = this.getEpisodeList(options);
        MediaMetadata wantedEpisode = null;
        for (MediaMetadata episode : episodes) {
            if (episode.getSeasonNumber() != seasonNr || episode.getEpisodeNumber() != episodeNr) continue;
            wantedEpisode = episode;
            break;
        }
        if (wantedEpisode == null) {
            LOGGER.warn("episode not found");
            throw new NothingFoundException();
        }
        ExecutorCompletionService<MediaMetadata> compSvcTmdb = new ExecutorCompletionService<MediaMetadata>(ImdbMetadataProvider.executor);
        Future<MediaMetadata> futureTmdb = null;
        if (this.isUseTmdbForTvShows()) {
            TmdbTvShowWorker worker2 = new TmdbTvShowWorker(imdbId, seasonNr, episodeNr, options.getLanguage(), options.getCountry());
            futureTmdb = compSvcTmdb.submit(worker2);
        }
        md.setId(ImdbMetadataProvider.providerInfo.getId(), wantedEpisode.getId(ImdbMetadataProvider.providerInfo.getId()));
        md.setEpisodeNumber(wantedEpisode.getEpisodeNumber());
        md.setSeasonNumber(wantedEpisode.getSeasonNumber());
        md.setTitle(wantedEpisode.getTitle());
        md.setPlot(wantedEpisode.getPlot());
        md.setRatings(wantedEpisode.getRatings());
        md.setReleaseDate(wantedEpisode.getReleaseDate());
        if (wantedEpisode.getId(ImdbMetadataProvider.providerInfo.getId()) instanceof String && StringUtils.isNotBlank((CharSequence)((String)wantedEpisode.getId(ImdbMetadataProvider.providerInfo.getId())))) {
            Url url = null;
            try {
                url = new Url(this.imdbSite.getSite() + "/title/" + wantedEpisode.getId(ImdbMetadataProvider.providerInfo.getId()) + "/reference");
                url.addHeader("Accept-Language", "en");
            }
            catch (Exception e) {
                LOGGER.warn("could not get cast page: {}", (Object)e.getMessage());
            }
            if (url != null) {
                try {
                    InputStream is = url.getInputStream();
                    Object object = null;
                    try {
                        Element writersElement;
                        Element castTableElement;
                        Element directorsElement;
                        Document document = Jsoup.parse((InputStream)is, (String)this.imdbSite.getCharset().displayName(), (String)"");
                        for (directorsElement = document.getElementById("directors"); directorsElement != null && !"header".equals(directorsElement.tag().getName()); directorsElement = directorsElement.parent()) {
                        }
                        if (directorsElement != null) {
                            directorsElement = directorsElement.nextElementSibling();
                        }
                        if (directorsElement != null) {
                            for (Element directorElement : directorsElement.getElementsByClass("name")) {
                                Matcher matcher;
                                String director = directorElement.text().trim();
                                MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
                                cm.setName(director);
                                Element anchor = directorElement.getElementsByAttributeValueStarting("href", "/name/").first();
                                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                                    if (matcher.group(0) != null) {
                                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                                    }
                                    if (matcher.group(1) != null) {
                                        cm.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)matcher.group(1));
                                    }
                                }
                                md.addCastMember(cm);
                            }
                        }
                        if ((castTableElement = document.getElementsByClass("cast_list").first()) != null) {
                            Elements tr = castTableElement.getElementsByTag("tr");
                            for (Element row : tr) {
                                MediaCastMember cm = this.parseCastMember(row);
                                if (cm == null || !StringUtils.isNotEmpty((CharSequence)cm.getName()) || !StringUtils.isNotEmpty((CharSequence)cm.getCharacter())) continue;
                                cm.setType(MediaCastMember.CastType.ACTOR);
                                md.addCastMember(cm);
                            }
                        }
                        for (writersElement = document.getElementById("writers"); writersElement != null && !"header".equals(writersElement.tag().getName()); writersElement = writersElement.parent()) {
                        }
                        if (writersElement != null) {
                            writersElement = writersElement.nextElementSibling();
                        }
                        if (writersElement != null) {
                            Elements writersElements = writersElement.getElementsByAttributeValueStarting("href", "/name/");
                            for (Element writerElement : writersElements) {
                                Matcher matcher;
                                String writer = ImdbMetadataProvider.cleanString(writerElement.ownText());
                                MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.WRITER);
                                cm.setName(writer);
                                Element anchor = writerElement.getElementsByAttributeValueStarting("href", "/name/").first();
                                if (anchor != null && (matcher = PERSON_ID_PATTERN.matcher(anchor.attr("href"))).find()) {
                                    if (matcher.group(0) != null) {
                                        cm.setProfileUrl("http://www.imdb.com" + matcher.group(0));
                                    }
                                    if (matcher.group(1) != null) {
                                        cm.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)matcher.group(1));
                                    }
                                }
                                md.addCastMember(cm);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (object != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.trace("problem parsing: {}", (Object)e.getMessage());
                }
            }
            if (futureTmdb != null) {
                try {
                    MediaMetadata tmdbMd = futureTmdb.get();
                    if (tmdbMd != null) {
                        for (Map.Entry entry : tmdbMd.getIds().entrySet()) {
                            md.setId((String)entry.getKey(), entry.getValue());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                            md.setTitle(tmdbMd.getTitle());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                            md.setOriginalTitle(tmdbMd.getOriginalTitle());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                            md.setTagline(tmdbMd.getTagline());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                            md.setPlot(tmdbMd.getPlot());
                        }
                        if (md.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).isEmpty() && !tmdbMd.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).isEmpty()) {
                            MediaArtwork thumb = (MediaArtwork)tmdbMd.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).get(0);
                            md.addMediaArt(thumb);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOGGER.warn("could not get cast page: {}", (Object)e.getMessage());
                }
            }
        }
        return md;
    }

    List<MediaMetadata> getEpisodeList(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        Document doc;
        InMemoryCachedUrl url;
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        String imdbId = options.getImdbId();
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            throw new MissingIdException(new String[]{"imdb"});
        }
        try {
            url = new InMemoryCachedUrl(this.imdbSite.getSite() + "/title/" + imdbId + "/epdate");
            url.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCountry().getAlpha2()));
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        try (InputStream is = url.getInputStream();){
            doc = Jsoup.parse((InputStream)is, (String)this.imdbSite.getCharset().displayName(), (String)"");
            this.parseEpisodeList(0, episodes, doc);
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        int i = 1;
        while (true) {
            InMemoryCachedUrl seasonUrl;
            try {
                seasonUrl = new InMemoryCachedUrl(this.imdbSite.getSite() + "/title/" + imdbId + "/epdate?season=" + i);
                seasonUrl.addHeader("Accept-Language", ImdbTvShowParser.getAcceptLanguage(options.getLanguage().getLanguage(), options.getCountry().getAlpha2()));
            }
            catch (Exception e) {
                LOGGER.error("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
            try (InputStream is = seasonUrl.getInputStream();){
                doc = Jsoup.parse((InputStream)is, (String)this.imdbSite.getCharset().displayName(), (String)"");
                if (!this.parseEpisodeList(i, episodes, doc)) {
                    break;
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("problem parsing ep list: {}", (Object)e.getMessage());
            }
            ++i;
        }
        return episodes;
    }

    private boolean parseEpisodeList(int season, List<MediaMetadata> episodes, Document doc) {
        Pattern unknownPattern = Pattern.compile("Unknown");
        Pattern seasonEpisodePattern = Pattern.compile("S([0-9]*), Ep([0-9]*)");
        int episodeCounter = 0;
        Elements tables = doc.getElementsByClass("eplist");
        for (Element table : tables) {
            Elements rows = table.getElementsByClass("list_item");
            for (Element row : rows) {
                Matcher matcher = season == 0 ? unknownPattern.matcher(row.text()) : seasonEpisodePattern.matcher(row.text());
                if (!matcher.find() || season != 0 && matcher.groupCount() < 2) continue;
                try {
                    Element image;
                    Element releaseDate;
                    Element ratingElement;
                    Element plot;
                    MediaMetadata ep = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
                    if (season == 0) {
                        ep.setSeasonNumber(season);
                        ep.setEpisodeNumber(++episodeCounter);
                    } else {
                        ep.setSeasonNumber(Integer.parseInt(matcher.group(1)));
                        ep.setEpisodeNumber(Integer.parseInt(matcher.group(2)));
                    }
                    if (season > 0 && season != ep.getSeasonNumber()) {
                        return false;
                    }
                    Elements anchors = row.getElementsByAttributeValueStarting("href", "/title/tt");
                    for (Element anchor : anchors) {
                        if (!"name".equals(anchor.attr("itemprop"))) continue;
                        ep.setTitle(anchor.text());
                        break;
                    }
                    String id = "";
                    Matcher idMatcher = IMDB_ID_PATTERN.matcher(((Element)anchors.get(0)).attr("href"));
                    while (idMatcher.find()) {
                        if (idMatcher.group(1) == null) continue;
                        id = idMatcher.group(1);
                    }
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        ep.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)id);
                    }
                    if ((plot = row.getElementsByClass("item_description").first()) != null) {
                        ep.setPlot(plot.ownText());
                    }
                    if ((ratingElement = row.getElementsByClass("ipl-rating-star__rating").first()) != null) {
                        String ratingAsString = ratingElement.ownText().replace(",", ".");
                        Element votesElement = row.getElementsByClass("ipl-rating-star__total-votes").first();
                        if (votesElement != null) {
                            String countAsString = votesElement.ownText().replaceAll("[.,()]", "").trim();
                            try {
                                MediaRating rating = new MediaRating(ImdbMetadataProvider.providerInfo.getId());
                                rating.setRating(Float.parseFloat(ratingAsString));
                                rating.setVoteCount(MetadataUtil.parseInt((String)countAsString));
                                ep.addRating(rating);
                            }
                            catch (Exception e) {
                                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
                            }
                        }
                    }
                    if ((releaseDate = row.getElementsByClass("airdate").first()) != null) {
                        ep.setReleaseDate(this.parseDate(releaseDate.ownText()));
                    }
                    if ((image = row.getElementsByTag("img").first()) != null) {
                        String posterUrl = image.attr("src");
                        posterUrl = posterUrl.replaceAll("UX[0-9]{2,4}_", "");
                        posterUrl = posterUrl.replaceAll("UY[0-9]{2,4}_", "");
                        if (StringUtils.isNotBlank((CharSequence)(posterUrl = posterUrl.replaceAll("CR[0-9]{1,3},[0-9]{1,3},[0-9]{1,3},[0-9]{1,3}_", "")))) {
                            MediaArtwork ma = new MediaArtwork(ImdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
                            ma.setPreviewUrl(posterUrl);
                            ma.setDefaultUrl(posterUrl);
                            ep.addMediaArt(ma);
                        }
                    }
                    episodes.add(ep);
                }
                catch (Exception e) {
                    LOGGER.warn("failed parsing: {} for ep data - {}", (Object)row.text(), (Object)e.getMessage());
                }
            }
        }
        return true;
    }

    private static class TmdbTvShowWorker
    implements Callable<MediaMetadata> {
        private String imdbId;
        private Locale language;
        private CountryCode certificationCountry;
        private int season = -1;
        private int episode = -1;
        private MediaType mediaType;

        TmdbTvShowWorker(String imdbId, Locale language, CountryCode certificationCountry) {
            this.imdbId = imdbId;
            this.language = language;
            this.certificationCountry = certificationCountry;
            this.mediaType = MediaType.TV_SHOW;
        }

        TmdbTvShowWorker(String imdbId, int season, int episode, Locale language, CountryCode certificationCountry) {
            this.imdbId = imdbId;
            this.season = season;
            this.episode = episode;
            this.language = language;
            this.certificationCountry = certificationCountry;
            this.mediaType = MediaType.TV_EPISODE;
        }

        @Override
        public MediaMetadata call() throws Exception {
            IMovieMetadataProvider tmdb = null;
            List providers = PluginManager.getInstance().getPluginsForInterface(IMovieMetadataProvider.class);
            for (IMovieMetadataProvider provider : providers) {
                if (!"tmdb".equals(provider.getProviderInfo().getId())) continue;
                tmdb = provider;
                break;
            }
            if (tmdb == null) {
                return null;
            }
            MediaScrapeOptions options = new MediaScrapeOptions(this.mediaType);
            options.setLanguage(this.language);
            options.setCountry(this.certificationCountry);
            options.setImdbId(this.imdbId);
            options.setId("seasonNr", String.valueOf(this.season));
            options.setId("episodeNr", String.valueOf(this.episode));
            return tmdb.getMetadata(options);
        }
    }
}

