/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.imdb.ImdbMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbParser;
import org.tinymediamanager.scraper.imdb.ImdbSiteDefinition;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.PluginManager;

public class ImdbMovieParser
extends ImdbParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbMovieParser.class);
    private static final Pattern UNWANTED_SEARCH_RESULTS = Pattern.compile(".*\\((TV Series|TV Episode|Short|Video Game)\\).*");
    private ImdbSiteDefinition imdbSite;

    ImdbMovieParser(ImdbSiteDefinition imdbSite) {
        super(MediaType.MOVIE);
        this.imdbSite = imdbSite;
    }

    @Override
    protected Pattern getUnwantedSearchResultPattern() {
        if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("filterUnwantedCategories").booleanValue()) {
            return UNWANTED_SEARCH_RESULTS;
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected ImdbSiteDefinition getImdbSite() {
        return this.imdbSite;
    }

    @Override
    protected MediaMetadata getMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        return this.getMovieMetadata(options);
    }

    @Override
    protected String getSearchCategory() {
        return "&s=tt";
    }

    MediaMetadata getMovieMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaMetadata md = new MediaMetadata(ImdbMetadataProvider.providerInfo.getId());
        if (options.getResult() != null && options.getResult().getMediaMetadata() != null) {
            LOGGER.debug("IMDB: getMetadata from cache: " + options.getResult());
            return options.getResult().getMediaMetadata();
        }
        String imdbId = "";
        if (options.getResult() != null) {
            imdbId = options.getResult().getIMDBId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = options.getImdbId();
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            LOGGER.warn("not possible to scrape from IMDB - imdbId found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        LOGGER.debug("IMDB: getMetadata(imdbId): " + imdbId);
        md.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)imdbId);
        ExecutorCompletionService<Document> compSvcImdb = new ExecutorCompletionService<Document>(ImdbMetadataProvider.executor);
        ExecutorCompletionService<MediaMetadata> compSvcTmdb = new ExecutorCompletionService<MediaMetadata>(ImdbMetadataProvider.executor);
        String url = this.imdbSite.getSite() + "title/" + imdbId + "/reference";
        ImdbParser.ImdbWorker worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), options.getCountry().getAlpha2(), this.imdbSite);
        Future<Document> futureReference = compSvcImdb.submit(worker);
        url = this.imdbSite.getSite() + "title/" + imdbId + "/plotsummary";
        worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), options.getCountry().getAlpha2(), this.imdbSite);
        Future<Document> futurePlotsummary = compSvcImdb.submit(worker);
        url = this.imdbSite.getSite() + "title/" + imdbId + "/releaseinfo";
        worker = new ImdbParser.ImdbWorker(url, options.getLanguage().getLanguage(), options.getCountry().getAlpha2(), this.imdbSite);
        Future<Document> futureReleaseinfo = compSvcImdb.submit(worker);
        Future<MediaMetadata> futureTmdb = null;
        if (this.isUseTmdbForMovies() || this.isScrapeCollectionInfo()) {
            TmdbMovieWorker worker2 = new TmdbMovieWorker(imdbId, options.getLanguage(), options.getCountry());
            futureTmdb = compSvcTmdb.submit(worker2);
        }
        try {
            Elements elements;
            Element title;
            Document doc = futureReference.get();
            this.parseReferencePage(doc, options, md);
            doc = futurePlotsummary.get();
            this.parsePlotsummaryPage(doc, options, md);
            if (this.imdbSite != ImdbSiteDefinition.IMDB_COM && (title = doc.getElementById("tn15title")) != null && (elements = title.getElementsByClass("main")).size() > 0) {
                Element element = elements.first();
                String movieTitle = ImdbMetadataProvider.cleanString(element.ownText());
                md.setTitle(movieTitle);
            }
            Document releaseinfoDoc = futureReleaseinfo.get();
            this.parseReleaseinfoPageAKAs(releaseinfoDoc, options, md);
            if (md.getReleaseDate() == null || ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("localReleaseDate").booleanValue()) {
                this.parseReleaseinfoPage(releaseinfoDoc, options, md);
            }
            md.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)imdbId);
        }
        catch (Exception e) {
            LOGGER.error("problem while scraping: " + e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (md.getIds().isEmpty()) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        if (futureTmdb != null && (this.isUseTmdbForMovies() || this.isScrapeCollectionInfo())) {
            try {
                MediaMetadata tmdbMd = futureTmdb.get();
                if (tmdbMd != null) {
                    for (Map.Entry entry : tmdbMd.getIds().entrySet()) {
                        md.setId((String)entry.getKey(), entry.getValue());
                    }
                    if (this.isUseTmdbForMovies()) {
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTitle())) {
                            md.setTitle(tmdbMd.getTitle());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getOriginalTitle())) {
                            md.setOriginalTitle(tmdbMd.getOriginalTitle());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getTagline())) {
                            md.setTagline(tmdbMd.getTagline());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getPlot())) {
                            md.setPlot(tmdbMd.getPlot());
                        }
                        if (StringUtils.isNotBlank((CharSequence)tmdbMd.getCollectionName())) {
                            md.setCollectionName(tmdbMd.getCollectionName());
                        }
                    }
                    if (ImdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeCollectionInfo").booleanValue()) {
                        md.setCollectionName(tmdbMd.getCollectionName());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)md.getOriginalTitle())) {
            md.setOriginalTitle(md.getTitle());
        }
        md.setId(ImdbMetadataProvider.providerInfo.getId(), (Object)imdbId);
        return md;
    }

    private void parseReleaseinfoPage(Document doc, MediaScrapeOptions options, MediaMetadata md) {
        Element column;
        Element column2;
        Matcher matcher;
        Element anchor;
        Elements rows;
        Date releaseDate = null;
        Pattern pattern = Pattern.compile("/calendar/\\?region=(.{2})");
        Element tableReleaseDates = doc.getElementById("release_dates");
        if (tableReleaseDates != null) {
            rows = tableReleaseDates.getElementsByTag("tr");
            for (Element row : rows) {
                anchor = row.getElementsByAttributeValueStarting("href", "/calendar/").first();
                if (anchor == null || !(matcher = pattern.matcher(anchor.attr("href"))).find() || !options.getCountry().getAlpha2().equalsIgnoreCase(matcher.group(1)) || (column2 = row.getElementsByClass("release_date").first()) == null) continue;
                releaseDate = this.parseDate(column2.text());
            }
        }
        if (releaseDate == null) {
            rows = doc.getElementsByClass("release-date-item");
            for (Element row : rows) {
                anchor = row.getElementsByAttributeValueStarting("href", "/calendar/").first();
                if (anchor == null) continue;
                matcher = pattern.matcher(anchor.attr("href"));
                if (matcher.find() && options.getCountry().getAlpha2().equalsIgnoreCase(matcher.group(1))) {
                    column2 = row.getElementsByClass("release-date-item__date").first();
                    if (column2 == null) continue;
                    releaseDate = this.parseDate(column2.text());
                    continue;
                }
                LOGGER.trace("country {} does not match ours {}", (Object)matcher.group(1), (Object)options.getCountry().getAlpha2());
            }
        }
        if (releaseDate == null && tableReleaseDates != null && (column = tableReleaseDates.getElementsByClass("release_date").first()) != null) {
            releaseDate = this.parseDate(column.text());
        }
        if (releaseDate != null) {
            md.setReleaseDate(releaseDate);
        }
    }

    private MediaMetadata parseReleaseinfoPageAKAs(Document doc, MediaScrapeOptions options, MediaMetadata md) {
        block0: for (Element table : doc.getElementsByTag("table")) {
            if (!table.id().equalsIgnoreCase("akas")) continue;
            Elements rows = table.getElementsByTag("tr");
            for (Element row : rows) {
                Element c1 = (Element)row.getElementsByTag("td").get(0);
                Element c2 = (Element)row.getElementsByTag("td").get(1);
                if (c1 == null || !c1.text().toLowerCase(Locale.ROOT).contains("original title")) continue;
                md.setOriginalTitle(c2.text());
                continue block0;
            }
        }
        Elements rows = doc.getElementsByClass("aka-item");
        for (Element row : rows) {
            Element country = row.getElementsByClass("aka-item__name").first();
            Element title = row.getElementsByClass("aka-item__title").first();
            if (country == null || !country.text().toLowerCase(Locale.ROOT).contains("original title")) continue;
            md.setOriginalTitle(title.text());
            break;
        }
        return md;
    }

    private static class TmdbMovieWorker
    implements Callable<MediaMetadata> {
        private String imdbId;
        private Locale language;
        private CountryCode certificationCountry;

        public TmdbMovieWorker(String imdbId, Locale language, CountryCode certificationCountry) {
            this.imdbId = imdbId;
            this.language = language;
            this.certificationCountry = certificationCountry;
        }

        @Override
        public MediaMetadata call() throws Exception {
            try {
                IMovieMetadataProvider tmdb = null;
                List providers = PluginManager.getInstance().getPluginsForInterface(IMovieMetadataProvider.class);
                for (IMovieMetadataProvider provider : providers) {
                    if (!"tmdb".equals(provider.getProviderInfo().getId())) continue;
                    tmdb = provider;
                    break;
                }
                if (tmdb == null) {
                    return null;
                }
                MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
                options.setLanguage(this.language);
                options.setCountry(this.certificationCountry);
                options.setImdbId(this.imdbId);
                return tmdb.getMetadata(options);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

