/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.rbp;

import ca.odell.glazedlists.impl.io.Bufferlo;
import java.text.ParseException;

class ResourceUri
implements Comparable {
    private String host;
    private int port;
    private String path;
    private boolean local;

    private ResourceUri(String host, int port, String path, boolean local) {
        this.host = host;
        this.port = port;
        this.path = path;
        this.local = local;
    }

    public static ResourceUri local(String path) {
        return new ResourceUri(null, -1, path, true);
    }

    public static ResourceUri localOrRemote(String uri, String localHost, int localPort) {
        try {
            Bufferlo parser = new Bufferlo();
            parser.write(uri);
            parser.consume("glazedlists\\:\\/\\/");
            String host = parser.readUntil("\\:");
            String portString = parser.readUntil("\\/");
            int port = Integer.parseInt(portString);
            String path = "/" + parser.toString();
            boolean local = localHost.equals(host) && localPort == port;
            return new ResourceUri(host, port, path, local);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static ResourceUri remote(String host, int port, String path) {
        return new ResourceUri(host, port, path, false);
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isRemote() {
        return !this.local;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString(String localHost, int localPort) {
        if (this.local) {
            return "glazedlists://" + localHost + ":" + localPort + this.path;
        }
        return "glazedlists://" + this.host + ":" + this.port + this.path;
    }

    public String toString() {
        return "Resource URI [local=" + this.local + ", host=" + this.host + ", port=" + this.port + ", path=" + this.path + "]";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        if (!this.local) {
            result = 37 * result + this.host.hashCode();
            result = 37 * result + this.port;
        }
        return result;
    }

    public int compareTo(Object other) {
        if (other == null) {
            throw new NullPointerException();
        }
        ResourceUri otherUri = (ResourceUri)other;
        if (otherUri.local != this.local) {
            throw new IllegalStateException("Cannot compare local URI with remote URI: " + other + " vs. " + this);
        }
        int result = this.path.compareTo(otherUri.path);
        if (result != 0) {
            return result;
        }
        if (!this.local) {
            result = this.host.compareTo(otherUri.host);
            if (result != 0) {
                return result;
            }
            result = this.port - otherUri.port;
            if (result != 0) {
                return result;
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }
}

