/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.omdb.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.omdb.entities.MovieEntity;
import org.tinymediamanager.scraper.omdb.entities.MovieSearch;
import org.tinymediamanager.scraper.omdb.entities.SeasonSearch;
import org.tinymediamanager.scraper.omdb.service.OmdbService;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private Retrofit retrofit = null;

    public Controller() {
        this(false);
    }

    public Controller(boolean debug) {
        OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
        if (debug) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

                public void log(String s) {
                    LOGGER.debug(s);
                }
            });
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)logging);
        }
        this.retrofit = this.buildRetrofitInstance(builder.build());
    }

    private GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (Object)new JsonDeserializer<Integer>(){

            public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return json.getAsInt();
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        return builder;
    }

    public MovieSearch getMovieSearchInfo(String apiKey, String searchTerm, String type, String year) throws IOException {
        return (MovieSearch)this.getService().movieSearch(apiKey, searchTerm, type, year).execute().body();
    }

    public MovieEntity getScrapeDataById(String apiKey, String id, String type, boolean full) throws IOException {
        String plotStyle = "short";
        if (full) {
            plotStyle = "full";
        }
        return (MovieEntity)this.getService().movieScrapeById(apiKey, id, type, null, plotStyle).execute().body();
    }

    public SeasonSearch getSeasonsById(String apiKey, String id, String type, int season) throws IOException {
        return (SeasonSearch)this.getService().seasonScrapeById(apiKey, id, type, season).execute().body();
    }

    public MovieEntity getEpisodesBySeasons(String apiKey, String id, String type, int season, int episode) throws IOException {
        return (MovieEntity)this.getService().episodeScrapeById(apiKey, id, type, season, episode).execute().body();
    }

    private OmdbService getService() {
        return (OmdbService)this.retrofit.create(OmdbService.class);
    }

    private Retrofit buildRetrofitInstance(OkHttpClient client) {
        return new Retrofit.Builder().client(client).baseUrl("http://www.omdbapi.com").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).build();
    }
}

