/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.omdb;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.mediaprovider.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.omdb.OmdbConnectionCounter;
import org.tinymediamanager.scraper.omdb.entities.MovieEntity;
import org.tinymediamanager.scraper.omdb.entities.MovieRating;
import org.tinymediamanager.scraper.omdb.entities.MovieSearch;
import org.tinymediamanager.scraper.omdb.service.Controller;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

@PluginImplementation
public class OmdbMetadataProvider
implements IMovieMetadataProvider,
IMovieImdbMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmdbMetadataProvider.class);
    private static final MediaProviderInfo providerInfo = OmdbMetadataProvider.createMediaProviderInfo();
    private static final String API_KEY = ApiKey.decryptApikey((String)"Isuaab2ym89iI1hOtF94nQ==");
    private Controller controller = new Controller(false);

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("omdbapi", "omdbapi.com", "<html><h3>Omdbapi.com</h3><br />The OMDb API is a RESTful web service to obtain movie information, all content and images on the site are contributed and maintained by our users. <br /><br />This is a private meta data provider, you may need to become a member there to use this service (more infos at http://www.omdbapi.com/)<br /><br />TinyMediaManager offers a limited access to OMDb API (10 calls per 15 seconds)<br /><br />Available languages: EN</html>", OmdbMetadataProvider.class.getResource("/omdbapi.png"));
        providerInfo.setVersion(OmdbMetadataProvider.class);
        providerInfo.getConfig().addText("apiKey", "", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    private String getApiKey() {
        String apiKey = providerInfo.getConfig().getValue("apiKey");
        if (StringUtils.isNotBlank((CharSequence)apiKey)) {
            return apiKey;
        }
        return API_KEY;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions query) throws ScrapeException, MissingIdException, NothingFoundException {
        Object rating2;
        String[] actors;
        String[] writers;
        String[] directors;
        String[] genres;
        LOGGER.debug("scrape()" + query.toString());
        MediaMetadata metadata = new MediaMetadata(providerInfo.getId());
        String apiKey = this.getApiKey();
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            LOGGER.warn("no API key found");
            return metadata;
        }
        String imdbId = query.getImdbId();
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = query.getIdAsString(this.getProviderInfo().getId());
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId) && query.getTmdbId() > 0) {
            imdbId = MetadataUtil.getImdbIdViaTmdbId((int)query.getTmdbId());
        }
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            LOGGER.warn("no imdb id found");
            throw new MissingIdException(new String[]{"imdb"});
        }
        SimpleDateFormat format = new SimpleDateFormat("d MMMM yyyy", Locale.ENGLISH);
        LOGGER.info("========= BEGIN OMDB Scraping");
        MovieEntity result = null;
        try {
            if (API_KEY.equals(apiKey)) {
                OmdbConnectionCounter.trackConnections();
            }
            result = this.controller.getScrapeDataById(apiKey, imdbId, "movie", true);
        }
        catch (Exception e) {
            LOGGER.error("error searching: " + e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (result == null) {
            LOGGER.warn("no result found");
            throw new NothingFoundException();
        }
        metadata.setTitle(result.title);
        try {
            metadata.setYear(Integer.parseInt(result.year));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        metadata.addCertification(Certification.findCertification((String)result.rated));
        try {
            metadata.setReleaseDate(format.parse(result.released));
        }
        catch (Exception e) {
            // empty catch block
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(result.runtime);
        while (m.find()) {
            try {
                metadata.setRuntime(Integer.parseInt(m.group()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (String genre : genres = result.genre.split(",")) {
            genre = genre.trim();
            MediaGenres mediaGenres = MediaGenres.getGenre((String)genre);
            metadata.addGenre(mediaGenres);
        }
        metadata.setPlot(result.plot);
        for (String d : directors = result.director.split(",")) {
            MediaCastMember director = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
            director.setName(d.trim());
            metadata.addCastMember(director);
        }
        for (String w : writers = result.writer.split(",")) {
            MediaCastMember writer = new MediaCastMember(MediaCastMember.CastType.WRITER);
            writer.setName(w.trim());
            metadata.addCastMember(writer);
        }
        for (String a : actors = result.actors.split(",")) {
            MediaCastMember actor = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            actor.setName(a.trim());
            metadata.addCastMember(actor);
        }
        metadata.setSpokenLanguages(this.getResult(result.language, ","));
        metadata.setCountries(this.getResult(result.country, ","));
        try {
            rating2 = new MediaRating("imdb");
            rating2.setRating(Double.parseDouble(result.imdbRating));
            rating2.setVoteCount(MetadataUtil.parseInt((String)result.imdbVotes));
            rating2.setMaxValue(10);
            metadata.addRating((MediaRating)rating2);
        }
        catch (NumberFormatException rating2) {
            // empty catch block
        }
        try {
            rating2 = new MediaRating("metascore");
            rating2.setRating(Double.parseDouble(result.metascore));
            rating2.setMaxValue(100);
            metadata.addRating((MediaRating)rating2);
        }
        catch (NumberFormatException rating3) {
            // empty catch block
        }
        for (MovieRating movieRating : ListUtils.nullSafe(result.ratings)) {
            switch (movieRating.source) {
                case "Rotten Tomatoes": {
                    try {
                        MediaRating rating4 = new MediaRating("rottenTomatoes");
                        rating4.setRating((float)Integer.parseInt(movieRating.value.replace("%", "")));
                        rating4.setMaxValue(100);
                        metadata.addRating(rating4);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)result.poster)) {
            MediaArtwork artwork = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            artwork.setDefaultUrl(result.poster);
            metadata.addMediaArt(artwork);
        }
        return metadata;
    }

    public List<MediaSearchResult> search(MediaSearchOptions query) throws ScrapeException {
        MovieSearch resultList;
        LOGGER.debug("search() " + query.toString());
        ArrayList<MediaSearchResult> mediaResult = new ArrayList<MediaSearchResult>();
        String apiKey = this.getApiKey();
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            LOGGER.warn("no API key found");
            return mediaResult;
        }
        try {
            LOGGER.info("========= BEGIN OMDB Scraper Search for Movie: " + query.getQuery());
            if (API_KEY.equals(apiKey)) {
                OmdbConnectionCounter.trackConnections();
            }
            resultList = this.controller.getMovieSearchInfo(apiKey, query.getQuery(), "movie", null);
        }
        catch (Exception e) {
            LOGGER.error("error searching: " + e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (resultList == null) {
            LOGGER.warn("no result from omdbapi");
            return mediaResult;
        }
        for (MovieEntity entity : ListUtils.nullSafe(resultList.search)) {
            MediaSearchResult result = new MediaSearchResult(providerInfo.getId(), MediaType.MOVIE);
            result.setTitle(entity.title);
            result.setIMDBId(entity.imdbID);
            try {
                result.setYear(Integer.parseInt(entity.year));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            result.setPosterUrl(entity.poster);
            mediaResult.add(result);
        }
        return mediaResult;
    }

    private List<String> getResult(String input, String delimiter) {
        String[] result = input.split(delimiter);
        ArrayList<String> output = new ArrayList<String>();
        for (String r : result) {
            output.add(r.trim());
        }
        return output;
    }

    void setVerbose(boolean verbose) {
        this.controller = new Controller(verbose);
    }
}

