/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.omdb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.RingBuffer;

public class OmdbConnectionCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmdbConnectionCounter.class);
    private static final RingBuffer<Long> CONNECTION_COUNTER = new RingBuffer(10);

    public static void trackConnections() {
        Long oldestConnection;
        Long currentTime = System.currentTimeMillis();
        if (CONNECTION_COUNTER.count() == CONNECTION_COUNTER.maxSize() && (oldestConnection = (Long)CONNECTION_COUNTER.getTailItem()) > currentTime - 15000L) {
            LOGGER.debug("connection limit reached, throttling " + CONNECTION_COUNTER);
            try {
                Thread.sleep(15000L - (currentTime - oldestConnection));
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        currentTime = System.currentTimeMillis();
        CONNECTION_COUNTER.add((Object)currentTime);
    }
}

