/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.launcher.n;
import com.threerings.getdown.spi.ProxyAuth;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.ConnectionUtil;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ServiceLoader;

public class ProxyUtil {
    protected static final String PROXY_REGISTRY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";

    public static boolean autoDetectProxy(Application application) {
        Object object;
        String[] stringArray = null;
        String string = null;
        if (System.getProperty("https.proxyHost") != null) {
            stringArray = System.getProperty("https.proxyHost");
            string = System.getProperty("https.proxyPort");
        }
        if (StringUtil.isBlank(stringArray) && System.getProperty("http.proxyHost") != null) {
            stringArray = System.getProperty("http.proxyHost");
            string = System.getProperty("http.proxyPort");
        }
        if (StringUtil.isBlank((String)stringArray) && LaunchUtil.isWindows()) {
            try {
                object = null;
                String string2 = null;
                boolean bl = false;
                RegistryKey.initialize();
                Object object2 = new RegistryKey(RootKey.HKEY_CURRENT_USER, PROXY_REGISTRY);
                object2 = ((RegistryKey)object2).values();
                while (object2.hasNext()) {
                    RegistryValue registryValue = (RegistryValue)object2.next();
                    if (registryValue.getName().equals("ProxyEnable")) {
                        bl = registryValue.getStringValue().equals("1");
                    }
                    if (!registryValue.getName().equals("ProxyServer")) continue;
                    object = registryValue.getStringValue();
                    int n2 = ((String)object).indexOf(":");
                    if (n2 == -1) continue;
                    string2 = ((String)object).substring(n2 + 1);
                    object = ((String)object).substring(0, n2);
                }
                if (bl) {
                    stringArray = object;
                    string = string2;
                } else {
                    Log.log.info("Detected no proxy settings in the registry.", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                Log.log.info("Failed to find proxy settings in Windows registry", "error", throwable);
            }
        }
        if (StringUtil.isBlank((String)stringArray)) {
            object = ProxyUtil.loadProxy(application);
            stringArray = object[0];
            string = object[1];
        }
        if (StringUtil.isBlank((String)stringArray)) {
            return false;
        }
        ProxyUtil.initProxy(application, (String)stringArray, string, null, null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canLoadWithoutProxy(URL uRL) {
        Log.log.info("Testing whether proxy is needed, via: " + uRL, new Object[0]);
        try {
            URLConnection uRLConnection = ConnectionUtil.open(Proxy.NO_PROXY, uRL, 5, 5);
            if (!(uRLConnection instanceof HttpURLConnection)) return true;
            uRLConnection = (HttpURLConnection)uRLConnection;
            try {
                ((HttpURLConnection)uRLConnection).setRequestMethod("HEAD");
                uRLConnection.connect();
                int n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
                if (n2 != 407) {
                    if (n2 != 403) return true;
                }
                Log.log.warning("Got an 'HTTP credentials needed' response", "code", n2);
                return false;
            }
            finally {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
        catch (IOException iOException) {
            Log.log.info("Failed to HEAD " + uRL + ": " + iOException, new Object[0]);
            Log.log.info("We probably need a proxy, but auto-detection failed.", new Object[0]);
        }
        return false;
    }

    public static void configProxy(Application application, String string, String string2, String string3, String string4) {
        ProxyUtil.saveProxy(application, string, string2);
        if (!StringUtil.isBlank(string3) && !StringUtil.isBlank(string4)) {
            Object object = ServiceLoader.load(ProxyAuth.class);
            object = ((ServiceLoader)object).iterator();
            String string5 = application.getAppDir().getAbsolutePath();
            while (object.hasNext()) {
                ((ProxyAuth)object.next()).saveCredentials(string5, string3, string4);
            }
        }
        ProxyUtil.initProxy(application, string, string2, string3, string4);
    }

    public static String[] loadProxy(Application object) {
        if (((File)(object = ((Application)object).getLocalPath("proxy.txt"))).exists()) {
            try {
                Config config = Config.parseConfig((File)object, Config.createOpts(false));
                return new String[]{config.getString("host"), config.getString("port")};
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to read '" + object + "': " + iOException, new Object[0]);
            }
        }
        return new String[]{null, null};
    }

    public static void saveProxy(Application object, String object2, String string) {
        object = ((Application)object).getLocalPath("proxy.txt");
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream((File)object));
            Throwable throwable = null;
            try {
                if (!StringUtil.isBlank((String)object2)) {
                    printStream.println("host = " + (String)object2);
                }
                if (!StringUtil.isBlank(string)) {
                    printStream.println("port = " + string);
                }
                printStream.close();
            }
            catch (Throwable throwable2) {
                try {
                    object2 = throwable2;
                    throwable = throwable2;
                    throw object2;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            printStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        printStream.close();
                    }
                    throw throwable3;
                }
            }
        }
        catch (IOException iOException) {
            Log.log.warning("Error creating proxy file '" + object + "': " + iOException, new Object[0]);
        }
    }

    public static void initProxy(Application object, String object2, String string, String string2, String string3) {
        Object object3 = ((Application)object).getAppDir().getAbsolutePath();
        Object object4 = ServiceLoader.load(ProxyAuth.class);
        object3 = (object4 = ((ServiceLoader)object4).iterator()).hasNext() ? ((ProxyAuth)object4.next()).loadCredentials((String)object3) : null;
        if (object3 != null) {
            string2 = ((ProxyAuth.Credentials)object3).username;
            string3 = ((ProxyAuth.Credentials)object3).password;
        }
        boolean bl = !StringUtil.isBlank(string2) && !StringUtil.isBlank(string3);
        int n2 = StringUtil.isBlank(string) ? 80 : Integer.valueOf(string);
        Log.log.info("Using proxy", "host", object2, "port", n2, "haveCreds", bl);
        ((Application)object).proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)object2, n2));
        if (bl) {
            object = string2;
            object2 = string3.toCharArray();
            Authenticator.setDefault(new n((String)object, (char[])object2));
        }
    }
}

