/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.animated;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.tinymediamanager.scraper.animated.services.CastService;
import org.tinymediamanager.scraper.animated.services.MovieService;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class KyraApi {
    private static final String BASE_URL = "https://www.kyradb.com/api10/";
    public static final String PARAM_API_KEY = "Apikey";
    public static final String PARAM_USER_KEY = "Userkey";
    private Retrofit restAdapter;
    private String apiKey = "";
    private String userKey = "";

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public String getUserKey() {
        return this.userKey;
    }

    protected Retrofit.Builder newRestAdapterBuilder() {
        return new Retrofit.Builder();
    }

    protected Retrofit getRestAdapter() {
        if (this.restAdapter == null) {
            Retrofit.Builder builder = this.newRestAdapterBuilder();
            builder.baseUrl(BASE_URL);
            builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create()));
            builder.client(TmmHttpClient.newBuilder((boolean)true).addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request original = chain.request();
                    Request.Builder request = original.newBuilder().method(original.method(), original.body());
                    request.addHeader(KyraApi.PARAM_API_KEY, KyraApi.this.apiKey);
                    request.addHeader(KyraApi.PARAM_USER_KEY, KyraApi.this.userKey);
                    request.addHeader("Content-type", "application/json");
                    Response response = chain.proceed(request.build());
                    return response;
                }
            }).build());
            this.restAdapter = builder.build();
        }
        return this.restAdapter;
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (Object)new JsonDeserializer<Integer>(){

            public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return json.getAsInt();
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder;
    }

    public MovieService getMovieService() {
        return (MovieService)this.getRestAdapter().create(MovieService.class);
    }

    public CastService getCastService() {
        return (CastService)this.getRestAdapter().create(CastService.class);
    }
}

