/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.animated;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.animated.KyraApi;
import org.tinymediamanager.scraper.animated.entities.Image;
import org.tinymediamanager.scraper.animated.entities.KyraEntity;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

@PluginImplementation
public class AnimatedMetadataProvider
implements IMovieArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnimatedMetadataProvider.class);
    private static final String TMM_API_KEY = ApiKey.decryptApikey((String)"ZCj2SXQCu+iVTt7RYUqlds0UoCJWuWTZpDIcAIZnvV3CoCeyu2srJQCcZVz5RFAT");
    private static final String TMM_USER_KEY = ApiKey.decryptApikey((String)"shv369dt1GcJH0bL7Dab3LseS1H0UyEBRKC361coeSM=");
    private static MediaProviderInfo providerInfo = AnimatedMetadataProvider.createMediaProviderInfo();
    private static KyraApi api = null;

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("animated", "KyraAnimated", "<html><h3>KyraDB Animated Posters</h3><br />as seen on https://forum.kodi.tv/showthread.php?tid=343391 :)</html>", AnimatedMetadataProvider.class.getResource("/kyradb_logo.png"));
        providerInfo.setVersion(AnimatedMetadataProvider.class);
        providerInfo.getConfig().addText("apiKey", "", true);
        providerInfo.getConfig().addText("userKey", "", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    private static synchronized void initAPI() throws ScrapeException {
        String apiKey;
        if (api == null) {
            try {
                api = new KyraApi();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing KyraApi!", (Throwable)e);
                throw new ScrapeException((Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(apiKey = providerInfo.getConfig().getValue("apiKey"))) && !apiKey.equals(api.getApiKey())) {
            api.setApiKey(apiKey);
        } else {
            api.setApiKey(TMM_API_KEY);
        }
        String userKey = providerInfo.getConfig().getValue("userKey");
        if (StringUtils.isNotBlank((CharSequence)userKey) && !userKey.equals(api.getUserKey())) {
            api.setUserKey(userKey);
        } else {
            api.setUserKey(TMM_USER_KEY);
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws MissingIdException, ScrapeException {
        List<MediaArtwork> artwork;
        LOGGER.debug("getArtwork() - {}", (Object)options);
        AnimatedMetadataProvider.initAPI();
        switch (options.getType()) {
            case MOVIE: {
                artwork = this.getMovieArtwork(options);
                break;
            }
            default: {
                artwork = new ArrayList<MediaArtwork>(1);
            }
        }
        MediaMetadata md = options.getMetadata();
        if (md != null && artwork.size() > 0) {
            md.addMediaArt(artwork);
        }
        return artwork;
    }

    private List<MediaArtwork> getMovieArtwork(MediaScrapeOptions options) throws MissingIdException, ScrapeException {
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        String imdbId = options.getImdbId();
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = "";
        }
        int tmdbId = options.getTmdbId();
        if (StringUtils.isBlank((CharSequence)imdbId) && tmdbId == 0) {
            LOGGER.info("neither IMDB nor TMDB id set - returning");
            throw new MissingIdException(new String[]{"imdb", "tmdb"});
        }
        String language = "en";
        if (options.getLanguage() != null) {
            language = options.getLanguage().getLanguage();
        }
        List<MediaArtwork> returnArtwork = new ArrayList<MediaArtwork>();
        Exception savedException = null;
        Response httpResponse = null;
        if (tmdbId != 0) {
            try {
                LOGGER.debug("getArtwork with TMDB id: {}", (Object)tmdbId);
                switch (artworkType) {
                    case LOGO: {
                        httpResponse = api.getMovieService().getLogo(tmdbId).execute();
                        break;
                    }
                    case CHARACTERART: {
                        httpResponse = api.getMovieService().getCharacterArt(tmdbId).execute();
                        break;
                    }
                    default: {
                        httpResponse = api.getMovieService().getAnimatedImages(tmdbId).execute();
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if ((httpResponse == null || !httpResponse.isSuccessful()) && StringUtils.isNotBlank((CharSequence)imdbId)) {
            try {
                LOGGER.debug("getArtwork with IMDB id: {}", (Object)imdbId);
                switch (artworkType) {
                    case LOGO: {
                        httpResponse = api.getMovieService().getLogo(imdbId).execute();
                        break;
                    }
                    case CHARACTERART: {
                        httpResponse = api.getMovieService().getCharacterArt(imdbId).execute();
                        break;
                    }
                    default: {
                        httpResponse = api.getMovieService().getAnimatedImages(imdbId).execute();
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (!(httpResponse != null && httpResponse.isSuccessful() || savedException == null)) {
            if (savedException instanceof InterruptedException) {
                return returnArtwork;
            }
            if (savedException instanceof InterruptedIOException) {
                return returnArtwork;
            }
            throw new ScrapeException((Throwable)savedException);
        }
        if (httpResponse == null) {
            LOGGER.info("got no result");
            return returnArtwork;
        }
        if (!httpResponse.isSuccessful()) {
            String message = "";
            try {
                message = httpResponse.errorBody().string();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.warn("request was not successful: HTTP/{} - {}", (Object)httpResponse.code(), (Object)message);
            return returnArtwork;
        }
        KyraEntity kyra = (KyraEntity)httpResponse.body();
        returnArtwork = this.getArtwork(kyra, artworkType);
        returnArtwork.sort((Comparator<MediaArtwork>)new MediaArtwork.MediaArtworkComparator(language));
        return returnArtwork;
    }

    private List<MediaArtwork> getArtwork(KyraEntity kyra, MediaArtwork.MediaArtworkType artworkType) {
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        String baseUrl = this.getBaseUrl(kyra, artworkType);
        switch (artworkType) {
            case POSTER: {
                artworks.addAll(this.prepareArtwork(kyra.getPosters(), baseUrl, artworkType));
                break;
            }
            case BACKGROUND: {
                artworks.addAll(this.prepareArtwork(kyra.getBackgrounds(), baseUrl, artworkType));
                break;
            }
            case LOGO: {
                artworks.addAll(this.prepareArtwork(kyra.getLogos(), baseUrl, artworkType));
                break;
            }
            case CHARACTERART: {
                artworks.addAll(this.prepareArtwork(kyra.getCharacters(), baseUrl, artworkType));
                break;
            }
            case ACTOR: {
                artworks.addAll(this.prepareArtwork(kyra.getActors(), baseUrl, artworkType));
                break;
            }
            case ALL: {
                artworks.addAll(this.prepareArtwork(kyra.getPosters(), kyra.getBasePosters(), MediaArtwork.MediaArtworkType.POSTER));
                artworks.addAll(this.prepareArtwork(kyra.getBackgrounds(), kyra.getBaseBackground(), MediaArtwork.MediaArtworkType.BACKGROUND));
                artworks.addAll(this.prepareArtwork(kyra.getLogos(), kyra.getBaseLogos(), MediaArtwork.MediaArtworkType.LOGO));
                artworks.addAll(this.prepareArtwork(kyra.getCharacters(), kyra.getBaseCharacter(), MediaArtwork.MediaArtworkType.CHARACTERART));
                artworks.addAll(this.prepareArtwork(kyra.getActors(), kyra.getBaseActor(), MediaArtwork.MediaArtworkType.ACTOR));
                break;
            }
        }
        return artworks;
    }

    private List<MediaArtwork> prepareArtwork(List<Image> images, String baseUrl, MediaArtwork.MediaArtworkType type) {
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        for (Image image : ListUtils.nullSafe(images)) {
            MediaArtwork ma = new MediaArtwork(providerInfo.getId(), type);
            String url = baseUrl + "/" + image.getName();
            ma.setDefaultUrl(url);
            if (type == MediaArtwork.MediaArtworkType.POSTER || type == MediaArtwork.MediaArtworkType.BACKGROUND) {
                ma.setAnimated(true);
            }
            ma.addImageSize(image.getWidth(), image.getHeight(), url);
            artworks.add(ma);
        }
        return artworks;
    }

    private String getBaseUrl(KyraEntity kyra, MediaArtwork.MediaArtworkType type) {
        String ret = "";
        switch (type) {
            case POSTER: {
                ret = kyra.getBasePosters();
                break;
            }
            case BACKGROUND: {
                ret = kyra.getBaseBackground();
                break;
            }
            case LOGO: 
            case CLEARLOGO: {
                ret = kyra.getBaseLogos();
                break;
            }
            case CHARACTERART: {
                ret = kyra.getBaseCharacter();
                break;
            }
            case ACTOR: {
                ret = kyra.getBaseActor();
                break;
            }
        }
        return ret;
    }
}

