/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.SubtitleSearchOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.IMediaSubtitleProvider;
import org.tinymediamanager.scraper.opensubtitles.TmmXmlRpcClient;
import org.tinymediamanager.scraper.opensubtitles.TmmXmlRpcException;
import org.tinymediamanager.scraper.opensubtitles.model.Info;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.Similarity;

@PluginImplementation
public class OpensubtitlesMetadataProvider
implements IMediaSubtitleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensubtitlesMetadataProvider.class);
    private static final String SERVICE = "http://api.opensubtitles.org/xml-rpc";
    private static final String USER_AGENT = "tinyMediaManager v1";
    private static final int HASH_CHUNK_SIZE = 65536;
    private static MediaProviderInfo providerInfo = OpensubtitlesMetadataProvider.createMediaProviderInfo();
    private static TmmXmlRpcClient client = null;
    private static String sessionToken = "";
    private static String username = "";
    private static String password = "";

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("opensubtitles", "OpenSubtitles.org", "<html><h3>OpenSubtitles.org</h3><br />A subtitle scraper for OpenSubtitles.org</html>", OpensubtitlesMetadataProvider.class.getResource("/opensubtitles_org.png"));
        providerInfo.setVersion(OpensubtitlesMetadataProvider.class);
        return providerInfo;
    }

    public OpensubtitlesMetadataProvider() {
        providerInfo.getConfig().addText("username", "");
        providerInfo.getConfig().addText("password", "", true);
        providerInfo.getConfig().load();
        OpensubtitlesMetadataProvider.initAPI();
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    private static synchronized void initAPI() {
        if (client == null) {
            try {
                client = new TmmXmlRpcClient(new URL(SERVICE), USER_AGENT);
            }
            catch (MalformedURLException e) {
                LOGGER.error("cannot create XmlRpcClient", (Throwable)e);
            }
        }
    }

    public List<SubtitleSearchResult> search(SubtitleSearchOptions options) throws UnsupportedMediaTypeException, ScrapeException {
        Info info;
        HashMap<String, String> mapQuery;
        ArrayList<SubtitleSearchResult> results = new ArrayList<SubtitleSearchResult>();
        if (options.getMediaType() != MediaType.SUBTITLE) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        if (options.getFile() != null) {
            File file = options.getFile();
            if (file.exists() && file.length() > 0L) {
                long fileSize = file.length();
                String hash = OpensubtitlesMetadataProvider.computeOpenSubtitlesHash(file);
                LOGGER.debug("searching subtitle for " + file);
                LOGGER.debug("moviebytesize: " + fileSize + "; moviehash: " + hash);
                HashMap<String, Object> mapQuery2 = new HashMap<String, Object>();
                mapQuery2.put("moviebytesize", fileSize);
                mapQuery2.put("moviehash", hash);
                mapQuery2.put("sublanguageid", this.getLanguageCode(options.getLanguage()));
                try {
                    Object[] arrayQuery = new Object[]{mapQuery2};
                    Info info2 = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                    for (Info.MovieInfo movieInfo : info2.getMovieInfo()) {
                        SubtitleSearchResult result = new SubtitleSearchResult(providerInfo.getId(), 1.0f);
                        result.setId(movieInfo.id);
                        result.setTitle(movieInfo.movieTitle);
                        result.setReleaseName(movieInfo.movieReleaseName);
                        result.setUrl(movieInfo.zipDownloadLink);
                        result.setRating(movieInfo.subRating.floatValue());
                        results.add(result);
                    }
                    LOGGER.debug("found {} results", (Object)info2.getMovieInfo().size());
                }
                catch (TmmXmlRpcException e) {
                    switch (e.statusCode) {
                        case 401: 
                        case 403: {
                            throw new ScrapeException((Throwable)new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                        }
                        case 407: 
                        case 429: {
                            throw new ScrapeException((Throwable)new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                        }
                    }
                    throw new ScrapeException(e.getCause());
                }
                catch (Exception e) {
                    LOGGER.error("Could not search subtitle - {}", (Object)e.getMessage());
                }
            } else {
                LOGGER.warn("file does not exist or is zero byte: {}", (Object)file);
            }
        }
        if (results.isEmpty() && StringUtils.isNotBlank((CharSequence)options.getImdbId())) {
            mapQuery = new HashMap<String, String>();
            LOGGER.debug("searching subtitle for imdb id: {}", (Object)options.getImdbId());
            mapQuery.put("imdbid", options.getImdbId().replace("tt", ""));
            mapQuery.put("sublanguageid", this.getLanguageCode(options.getLanguage()));
            if (options.getEpisode() > -1) {
                mapQuery.put("episode", String.valueOf(options.getEpisode()));
            }
            if (options.getSeason() > -1) {
                mapQuery.put("season", String.valueOf(options.getSeason()));
            }
            try {
                Object[] arrayQuery = new Object[]{mapQuery};
                info = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                for (Info.MovieInfo movieInfo : info.getMovieInfo()) {
                    SubtitleSearchResult result = new SubtitleSearchResult(providerInfo.getId(), 0.9f);
                    result.setId(movieInfo.id);
                    result.setTitle(movieInfo.movieTitle);
                    result.setReleaseName(movieInfo.movieReleaseName);
                    result.setUrl(movieInfo.zipDownloadLink);
                    result.setRating(movieInfo.subRating.floatValue());
                    results.add(result);
                }
                LOGGER.debug("found {} results", (Object)info.getMovieInfo().size());
            }
            catch (TmmXmlRpcException e) {
                switch (e.statusCode) {
                    case 401: 
                    case 403: {
                        throw new ScrapeException((Throwable)new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                    }
                    case 407: 
                    case 429: {
                        throw new ScrapeException((Throwable)new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                    }
                }
                throw new ScrapeException(e.getCause());
            }
            catch (Exception e) {
                LOGGER.error("Could not search subtitle.", (Throwable)e);
            }
        }
        if (results.isEmpty() && StringUtils.isNotBlank((CharSequence)options.getQuery())) {
            mapQuery = new HashMap();
            LOGGER.debug("serching subtitle for query: {}", (Object)options.getQuery());
            mapQuery.put("query", options.getQuery());
            mapQuery.put("sublanguageid", this.getLanguageCode(options.getLanguage()));
            try {
                Object[] arrayQuery = new Object[]{mapQuery};
                info = new Info((Map)this.methodCall("SearchSubtitles", arrayQuery));
                for (Info.MovieInfo movieInfo : info.getMovieInfo()) {
                    float score = 0.8f * Similarity.compareStrings((String)options.getQuery(), (String)movieInfo.movieTitle);
                    SubtitleSearchResult result = new SubtitleSearchResult(providerInfo.getId(), score);
                    result.setId(movieInfo.id);
                    result.setTitle(movieInfo.movieTitle);
                    result.setReleaseName(movieInfo.movieReleaseName);
                    result.setUrl(movieInfo.zipDownloadLink);
                    result.setRating(movieInfo.subRating.floatValue());
                    results.add(result);
                }
                LOGGER.debug("found {} results", (Object)info.getMovieInfo().size());
            }
            catch (TmmXmlRpcException e) {
                switch (e.statusCode) {
                    case 401: 
                    case 403: {
                        throw new ScrapeException((Throwable)new Exception("Access to Opensubtitles was not successfull (HTTP " + e.statusCode + ")"));
                    }
                    case 407: 
                    case 429: {
                        throw new ScrapeException((Throwable)new Exception("Rate limit exceeded (HTTP " + e.statusCode + ")"));
                    }
                }
                throw new ScrapeException((Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Could not search subtitle.", (Throwable)e);
            }
        }
        Collections.sort(results);
        Collections.reverse(results);
        return results;
    }

    private Object methodCall(String method, Object params) throws TmmXmlRpcException {
        OpensubtitlesMetadataProvider.startSession();
        Object response = null;
        if (StringUtils.isNotBlank((CharSequence)sessionToken)) {
            response = params != null ? client.call(method, sessionToken, params) : client.call(method, sessionToken);
        } else {
            LOGGER.warn("Have no session - seems the startSession() did not work successfully");
        }
        return response;
    }

    private String getLanguageCode(Locale locale) {
        String languageCode = LanguageUtils.getISO3BLanguage((String)locale.getLanguage());
        if ("gre".equals(languageCode)) {
            languageCode = "ell";
        }
        return languageCode;
    }

    private static synchronized void startSession() throws TmmXmlRpcException {
        if (providerInfo.getConfig().getValue("username") != null && !username.equals(providerInfo.getConfig().getValue("username")) || providerInfo.getConfig().getValue("password") != null && !password.equals(providerInfo.getConfig().getValue("password"))) {
            username = providerInfo.getConfig().getValue("username");
            password = providerInfo.getConfig().getValue("password");
            sessionToken = "";
        }
        if (StringUtils.isBlank((CharSequence)sessionToken)) {
            Map response = (Map)client.call("LogIn", username, password, "", USER_AGENT);
            sessionToken = (String)response.get("token");
            LOGGER.debug("Login OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeOpenSubtitlesHash(File file) {
        long size = file.length();
        long chunkSizeForFile = Math.min(65536L, size);
        FileInputStream is = null;
        AbstractInterruptibleChannel fileChannel = null;
        try {
            is = new FileInputStream(file);
            fileChannel = is.getChannel();
            long head = OpensubtitlesMetadataProvider.computeOpenSubtitlesHashForChunk(((FileChannel)fileChannel).map(FileChannel.MapMode.READ_ONLY, 0L, chunkSizeForFile));
            long tail = OpensubtitlesMetadataProvider.computeOpenSubtitlesHashForChunk(((FileChannel)fileChannel).map(FileChannel.MapMode.READ_ONLY, Math.max(size - 65536L, 0L), chunkSizeForFile));
            String string = String.format("%016x", size + head + tail);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error computing OpenSubtitles hash", (Throwable)e);
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error closing file stream", (Throwable)e);
            }
        }
        return "";
    }

    private static long computeOpenSubtitlesHashForChunk(ByteBuffer buffer) {
        LongBuffer longBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long hash = 0L;
        while (longBuffer.hasRemaining()) {
            hash += longBuffer.get();
        }
        return hash;
    }
}

