/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.encryption;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.mp4parser.Container;
import org.mp4parser.boxes.iso14496.part12.SchemeTypeBox;
import org.mp4parser.boxes.iso23001.part7.CencSampleAuxiliaryDataFormat;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.tracks.encryption.KeyIdKeyPair;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.Path;
import org.mp4parser.tools.RangeStartMap;

public class CencEncryptingSampleList
extends AbstractList<Sample> {
    private final RangeStartMap<Integer, SampleEntry> sampleEntries;
    private List<CencSampleAuxiliaryDataFormat> auxiliaryDataFormats;
    private RangeStartMap<Integer, KeyIdKeyPair> keys = new RangeStartMap();
    private List<Sample> parent;
    private Map<String, Cipher> ciphers = new HashMap<String, Cipher>();

    public CencEncryptingSampleList(RangeStartMap<Integer, KeyIdKeyPair> keys, RangeStartMap<Integer, SampleEntry> sampleEntries, List<Sample> parent, List<CencSampleAuxiliaryDataFormat> auxiliaryDataFormats) {
        this.sampleEntries = sampleEntries;
        this.auxiliaryDataFormats = auxiliaryDataFormats;
        this.keys = keys;
        this.parent = parent;
        try {
            this.ciphers.put("cenc", Cipher.getInstance("AES/CTR/NoPadding"));
            this.ciphers.put("cbc1", Cipher.getInstance("AES/CBC/NoPadding"));
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Sample get(int index) {
        Sample clearSample = this.parent.get(index);
        if (this.keys.get((Object)index) != null && ((KeyIdKeyPair)this.keys.get((Object)index)).getKeyId() != null) {
            return new EncryptedSampleImpl(clearSample, index);
        }
        return clearSample;
    }

    private void initCipher(Cipher cipher, byte[] iv, SecretKey cek) {
        try {
            byte[] fullIv = new byte[16];
            System.arraycopy(iv, 0, fullIv, 0, iv.length);
            cipher.init(1, (Key)cek, new IvParameterSpec(fullIv));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    private class EncryptedSampleImpl
    implements Sample {
        private final Sample clearSample;
        private int index;

        private EncryptedSampleImpl(Sample clearSample, int index) {
            this.clearSample = clearSample;
            this.index = index;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            ByteBuffer sample = (ByteBuffer)this.clearSample.asByteBuffer().rewind();
            SampleEntry se = (SampleEntry)CencEncryptingSampleList.this.sampleEntries.get((Object)this.index);
            KeyIdKeyPair keyIdKeyPair = (KeyIdKeyPair)CencEncryptingSampleList.this.keys.get((Object)this.index);
            CencSampleAuxiliaryDataFormat entry = (CencSampleAuxiliaryDataFormat)CencEncryptingSampleList.this.auxiliaryDataFormats.get(this.index);
            SchemeTypeBox schm = (SchemeTypeBox)Path.getPath((Container)se, (String)"sinf[0]/schm[0]");
            assert (schm != null);
            String encryptionAlgo = schm.getSchemeType();
            Cipher cipher = (Cipher)CencEncryptingSampleList.this.ciphers.get(encryptionAlgo);
            CencEncryptingSampleList.this.initCipher(cipher, entry.iv, keyIdKeyPair.getKey());
            try {
                if (entry.pairs != null && entry.pairs.length > 0) {
                    byte[] fullSample = new byte[sample.limit()];
                    sample.get(fullSample);
                    int offset = 0;
                    for (CencSampleAuxiliaryDataFormat.Pair pair : entry.pairs) {
                        offset += pair.clear();
                        if (pair.encrypted() <= 0L) continue;
                        cipher.update(fullSample, offset, CastUtils.l2i((long)pair.encrypted()), fullSample, offset);
                        offset = (int)((long)offset + pair.encrypted());
                    }
                    channel.write(ByteBuffer.wrap(fullSample));
                } else {
                    byte[] fullyEncryptedSample = new byte[sample.limit()];
                    sample.get(fullyEncryptedSample);
                    if ("cbc1".equals(encryptionAlgo)) {
                        int encryptedLength = fullyEncryptedSample.length / 16 * 16;
                        channel.write(ByteBuffer.wrap(cipher.doFinal(fullyEncryptedSample, 0, encryptedLength)));
                        channel.write(ByteBuffer.wrap(fullyEncryptedSample, encryptedLength, fullyEncryptedSample.length - encryptedLength));
                    } else if ("cenc".equals(encryptionAlgo)) {
                        channel.write(ByteBuffer.wrap(cipher.doFinal(fullyEncryptedSample)));
                    }
                }
                sample.rewind();
            }
            catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long getSize() {
            return this.clearSample.getSize();
        }

        @Override
        public ByteBuffer asByteBuffer() {
            ByteBuffer sample = (ByteBuffer)this.clearSample.asByteBuffer().rewind();
            ByteBuffer encSample = ByteBuffer.allocate(sample.limit());
            SampleEntry se = (SampleEntry)CencEncryptingSampleList.this.sampleEntries.get((Object)this.index);
            KeyIdKeyPair keyIdKeyPair = (KeyIdKeyPair)CencEncryptingSampleList.this.keys.get((Object)this.index);
            CencSampleAuxiliaryDataFormat entry = (CencSampleAuxiliaryDataFormat)CencEncryptingSampleList.this.auxiliaryDataFormats.get(this.index);
            SchemeTypeBox schm = (SchemeTypeBox)Path.getPath((Container)se, (String)"sinf[0]/schm[0]");
            assert (schm != null);
            String encryptionAlgo = schm.getSchemeType();
            Cipher cipher = (Cipher)CencEncryptingSampleList.this.ciphers.get(encryptionAlgo);
            CencEncryptingSampleList.this.initCipher(cipher, entry.iv, keyIdKeyPair.getKey());
            try {
                if (entry.pairs != null) {
                    for (CencSampleAuxiliaryDataFormat.Pair pair : entry.pairs) {
                        byte[] clears = new byte[pair.clear()];
                        sample.get(clears);
                        encSample.put(clears);
                        if (pair.encrypted() <= 0L) continue;
                        byte[] toBeEncrypted = new byte[CastUtils.l2i((long)pair.encrypted())];
                        sample.get(toBeEncrypted);
                        assert (toBeEncrypted.length % 16 == 0);
                        byte[] encrypted = cipher.update(toBeEncrypted);
                        assert (encrypted.length == toBeEncrypted.length);
                        encSample.put(encrypted);
                    }
                } else {
                    byte[] fullyEncryptedSample = new byte[sample.limit()];
                    sample.get(fullyEncryptedSample);
                    if ("cbc1".equals(encryptionAlgo)) {
                        int encryptedLength = fullyEncryptedSample.length / 16 * 16;
                        encSample.put(cipher.doFinal(fullyEncryptedSample, 0, encryptedLength));
                        encSample.put(fullyEncryptedSample, encryptedLength, fullyEncryptedSample.length - encryptedLength);
                    } else if ("cenc".equals(encryptionAlgo)) {
                        encSample.put(cipher.doFinal(fullyEncryptedSample));
                    }
                }
                sample.rewind();
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            encSample.rewind();
            return encSample;
        }

        @Override
        public SampleEntry getSampleEntry() {
            return (SampleEntry)CencEncryptingSampleList.this.sampleEntries.get((Object)this.index);
        }
    }
}

