/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.tools.CastUtils;

public class MemoryDataSourceImpl
implements DataSource {
    ByteBuffer data;

    public MemoryDataSourceImpl(byte[] data) {
        this.data = ByteBuffer.wrap(data);
    }

    public MemoryDataSourceImpl(ByteBuffer buffer) {
        this.data = buffer;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (0 == this.data.remaining() && 0 != byteBuffer.remaining()) {
            return -1;
        }
        int size = Math.min(byteBuffer.remaining(), this.data.remaining());
        if (byteBuffer.hasArray()) {
            byteBuffer.put(this.data.array(), this.data.position(), size);
            this.data.position(this.data.position() + size);
        } else {
            byte[] buf = new byte[size];
            this.data.get(buf);
            byteBuffer.put(buf);
        }
        return size;
    }

    @Override
    public long size() throws IOException {
        return this.data.capacity();
    }

    @Override
    public long position() throws IOException {
        return this.data.position();
    }

    @Override
    public void position(long nuPos) throws IOException {
        this.data.position(CastUtils.l2i((long)nuPos));
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return target.write((ByteBuffer)((ByteBuffer)this.data.position(CastUtils.l2i((long)position))).slice().limit(CastUtils.l2i((long)count)));
    }

    @Override
    public ByteBuffer map(long startPosition, long size) throws IOException {
        int oldPosition = this.data.position();
        this.data.position(CastUtils.l2i((long)startPosition));
        ByteBuffer result = this.data.slice();
        result.limit(CastUtils.l2i((long)size));
        this.data.position(oldPosition);
        return result;
    }

    @Override
    public void close() throws IOException {
    }
}

