/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.panels.TvShowScraperMetadataPanel;

class TvShowScraperOptionsSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 4999827736720726395L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private JCheckBox chckbxAutomaticallyScrapeImages;
    private JComboBox<MediaLanguages> cbScraperLanguage;
    private JComboBox<CountryCode> cbCertificationCountry;
    private JCheckBox chckbxCapitalizeWords;

    TvShowScraperOptionsSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow,shrink 0]", "[][]15lp![][15lp!][][15lp!][]"));
        JPanel panelOptions = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblOptions = new TmmLabel(BUNDLE.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptions, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblScraperLanguage = new JLabel(BUNDLE.getString("Settings.preferredLanguage"));
        panelOptions.add((Component)lblScraperLanguage, "cell 1 0 2 1");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelOptions.add(this.cbScraperLanguage, "cell 1 0");
        JLabel lblCountry = new JLabel(BUNDLE.getString("Settings.certificationCountry"));
        panelOptions.add((Component)lblCountry, "cell 1 1 2 1");
        this.cbCertificationCountry = new JComboBox<CountryCode>(CountryCode.values());
        panelOptions.add(this.cbCertificationCountry, "cell 1 1");
        this.chckbxCapitalizeWords = new JCheckBox(BUNDLE.getString("Settings.scraper.capitalizeWords"));
        panelOptions.add((Component)this.chckbxCapitalizeWords, "cell 1 2");
        JPanel panelDefaults = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblDefaultsT = new TmmLabel(BUNDLE.getString("scraper.metadata.defaults"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelDefaults, lblDefaultsT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        TvShowScraperMetadataPanel scraperMetadataPanel = new TvShowScraperMetadataPanel(this.settings.getScraperMetadataConfig());
        panelDefaults.add((Component)scraperMetadataPanel, "cell 1 0 2 1,grow");
        JPanel panelImages = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblImagesT = new TmmLabel(BUNDLE.getString("Settings.images"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelImages, lblImagesT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        this.chckbxAutomaticallyScrapeImages = new JCheckBox(BUNDLE.getString("Settings.default.autoscrape"));
        panelImages.add((Component)this.chckbxAutomaticallyScrapeImages, "cell 1 0 2 1");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_8 = BeanProperty.create((String)"scraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_8, this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_7.bind();
        BeanProperty settingsBeanProperty_9 = BeanProperty.create((String)"certificationCountry");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_9, this.cbCertificationCountry, (Property)jComboBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"scrapeBestImage");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxAutomaticallyScrapeImages, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_10 = BeanProperty.create((String)"capitalWordsInTitles");
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_10, (Object)this.chckbxCapitalizeWords, (Property)jCheckBoxBeanProperty_1);
        autoBinding_9.bind();
    }
}

