/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;

public class TvShowRenamerSettingsPanel
extends JPanel
implements HierarchyListener {
    private static final long serialVersionUID = 5189531235704401313L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenamerSettingsPanel.class);
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private List<String> spaceReplacement = new ArrayList<String>(Arrays.asList("_", ".", "-"));
    private List<String> colonReplacement = new ArrayList<String>(Arrays.asList(" ", "-"));
    private EventList<TvShowRenamerExample> exampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowRenamerExample.class)));
    private JLabel lblExample;
    private JComboBox<TvShowPreviewContainer> cbTvShowForPreview;
    private EnhancedTextField tfSeasonFolderName;
    private JCheckBox chckbxAsciiReplacement;
    private JComboBox<String> cbSpaceReplacement;
    private JCheckBox chckbxSpaceReplacement;
    private JComboBox<TvShowEpisodePreviewContainer> cbEpisodeForPreview;
    private TmmTable tableExamples;
    private EnhancedTextField tfTvShowFolder;
    private EnhancedTextField tfEpisodeFilename;
    private JCheckBox chckbxSpecialSeason;
    private JComboBox cbColonReplacement;

    public TvShowRenamerSettingsPanel() {
        String colonReplacement;
        this.initComponents();
        this.initDataBindings();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                TvShowRenamerSettingsPanel.this.createRenamerExample();
            }
        };
        this.tfTvShowFolder.getDocument().addDocumentListener(documentListener);
        this.tfSeasonFolderName.getDocument().addDocumentListener(documentListener);
        this.tfEpisodeFilename.getDocument().addDocumentListener(documentListener);
        this.cbTvShowForPreview.addActionListener(arg0 -> {
            this.buildAndInstallEpisodeArray();
            this.createRenamerExample();
        });
        String spaceReplacement = this.settings.getRenamerSpaceReplacement();
        int index = this.spaceReplacement.indexOf(spaceReplacement);
        if (index >= 0) {
            this.cbSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.colonReplacement.indexOf(colonReplacement = this.settings.getRenamerColonReplacement())) >= 0) {
            this.cbColonReplacement.setSelectedIndex(index);
        }
        this.lblExample.putClientProperty("clipPosition", 2);
        this.exampleEventList.add((Object)new TvShowRenamerExample("${title}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${originalTitle}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${titleSortable}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonNr}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonNr2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonNrDvd}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${seasonNrDvd2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeNr}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeNr2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeNrDvd}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${episodeNrDvd2}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${airedDate}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${year}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showYear}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showTitle}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showOriginalTitle}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showTitleSortable}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoResolution}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoFormat}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoCodec}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoFormat}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${videoBitDepth}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioCodec}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioCodecList}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioCodecsAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannels}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannelList}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioChannelsAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioLanguage}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioLanguageList}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${audioLanguagesAsString}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${mediaSource}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${hdr}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${parent}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${showNote}"));
        this.exampleEventList.add((Object)new TvShowRenamerExample("${note}"));
        ActionListener renamerActionListener = arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        };
        this.chckbxSpaceReplacement.addActionListener(renamerActionListener);
        this.chckbxAsciiReplacement.addActionListener(renamerActionListener);
        this.chckbxSpecialSeason.addActionListener(renamerActionListener);
        this.cbEpisodeForPreview.addActionListener(arg0 -> this.createRenamerExample());
        this.cbSpaceReplacement.addActionListener(renamerActionListener);
        this.cbColonReplacement.addActionListener(renamerActionListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][]"));
        JPanel panelPatterns = new JPanel((LayoutManager)new MigLayout("insets 0, hidemode 1", "[20lp!][15lp][][300lp,grow]", "[][][][][][][]"));
        TmmLabel lblPatternsT = new TmmLabel(BUNDLE.getString("Settings.tvshow.renamer.title"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelPatterns, lblPatternsT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        JLabel lblTvShowFolder = new JLabel(BUNDLE.getString("Settings.tvshowfoldername"));
        panelPatterns.add((Component)lblTvShowFolder, "cell 1 0 2 1,alignx right");
        this.tfTvShowFolder = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfTvShowFolder.setIconToolTipText(BUNDLE.getString("Settings.renamer.reverttodefault"));
        this.tfTvShowFolder.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowRenamerSettingsPanel.this.tfTvShowFolder.setText("${showTitle} (${showYear})");
            }
        });
        panelPatterns.add((Component)this.tfTvShowFolder, "cell 3 0 2 1,growx");
        JLabel lblDefault = new JLabel(BUNDLE.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 1 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultFolderPattern = new ReadOnlyTextArea("${showTitle} (${showYear})");
        panelPatterns.add((Component)tpDefaultFolderPattern, "cell 3 1 2 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFolderPattern, TmmFontHelper.L2);
        JLabel lblSeasonFolderName = new JLabel(BUNDLE.getString("Settings.tvshowseasonfoldername"));
        panelPatterns.add((Component)lblSeasonFolderName, "cell 1 2 2 1,alignx right");
        this.tfSeasonFolderName = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfSeasonFolderName.setIconToolTipText(BUNDLE.getString("Settings.renamer.reverttodefault"));
        this.tfSeasonFolderName.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowRenamerSettingsPanel.this.tfSeasonFolderName.setText("Season ${seasonNr}");
            }
        });
        panelPatterns.add((Component)this.tfSeasonFolderName, "cell 3 2 2 1,growx");
        lblDefault = new JLabel(BUNDLE.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 3 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultSeasonPattern = new ReadOnlyTextArea("Season ${seasonNr}");
        panelPatterns.add((Component)tpDefaultSeasonPattern, "cell 3 3 2 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultSeasonPattern, TmmFontHelper.L2);
        JLabel lblEpisodeFileName = new JLabel(BUNDLE.getString("Settings.tvshowfilename"));
        panelPatterns.add((Component)lblEpisodeFileName, "cell 1 4 2 1,alignx right");
        this.tfEpisodeFilename = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfEpisodeFilename.setIconToolTipText(BUNDLE.getString("Settings.renamer.reverttodefault"));
        this.tfEpisodeFilename.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TvShowRenamerSettingsPanel.this.tfEpisodeFilename.setText("${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}");
            }
        });
        panelPatterns.add((Component)this.tfEpisodeFilename, "cell 3 4 2 1,growx");
        lblDefault = new JLabel(BUNDLE.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 5 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultFilePattern = new ReadOnlyTextArea("${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}");
        panelPatterns.add((Component)tpDefaultFilePattern, "cell 3 5 2 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFilePattern, TmmFontHelper.L2);
        JLabel lblRenamerHintT = new JLabel(BUNDLE.getString("Settings.tvshow.renamer.hint"));
        panelPatterns.add((Component)lblRenamerHintT, "cell 1 6 3 1");
        JButton btnHelp = new JButton(BUNDLE.getString("tmm.help"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://gitlab.com/tinyMediaManager/tinyMediaManager/wikis/TV-Show-Settings#renamer");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e1) {
                LOGGER.error("Wiki", (Throwable)e1);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelPatterns.add((Component)btnHelp, "cell 1 6 3 1");
        JPanel panelAdvancedOptions = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblAdvancedOptions = new TmmLabel(BUNDLE.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAdvancedOptions, lblAdvancedOptions, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx");
        this.chckbxSpecialSeason = new JCheckBox(BUNDLE.getString("tvshow.renamer.specialseason"));
        panelAdvancedOptions.add((Component)this.chckbxSpecialSeason, "cell 1 0 2 1");
        this.chckbxSpaceReplacement = new JCheckBox(BUNDLE.getString("Settings.renamer.spacereplacement"));
        this.chckbxSpaceReplacement.setToolTipText(BUNDLE.getString("Settings.renamer.spacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxSpaceReplacement, "cell 1 1 2 1");
        this.cbSpaceReplacement = new JComboBox<Object>(this.spaceReplacement.toArray());
        panelAdvancedOptions.add(this.cbSpaceReplacement, "cell 1 1");
        JLabel lblColonReplacement = new JLabel(BUNDLE.getString("Settings.renamer.colonreplacement"));
        panelAdvancedOptions.add((Component)lblColonReplacement, "cell 2 2");
        lblColonReplacement.setToolTipText(BUNDLE.getString("Settings.renamer.colonreplacement.hint"));
        this.cbColonReplacement = new JComboBox<Object>(this.colonReplacement.toArray());
        panelAdvancedOptions.add((Component)this.cbColonReplacement, "cell 2 2");
        this.chckbxAsciiReplacement = new JCheckBox(BUNDLE.getString("Settings.renamer.asciireplacement"));
        panelAdvancedOptions.add((Component)this.chckbxAsciiReplacement, "cell 1 3 2 1");
        JLabel lblAsciiHint = new JLabel(BUNDLE.getString("Settings.renamer.asciireplacement.hint"));
        panelAdvancedOptions.add((Component)lblAsciiHint, "cell 2 4");
        TmmFontHelper.changeFont((JComponent)lblAsciiHint, TmmFontHelper.L2);
        JPanel panelExample = new JPanel();
        panelExample.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][300lp,grow]", ""));
        lblAdvancedOptions = new TmmLabel(BUNDLE.getString("Settings.example"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelExample, lblAdvancedOptions, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx, wmin 0");
        JLabel lblExampleTvShowT = new JLabel(BUNDLE.getString("metatag.tvshow"));
        panelExample.add((Component)lblExampleTvShowT, "cell 1 0");
        this.cbTvShowForPreview = new JComboBox();
        panelExample.add(this.cbTvShowForPreview, "cell 1 0,growx,wmin 0");
        JLabel lblExampleEpisodeT = new JLabel(BUNDLE.getString("metatag.episode"));
        panelExample.add((Component)lblExampleEpisodeT, "cell 1 0");
        this.cbEpisodeForPreview = new JComboBox();
        panelExample.add(this.cbEpisodeForPreview, "cell 1 0,growx,wmin 0");
        this.lblExample = new JLabel("");
        panelExample.add((Component)this.lblExample, "cell 1 1, wmin 0");
        TmmFontHelper.changeFont((JComponent)this.lblExample, 1);
        DefaultEventTableModel exampleTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.exampleEventList), (TableFormat)new TvShowRenamerExampleTableFormat());
        this.tableExamples = new TmmTable((TableModel)exampleTableModel);
        JScrollPane scrollPane = new JScrollPane(this.tableExamples);
        this.tableExamples.configureScrollPane(scrollPane);
        panelExample.add((Component)scrollPane, "cell 1 2,grow");
        scrollPane.setViewportView(this.tableExamples);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing()) {
            this.buildAndInstallTvShowArray();
            this.buildAndInstallEpisodeArray();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    private void buildAndInstallTvShowArray() {
        this.cbTvShowForPreview.removeAllItems();
        ArrayList<TvShow> allTvShows = new ArrayList<TvShow>(TvShowList.getInstance().getTvShows());
        allTvShows.sort(new TvShowComparator());
        for (TvShow tvShow : allTvShows) {
            TvShowPreviewContainer container = new TvShowPreviewContainer();
            container.tvShow = tvShow;
            this.cbTvShowForPreview.addItem(container);
        }
    }

    private void buildAndInstallEpisodeArray() {
        this.cbEpisodeForPreview.removeAllItems();
        Object obj = this.cbTvShowForPreview.getSelectedItem();
        if (obj instanceof TvShowPreviewContainer) {
            TvShowPreviewContainer c = (TvShowPreviewContainer)this.cbTvShowForPreview.getSelectedItem();
            for (TvShowEpisode episode : c.tvShow.getEpisodes()) {
                TvShowEpisodePreviewContainer container = new TvShowEpisodePreviewContainer();
                container.episode = episode;
                this.cbEpisodeForPreview.addItem(container);
            }
        }
    }

    private void createRenamerExample() {
        SwingUtilities.invokeLater(() -> {
            Object container;
            TvShow tvShow = null;
            TvShowEpisode episode = null;
            if (this.cbTvShowForPreview.getSelectedItem() instanceof TvShowPreviewContainer) {
                container = (TvShowPreviewContainer)this.cbTvShowForPreview.getSelectedItem();
                tvShow = ((TvShowPreviewContainer)container).tvShow;
            }
            if (this.cbEpisodeForPreview.getSelectedItem() instanceof TvShowEpisodePreviewContainer) {
                container = (TvShowEpisodePreviewContainer)this.cbEpisodeForPreview.getSelectedItem();
                episode = ((TvShowEpisodePreviewContainer)container).episode;
            }
            if (tvShow != null && episode != null) {
                String tvShowDir = TvShowRenamer.getTvShowFoldername(this.tfTvShowFolder.getText(), tvShow);
                MediaFile episodeMf = TvShowRenamer.generateEpisodeFilenames(this.tfEpisodeFilename.getText(), tvShow, episode.getMediaFiles(MediaFileType.VIDEO).get(0)).get(0);
                String newFilenameAndPath = episodeMf.getFile().toString().replace(episode.getTvShow().getPath(), "");
                this.lblExample.setText(tvShowDir + newFilenameAndPath);
                for (TvShowRenamerExample example : this.exampleEventList) {
                    example.createExample(episode);
                }
                try {
                    TableColumnResizer.adjustColumnPreferredWidths(this.tableExamples, 7);
                }
                catch (Exception exception) {}
            } else {
                this.lblExample.setText("");
            }
        });
    }

    private void checkChanges() {
        String spaceReplacement = (String)this.cbSpaceReplacement.getSelectedItem();
        this.settings.setRenamerSpaceReplacement(spaceReplacement);
        String colonReplacement = (String)this.cbColonReplacement.getSelectedItem();
        this.settings.setRenamerColonReplacement(colonReplacement);
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_6 = BeanProperty.create((String)"asciiReplacement");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_6, (Object)this.chckbxAsciiReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"renamerSpaceSubstitution");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"renamerTvShowFoldername");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.tfTvShowFolder, (Property)jTextFieldBeanProperty_1);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"renamerFilename");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.tfEpisodeFilename, (Property)jTextFieldBeanProperty_2);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"renamerSeasonFoldername");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, (Object)this.tfSeasonFolderName, (Property)jTextFieldBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"specialSeason");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.chckbxSpecialSeason, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
    }

    private class TvShowRenamerExampleTableFormat
    implements TableFormat<TvShowRenamerExample> {
        private TvShowRenamerExampleTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("Settings.renamer.token.name");
                }
                case 1: {
                    return BUNDLE.getString("Settings.renamer.token");
                }
                case 2: {
                    return BUNDLE.getString("Settings.renamer.value");
                }
            }
            return null;
        }

        public Object getColumnValue(TvShowRenamerExample baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject.token;
                }
                case 1: {
                    return baseObject.description;
                }
                case 2: {
                    return baseObject.example;
                }
            }
            return null;
        }
    }

    private class TvShowRenamerExample
    extends AbstractModelObject {
        private String token;
        private String description;
        private String example = "";

        public TvShowRenamerExample(String token) {
            this.token = token;
            try {
                this.description = BUNDLE.getString("Settings.tvshow.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(TvShowEpisode episode) {
            String oldValue = this.example;
            this.example = episode == null ? "" : TvShowRenamer.createDestination(this.token, Collections.singletonList(episode));
            this.firePropertyChange("example", oldValue, this.example);
        }
    }

    private class TvShowComparator
    implements Comparator<TvShow> {
        private TvShowComparator() {
        }

        @Override
        public int compare(TvShow arg0, TvShow arg1) {
            return arg0.getTitle().compareTo(arg1.getTitle());
        }
    }

    private class TvShowEpisodePreviewContainer {
        TvShowEpisode episode;

        private TvShowEpisodePreviewContainer() {
        }

        public String toString() {
            return this.episode.getSeason() + "." + this.episode.getEpisode() + " " + this.episode.getTitle();
        }
    }

    private class TvShowPreviewContainer {
        TvShow tvShow;

        private TvShowPreviewContainer() {
        }

        public String toString() {
            return this.tvShow.getTitle();
        }
    }
}

