/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.TmmLabel;

class TvShowDatasourceSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -675729644848101096L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private JCheckBox chckbxDvdOrder;
    private JTextField tfAddBadword;
    private JList<String> listBadWords;
    private JList<String> listDatasources;
    private JList<String> listSkipFolder;
    private JButton btnAddDatasource;
    private JButton btnRemoveDatasource;
    private JButton btnAddSkipFolder;
    private JButton btnRemoveSkipFolder;
    private JButton btnRemoveBadWord;
    private JButton btnAddBadWord;

    TvShowDatasourceSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddDatasource.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("tvshow.datasource.path");
            Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.tvshowdatasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.settings.addTvShowDataSources(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("tvshow.datasource.path", file.toAbsolutePath().toString());
            }
        });
        this.btnRemoveDatasource.addActionListener(arg0 -> {
            int row = this.listDatasources.getSelectedIndex();
            if (row != -1) {
                String path = this.settings.getTvShowDataSource().get(row);
                Object[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                int decision = JOptionPane.showOptionDialog(null, String.format(BUNDLE.getString("Settings.tvshowdatasource.remove.info"), path), BUNDLE.getString("Settings.datasource.remove"), 0, -1, null, choices, BUNDLE.getString("Button.abort"));
                if (decision == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.settings.removeTvShowDataSources(path);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.btnAddSkipFolder.addActionListener(e -> {
            String path = TmmProperties.getInstance().getProperty("tvshow.ignore.path");
            Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.ignore"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.settings.addSkipFolder(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("tvshow.ignore.path", file.toAbsolutePath().toString());
            }
        });
        this.btnRemoveSkipFolder.addActionListener(e -> {
            int row = this.listSkipFolder.getSelectedIndex();
            if (row != -1) {
                String ingore = this.settings.getSkipFolder().get(row);
                this.settings.removeSkipFolder(ingore);
            }
        });
        this.btnAddBadWord.addActionListener(e -> {
            if (StringUtils.isNotEmpty((CharSequence)this.tfAddBadword.getText())) {
                TvShowModuleManager.SETTINGS.addBadWord(this.tfAddBadword.getText());
                this.tfAddBadword.setText("");
            }
        });
        this.btnRemoveBadWord.addActionListener(arg0 -> {
            int row = this.listBadWords.getSelectedIndex();
            if (row != -1) {
                String badWord = TvShowModuleManager.SETTINGS.getBadWord().get(row);
                TvShowModuleManager.SETTINGS.removeBadWord(badWord);
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][]"));
        JPanel panelDatasources = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][400lp][][grow]", "[100lp,grow][][]"));
        TmmLabel lblDatasourcesT = new TmmLabel(BUNDLE.getString("Settings.source"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelDatasources, lblDatasourcesT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelDatasources.add((Component)scrollPaneDataSources, "cell 1 0,grow");
        this.listDatasources = new JList();
        this.listDatasources.setSelectionMode(0);
        scrollPaneDataSources.setViewportView(this.listDatasources);
        this.btnAddDatasource = new JButton(IconManager.ADD_INV);
        panelDatasources.add((Component)this.btnAddDatasource, "flowy, cell 2 0, aligny top, growx");
        this.btnAddDatasource.setToolTipText(BUNDLE.getString("Button.add"));
        this.btnRemoveDatasource = new JButton(IconManager.REMOVE_INV);
        panelDatasources.add((Component)this.btnRemoveDatasource, "flowy, cell 2 0, aligny top, growx");
        this.btnRemoveDatasource.setToolTipText(BUNDLE.getString("Button.remove"));
        this.chckbxDvdOrder = new JCheckBox(BUNDLE.getString("Settings.dvdorder"));
        panelDatasources.add((Component)this.chckbxDvdOrder, "cell 1 2 2 1");
        JPanel panelIgnore = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][400lp][][grow]", "[100lp,grow]"));
        TmmLabel lblIgnoreT = new TmmLabel(BUNDLE.getString("Settings.ignore"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelIgnore, lblIgnoreT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        JScrollPane scrollPaneIgnore = new JScrollPane();
        panelIgnore.add((Component)scrollPaneIgnore, "cell 1 0,grow");
        this.listSkipFolder = new JList();
        scrollPaneIgnore.setViewportView(this.listSkipFolder);
        this.btnAddSkipFolder = new JButton(IconManager.ADD_INV);
        panelIgnore.add((Component)this.btnAddSkipFolder, "flowy, cell 2 0, aligny top, growx");
        this.btnAddSkipFolder.setToolTipText(BUNDLE.getString("Settings.addignore"));
        this.btnRemoveSkipFolder = new JButton(IconManager.REMOVE_INV);
        panelIgnore.add((Component)this.btnRemoveSkipFolder, "flowy, cell 2 0, aligny top, growx");
        this.btnRemoveSkipFolder.setToolTipText(BUNDLE.getString("Settings.removeignore"));
        JPanel panelBadWords = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][100lp][][grow]", "[][100lp,grow][]"));
        TmmLabel lblBadWordsT = new TmmLabel(BUNDLE.getString("Settings.movie.badwords"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelBadWords, lblBadWordsT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        JLabel lblBadWordsDesc = new JLabel(BUNDLE.getString("Settings.movie.badwords.hint"));
        panelBadWords.add((Component)lblBadWordsDesc, "cell 1 0 3 1");
        JScrollPane scrollPaneBadWords = new JScrollPane();
        panelBadWords.add((Component)scrollPaneBadWords, "cell 1 1,grow");
        this.listBadWords = new JList();
        scrollPaneBadWords.setViewportView(this.listBadWords);
        this.btnRemoveBadWord = new JButton(IconManager.REMOVE_INV);
        panelBadWords.add((Component)this.btnRemoveBadWord, "cell 2 1,aligny bottom");
        this.btnRemoveBadWord.setToolTipText(BUNDLE.getString("Button.remove"));
        this.tfAddBadword = new JTextField();
        panelBadWords.add((Component)this.tfAddBadword, "cell 1 2,growx");
        this.btnAddBadWord = new JButton(IconManager.ADD_INV);
        panelBadWords.add((Component)this.btnAddBadWord, "cell 2 2, growx");
        this.btnAddBadWord.setToolTipText(BUNDLE.getString("Button.add"));
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"dvdOrder");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxDvdOrder, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"tvShowDataSource");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, this.listDatasources);
        jListBinding.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"skipFolder");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, this.listSkipFolder);
        jListBinding_1.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"badWord");
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, this.listBadWords);
        jListBinding_2.bind();
    }
}

