/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.panels.ImagePanel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowArtworkPanel
extends JPanel {
    private static final long serialVersionUID = -8105505340634141604L;
    private final List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private ImagePanel imagePanel;

    public TvShowArtworkPanel(TvShowSelectionModel selectionModel) {
        this.initComponents();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source instanceof TvShowSelectionModel || source instanceof TvShow && "mediaFiles".equals(property)) {
                List<MediaFile> list = this.mediaFiles;
                synchronized (list) {
                    this.mediaFiles.clear();
                    for (MediaFile mediafile : new ArrayList<MediaFile>(selectionModel.getSelectedTvShow().getMediaFiles())) {
                        if (!mediafile.isGraphic()) continue;
                        this.mediaFiles.add(mediafile);
                    }
                    this.imagePanel.rebuildPanel();
                }
            }
        };
        selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[grow]"));
        this.imagePanel = new ImagePanel(this.mediaFiles);
        this.imagePanel.setMaxWidth(500);
        this.imagePanel.setMaxHeight(200);
        this.add((Component)this.imagePanel, "cell 0 0,grow");
    }
}

