/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowVideoFormatFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowVideoFormatFilter() {
        this.setValues(MediaFile.getVideoFormats());
    }

    @Override
    public String getId() {
        return "tvShowVideoFormat";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        for (String videoFormat : selectedValues) {
            for (TvShowEpisode episode : episodes) {
                if ("HD".equals(videoFormat) || "SD".equals(videoFormat)) {
                    if (invert ^ ("HD".equals(videoFormat) && this.isVideoHD(episode.getMediaInfoVideoFormat()))) {
                        return true;
                    }
                    if (!(invert ^ ("SD".equals(videoFormat) && !this.isVideoHD(episode.getMediaInfoVideoFormat())))) continue;
                    return true;
                }
                if (!(invert ^ videoFormat.equals(episode.getMediaInfoVideoFormat()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.resolution"));
    }

    private String[] getVideoFormats() {
        return new String[]{"480p", "540p", "576p", "720p", "1080p", "2160p", "4320p", "SD", "HD"};
    }

    private boolean isVideoHD(String videoFormat) {
        if (videoFormat.equals("720p")) {
            return true;
        }
        if (videoFormat.equals("1080p")) {
            return true;
        }
        if (videoFormat.equals("2160p")) {
            return true;
        }
        return videoFormat.equals("4320p");
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

