/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowTagFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private TmmTableFormat.StringComparator comparator;
    private TvShowList tvShowList = TvShowList.getInstance();

    public TvShowTagFilter() {
        this.comparator = new TmmTableFormat.StringComparator();
        this.buildAndInstallTagsArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallTagsArray();
        this.tvShowList.addPropertyChangeListener("tag", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "tvShowTag";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List tags = this.checkComboBox.getSelectedItems();
        if (tags.isEmpty()) {
            if (invert ^ tvShow.getTags().isEmpty()) {
                return true;
            }
            for (TvShowEpisode episode : episodes) {
                if (!(invert ^ episode.getTags().isEmpty())) continue;
                return true;
            }
        }
        for (String tag : tags) {
            boolean containsTags = tags.contains(tag);
            if (!invert && containsTags) {
                return true;
            }
            if (invert && containsTags) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                if (!(invert ^ episode.getTags().contains(tag))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("movieextendedsearch.tag"));
    }

    private void buildAndInstallTagsArray() {
        ArrayList<String> tags = new ArrayList<String>(this.tvShowList.getTagsInTvShows());
        tags.addAll(this.tvShowList.getTagsInEpisodes());
        tags.sort(this.comparator);
        this.setValues(tags);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

