/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowSubtitleDownloadTask;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.IMediaSubtitleProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowSubtitleChooserModel;

public class TvShowSubtitleChooserDialog
extends TmmDialog {
    private static final long serialVersionUID = -3104541519073924724L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSubtitleChooserDialog.class);
    private final TvShowList tvShowList = TvShowList.getInstance();
    private final TvShowEpisode episodeToScrape;
    private final MediaFile fileToScrape;
    private SearchTask activeSearchTask = null;
    private EventList<TvShowSubtitleChooserModel> subtitleEventList;
    private DefaultEventTableModel<TvShowSubtitleChooserModel> subtitleTableModel;
    private final boolean inQueue;
    private boolean continueQueue = true;
    private JTable tableSubs;
    private JComboBox<MediaLanguages> cbLanguage;
    private MediaScraperCheckComboBox cbScraper;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;
    private JButton btnSearch;

    public TvShowSubtitleChooserDialog(TvShowEpisode episode, MediaFile mediaFile, boolean inQueue) {
        super(BUNDLE.getString("tvshowepisodesubtitlechooser.search"), "episodeSubtitleChooser");
        this.episodeToScrape = episode;
        this.fileToScrape = mediaFile;
        this.inQueue = inQueue;
        this.subtitleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(TvShowSubtitleChooserModel.class)));
        this.subtitleTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.subtitleEventList), (TableFormat)new SubtitleTableFormat());
        this.initComponents();
        LinkListener linkListener = new LinkListener();
        this.tableSubs.addMouseListener(linkListener);
        this.tableSubs.addMouseMotionListener(linkListener);
        this.tableSubs.setAutoResizeMode(0);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableSubs, 7);
        ArrayList<MediaScraper> selectedSubtitleScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper subtitleScraper : this.tvShowList.getAvailableSubtitleScrapers()) {
            if (!TvShowModuleManager.SETTINGS.getSubtitleScrapers().contains(subtitleScraper.getId())) continue;
            selectedSubtitleScrapers.add(subtitleScraper);
        }
        if (!selectedSubtitleScrapers.isEmpty()) {
            this.cbScraper.setSelectedItems(selectedSubtitleScrapers);
        }
        for (MediaLanguages language : MediaLanguages.valuesSorted()) {
            this.cbLanguage.addItem(language);
            if (language != TvShowModuleManager.SETTINGS.getSubtitleScraperLanguage()) continue;
            this.cbLanguage.setSelectedItem(language);
        }
        this.btnSearch.addActionListener(e -> this.searchSubtitle(this.fileToScrape.getFileAsPath().toFile(), this.episodeToScrape.getTvShow().getImdbId(), this.episodeToScrape.getSeason(), this.episodeToScrape.getEpisode()));
        this.cbLanguage.addActionListener(e -> this.searchSubtitle(this.fileToScrape.getFileAsPath().toFile(), this.episodeToScrape.getTvShow().getImdbId(), this.episodeToScrape.getSeason(), this.episodeToScrape.getEpisode()));
        this.searchSubtitle(this.fileToScrape.getFileAsPath().toFile(), this.episodeToScrape.getTvShow().getImdbId(), this.episodeToScrape.getSeason(), this.episodeToScrape.getEpisode());
    }

    private void initComponents() {
        JPanel panelTitle = new JPanel();
        panelTitle.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JLabel lblEpisodeTitle = new JLabel(this.episodeToScrape.getTitle());
        TmmFontHelper.changeFont(lblEpisodeTitle, 1.33, 1);
        panelTitle.add((Component)lblEpisodeTitle, "cell 0 0 5 1,growx");
        this.setTopIformationPanel(panelTitle);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][][300lp,grow]", "[][][][][][shrink 0][200lp,grow]"));
        TmmLabel lblSeasonT = new TmmLabel(BUNDLE.getString("metatag.season"));
        panelContent.add((Component)lblSeasonT, "cell 0 0,alignx right");
        JLabel lblSeason = new JLabel(String.valueOf(this.episodeToScrape.getSeason()));
        panelContent.add((Component)lblSeason, "cell 1 0");
        TmmLabel lblEpisodeT = new TmmLabel(BUNDLE.getString("metatag.episode"));
        panelContent.add((Component)lblEpisodeT, "cell 0 1,alignx right");
        JLabel lblEpisode = new JLabel(String.valueOf(this.episodeToScrape.getEpisode()));
        panelContent.add((Component)lblEpisode, "cell 1 1");
        TmmLabel lblMediaFileNameT = new TmmLabel(BUNDLE.getString("metatag.filename"));
        panelContent.add((Component)lblMediaFileNameT, "cell 0 2,alignx right");
        JLabel lblMediaFileName = new JLabel(this.fileToScrape.getFilename());
        panelContent.add((Component)lblMediaFileName, "cell 1 2 2 1,growx");
        TmmLabel lblScraperT = new TmmLabel(BUNDLE.getString("scraper"));
        panelContent.add((Component)lblScraperT, "cell 0 3,alignx right");
        this.cbScraper = new MediaScraperCheckComboBox(this.tvShowList.getAvailableSubtitleScrapers());
        panelContent.add((Component)this.cbScraper, "cell 1 3,growx");
        this.btnSearch = new JButton(BUNDLE.getString("Button.search"));
        panelContent.add((Component)this.btnSearch, "cell 2 3,alignx left");
        TmmLabel lblLanguageT = new TmmLabel(BUNDLE.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "cell 0 4,alignx right");
        this.cbLanguage = new JComboBox();
        panelContent.add(this.cbLanguage, "cell 1 4,growx");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 5 3 1,growx");
        JScrollPane scrollPaneSubs = new JScrollPane();
        panelContent.add((Component)scrollPaneSubs, "cell 0 6 3 1,grow");
        this.tableSubs = new TmmTable((TableModel)this.subtitleTableModel);
        scrollPaneSubs.setViewportView(this.tableSubs);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        if (this.inQueue) {
            JButton btnAbortQueue = new JButton(BUNDLE.getString("Button.abortqueue"));
            btnAbortQueue.setIcon(IconManager.STOP_INV);
            btnAbortQueue.addActionListener(e -> {
                this.continueQueue = false;
                this.setVisible(false);
            });
            this.addButton(btnAbortQueue);
        }
        JButton btnDone = new JButton(BUNDLE.getString("Button.done"));
        btnDone.setIcon(IconManager.APPLY_INV);
        btnDone.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(btnDone);
    }

    private void searchSubtitle(File file, String imdbId, int season, int episode) {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        ArrayList<MediaScraper> scrapers = new ArrayList<MediaScraper>(this.cbScraper.getSelectedItems());
        this.activeSearchTask = new SearchTask(file, imdbId, season, episode, scrapers);
        this.activeSearchTask.execute();
    }

    private void startProgressBar(String description) {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(description);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText("");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                row = table.convertRowIndexToModel(row);
                TvShowSubtitleChooserModel model = (TvShowSubtitleChooserModel)TvShowSubtitleChooserDialog.this.subtitleEventList.get(row);
                if (StringUtils.isNotBlank((CharSequence)model.getDownloadUrl())) {
                    String filename = FilenameUtils.getBaseName((String)TvShowSubtitleChooserDialog.this.fileToScrape.getFilename()) + "." + model.getLanguage().name();
                    TvShowSubtitleDownloadTask task = new TvShowSubtitleDownloadTask(model.getDownloadUrl(), TvShowSubtitleChooserDialog.this.episodeToScrape.getPathNIO().resolve(filename), TvShowSubtitleChooserDialog.this.episodeToScrape);
                    TmmTaskManager.getInstance().addDownloadTask(task);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if (col == 0 && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private static class SubtitleTableFormat
    implements AdvancedTableFormat<TvShowSubtitleChooserModel> {
        private SubtitleTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return BUNDLE.getString("metatag.title");
                }
                case 2: {
                    return BUNDLE.getString("metatag.releasename");
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(TvShowSubtitleChooserModel model, int column) {
            switch (column) {
                case 0: {
                    return IconManager.DOWNLOAD;
                }
                case 1: {
                    return model.getName();
                }
                case 2: {
                    return model.getReleaseName();
                }
            }
            throw new IllegalStateException();
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            throw new IllegalStateException();
        }

        public Comparator getColumnComparator(int arg0) {
            return null;
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private File file;
        private int season;
        private int episode;
        private String imdbId;
        private List<SubtitleSearchResult> searchResults;
        private MediaLanguages language;
        private List<MediaScraper> scrapers;
        boolean cancel;

        SearchTask(File file, String imdbId, int season, int episode, List<MediaScraper> scrapers) {
            this.file = file;
            this.season = season;
            this.episode = episode;
            this.imdbId = imdbId;
            this.language = (MediaLanguages)TvShowSubtitleChooserDialog.this.cbLanguage.getSelectedItem();
            this.searchResults = new ArrayList<SubtitleSearchResult>();
            this.scrapers = scrapers;
            this.cancel = false;
        }

        @Override
        public Void doInBackground() {
            TvShowSubtitleChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.searchingfor") + " " + TvShowSubtitleChooserDialog.this.episodeToScrape.getTitle());
            for (MediaScraper scraper : this.scrapers) {
                try {
                    IMediaSubtitleProvider subtitleProvider = (IMediaSubtitleProvider)scraper.getMediaProvider();
                    SubtitleSearchOptions options = new SubtitleSearchOptions(this.file);
                    options.setImdbId(this.imdbId);
                    options.setLanguage(this.language.toLocale());
                    options.setSeason(this.season);
                    options.setEpisode(this.episode);
                    this.searchResults.addAll(subtitleProvider.search(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getSubtitles", (Throwable)e);
                    MessageDialog.showExceptionWindow(e);
                }
                catch (MissingIdException | UnsupportedMediaTypeException throwable) {}
            }
            Collections.sort(this.searchResults);
            Collections.reverse(this.searchResults);
            return null;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void done() {
            if (!this.cancel) {
                TvShowSubtitleChooserDialog.this.subtitleEventList.clear();
                if (this.searchResults == null || this.searchResults.size() == 0) {
                    TvShowSubtitleChooserDialog.this.subtitleEventList.add((Object)TvShowSubtitleChooserModel.EMPTY_RESULT);
                } else {
                    for (SubtitleSearchResult result : this.searchResults) {
                        TvShowSubtitleChooserDialog.this.subtitleEventList.add((Object)new TvShowSubtitleChooserModel(result, this.language));
                    }
                }
                if (!TvShowSubtitleChooserDialog.this.subtitleEventList.isEmpty()) {
                    TvShowSubtitleChooserDialog.this.tableSubs.setRowSelectionInterval(0, 0);
                }
                TableColumnResizer.adjustColumnPreferredWidths(TvShowSubtitleChooserDialog.this.tableSubs, 7);
            }
            TvShowSubtitleChooserDialog.this.stopProgressBar();
        }
    }
}

