/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.panels.TvShowScraperMetadataPanel;

public class TvShowScrapeMetadataDialog
extends TmmDialog {
    private static final long serialVersionUID = 6120530120703772160L;
    private TvShowSearchAndScrapeOptions tvShowSearchAndScrapeConfig = new TvShowSearchAndScrapeOptions();
    private boolean startScrape = true;
    private MediaScraperComboBox cbMetadataScraper;
    private MediaScraperCheckComboBox cbArtworkScraper;

    public TvShowScrapeMetadataDialog(String title) {
        super(title, "updateMetadata");
        TvShowScraperMetadataConfig settings = TvShowModuleManager.SETTINGS.getScraperMetadataConfig();
        TvShowScraperMetadataConfig scraperMetadataConfig = new TvShowScraperMetadataConfig();
        scraperMetadataConfig.setTitle(settings.isTitle());
        scraperMetadataConfig.setPlot(settings.isPlot());
        scraperMetadataConfig.setAired(settings.isAired());
        scraperMetadataConfig.setRating(settings.isRating());
        scraperMetadataConfig.setRuntime(settings.isRuntime());
        scraperMetadataConfig.setYear(settings.isYear());
        scraperMetadataConfig.setCertification(settings.isCertification());
        scraperMetadataConfig.setCast(settings.isCast());
        scraperMetadataConfig.setGenres(settings.isGenres());
        scraperMetadataConfig.setArtwork(settings.isArtwork());
        scraperMetadataConfig.setEpisodes(settings.isEpisodes());
        scraperMetadataConfig.setStatus(settings.isStatus());
        scraperMetadataConfig.setEpisodeList(TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes());
        this.tvShowSearchAndScrapeConfig.setScraperMetadataConfig(scraperMetadataConfig);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][300lp,grow]", "[][][20lp:n][][][]"));
        TmmLabel lblMetadataScraperT = new TmmLabel(BUNDLE.getString("scraper.metadata"));
        panelContent.add((Component)lblMetadataScraperT, "cell 0 0,alignx right");
        this.cbMetadataScraper = new MediaScraperComboBox(TvShowList.getInstance().getAvailableMediaScrapers());
        panelContent.add((Component)this.cbMetadataScraper, "cell 1 0,growx");
        TmmLabel lblArtworkScraper = new TmmLabel(BUNDLE.getString("scraper.artwork"));
        panelContent.add((Component)lblArtworkScraper, "cell 0 1,alignx right");
        this.cbArtworkScraper = new MediaScraperCheckComboBox(TvShowList.getInstance().getAvailableArtworkScrapers());
        panelContent.add((Component)this.cbArtworkScraper, "cell 1 1,growx");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 3 2 1,growx");
        TmmLabel lblScrapeFollowingItems = new TmmLabel(BUNDLE.getString("scraper.metadata.select"));
        panelContent.add((Component)lblScrapeFollowingItems, "cell 0 4 2 1,growx");
        TvShowScraperMetadataPanel panelScraperMetadataSetting = new TvShowScraperMetadataPanel(this.tvShowSearchAndScrapeConfig.getScraperMetadataConfig());
        panelContent.add((Component)panelScraperMetadataSetting, "cell 0 5 2 1,grow");
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startScrape = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startScrape = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        MediaScraper defaultScraper = TvShowList.getInstance().getDefaultMediaScraper();
        this.cbMetadataScraper.setSelectedItem(defaultScraper);
        ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper artworkScraper : TvShowList.getInstance().getAvailableArtworkScrapers()) {
            if (!TvShowModuleManager.SETTINGS.getArtworkScrapers().contains(artworkScraper.getId())) continue;
            selectedArtworkScrapers.add(artworkScraper);
        }
        if (!selectedArtworkScrapers.isEmpty()) {
            this.cbArtworkScraper.setSelectedItems(selectedArtworkScrapers);
        }
    }

    public TvShowSearchAndScrapeOptions getTvShowSearchAndScrapeConfig() {
        this.tvShowSearchAndScrapeConfig.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        for (MediaScraper scraper : this.cbArtworkScraper.getSelectedItems()) {
            this.tvShowSearchAndScrapeConfig.addArtworkScraper(scraper);
        }
        return this.tvShowSearchAndScrapeConfig;
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

