/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowBulkEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3527478264068979388L;
    private TvShowList tvShowList = TvShowList.getInstance();
    private List<TvShow> tvShowsToEdit;
    private List<TvShowEpisode> tvShowEpisodesToEdit;
    private boolean episodesChanged = false;
    private boolean tvShowsChanged = false;
    private JComboBox<MediaGenres> cbGenres;
    private JComboBox<String> cbTags;
    private JComboBox<String> cbTagsEpisode;
    private JCheckBox chckbxWatched;
    private JSpinner spSeason;
    private JTextField tfCountry;
    private JTextField tfStudio;

    public TvShowBulkEditorDialog(List<TvShow> tvShows, List<TvShowEpisode> episodes) {
        super(BUNDLE.getString("tvshow.bulkedit"), "movieBatchEditor");
        this.tvShowsToEdit = tvShows;
        this.tvShowEpisodesToEdit = episodes;
        this.initComponents();
    }

    private void initComponents() {
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[20lp:n][][100lp,grow][]", "[][][][20lp:n][][][][][][]"));
        TmmLabel lblTvShowT = new TmmLabel(BUNDLE.getString("metatag.tvshow"));
        panelContent.add((Component)lblTvShowT, "cell 0 0 2 1");
        TmmLabel lblGenres = new TmmLabel(BUNDLE.getString("metatag.genre"));
        panelContent.add((Component)lblGenres, "cell 1 1,alignx right");
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        panelContent.add(this.cbGenres, "cell 2 1, growx, wmin 0");
        this.cbGenres.setEditable(true);
        JButton btnAddGenre = new JButton("");
        panelContent.add((Component)btnAddGenre, "flowx,cell 3 1");
        btnAddGenre.setIcon(IconManager.ADD_INV);
        btnAddGenre.setMargin(new Insets(2, 2, 2, 2));
        btnAddGenre.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = null;
            Object item = this.cbGenres.getSelectedItem();
            if (item instanceof MediaGenres) {
                genre = (MediaGenres)item;
            }
            if (item instanceof String) {
                genre = MediaGenres.getGenre((String)((String)item));
            }
            if (genre != null) {
                for (TvShow tvShow : this.tvShowsToEdit) {
                    tvShow.addGenre(genre);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTags = new TmmLabel("Tag");
        panelContent.add((Component)lblTags, "cell 1 2,alignx right");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInTvShows());
        panelContent.add(this.cbTags, "cell 2 2, growx, wmin 0");
        this.cbTags.setEditable(true);
        JButton btnAddTag = new JButton("");
        panelContent.add((Component)btnAddTag, "flowx,cell 3 2");
        btnAddTag.setIcon(IconManager.ADD_INV);
        btnAddTag.setMargin(new Insets(2, 2, 2, 2));
        btnAddTag.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)this.cbTags.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.addToTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblCountry = new TmmLabel(BUNDLE.getString("metatag.country"));
        panelContent.add((Component)lblCountry, "cell 1 3, alignx right");
        this.tfCountry = new JTextField();
        panelContent.add((Component)this.tfCountry, "cell 2 3, growx, wmin 0");
        JButton btnChgCountry = new JButton("");
        panelContent.add((Component)btnChgCountry, "flowx, cell 3 3");
        btnChgCountry.setIcon(IconManager.APPLY_INV);
        btnChgCountry.setMargin(new Insets(2, 2, 2, 2));
        btnChgCountry.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setCountry(this.tfCountry.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblStudio = new TmmLabel(BUNDLE.getString("metatag.studio"));
        panelContent.add((Component)lblStudio, "cell 1 4, alignx right");
        this.tfStudio = new JTextField();
        panelContent.add((Component)this.tfStudio, "cell 2 4, growx, wmin 0");
        JButton btnChgStudio = new JButton("");
        panelContent.add((Component)btnChgStudio, "flowx, cell 3 4");
        btnChgStudio.setIcon(IconManager.APPLY_INV);
        btnChgStudio.setMargin(new Insets(2, 2, 2, 2));
        btnChgStudio.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.setProductionCompany(this.tfStudio.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblEpisodeT = new TmmLabel(BUNDLE.getString("metatag.episode"));
        panelContent.add((Component)lblEpisodeT, "cell 0 5 2 1");
        TmmLabel lblWatched = new TmmLabel(BUNDLE.getString("metatag.watched"));
        panelContent.add((Component)lblWatched, "cell 1 6,alignx right");
        this.chckbxWatched = new JCheckBox("");
        panelContent.add((Component)this.chckbxWatched, "cell 2 6");
        JButton btnWatched = new JButton("");
        panelContent.add((Component)btnWatched, "cell 3 6");
        btnWatched.setMargin(new Insets(2, 2, 2, 2));
        btnWatched.setIcon(IconManager.APPLY_INV);
        btnWatched.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setWatched(this.chckbxWatched.isSelected());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblSeason = new TmmLabel(BUNDLE.getString("metatag.season"));
        panelContent.add((Component)lblSeason, "cell 1 7,alignx right");
        this.spSeason = new JSpinner();
        panelContent.add((Component)this.spSeason, "cell 2 7");
        this.spSeason.setPreferredSize(new Dimension(40, 20));
        this.spSeason.setMinimumSize(new Dimension(40, 20));
        JButton btnSeason = new JButton("");
        panelContent.add((Component)btnSeason, "cell 3 7");
        btnSeason.setIcon(IconManager.APPLY_INV);
        btnSeason.setMargin(new Insets(2, 2, 2, 2));
        btnSeason.addActionListener(arg0 -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                Integer season = (Integer)this.spSeason.getValue();
                episode.setSeason(season);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblDvdOrder = new TmmLabel(BUNDLE.getString("metatag.dvdorder"));
        panelContent.add((Component)lblDvdOrder, "cell 1 8,alignx right");
        JCheckBox cbDvdOrder = new JCheckBox("");
        panelContent.add((Component)cbDvdOrder, "cell 2 8");
        JButton btnDvdOrder = new JButton("");
        panelContent.add((Component)btnDvdOrder, "cell 3 8");
        btnDvdOrder.setIcon(IconManager.APPLY_INV);
        btnDvdOrder.setMargin(new Insets(2, 2, 2, 2));
        btnDvdOrder.addActionListener(arg0 -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.setDvdOrder(cbDvdOrder.isSelected());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblTagsEpisode = new TmmLabel("Tag");
        panelContent.add((Component)lblTagsEpisode, "cell 1 9,alignx right");
        this.cbTagsEpisode = new AutocompleteComboBox<Object>(this.tvShowList.getTagsInEpisodes().toArray());
        panelContent.add(this.cbTagsEpisode, "cell 2 9,growx, wmin 0");
        this.cbTagsEpisode.setEditable(true);
        JButton btnAddTagEpisode = new JButton("");
        panelContent.add((Component)btnAddTagEpisode, "flowx,cell 3 9");
        btnAddTagEpisode.setIcon(IconManager.ADD_INV);
        btnAddTagEpisode.setMargin(new Insets(2, 2, 2, 2));
        btnAddTagEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)this.cbTagsEpisode.getSelectedItem();
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.addToTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        TmmLabel lblMediasourceEpisode = new TmmLabel(BUNDLE.getString("metatag.source"));
        panelContent.add((Component)lblMediasourceEpisode, "cell 1 10,alignx right");
        JComboBox<MediaSource> cbMediaSourceEpisode = new JComboBox<MediaSource>(MediaSource.values());
        panelContent.add(cbMediaSourceEpisode, "cell 2 10,growx, wmin 0");
        JButton btnMediaSourceEpisode = new JButton("");
        panelContent.add((Component)btnMediaSourceEpisode, "cell 3 10");
        btnMediaSourceEpisode.setMargin(new Insets(2, 2, 2, 2));
        btnMediaSourceEpisode.setIcon(IconManager.APPLY_INV);
        btnMediaSourceEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            Object obj = cbMediaSourceEpisode.getSelectedItem();
            if (obj instanceof MediaSource) {
                MediaSource mediaSource = (MediaSource)((Object)((Object)obj));
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    episode.setMediaSource(mediaSource);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        JButton btnRemoveGenre = new JButton("");
        panelContent.add((Component)btnRemoveGenre, "cell 3 1");
        btnRemoveGenre.setIcon(IconManager.REMOVE_INV);
        btnRemoveGenre.setMargin(new Insets(2, 2, 2, 2));
        JButton btnRemoveTag = new JButton("");
        panelContent.add((Component)btnRemoveTag, "cell 3 2");
        btnRemoveTag.setIcon(IconManager.REMOVE_INV);
        btnRemoveTag.setMargin(new Insets(2, 2, 2, 2));
        JButton btnRemoveTagEpisode = new JButton("");
        panelContent.add((Component)btnRemoveTagEpisode, "cell 3 9");
        btnRemoveTagEpisode.setIcon(IconManager.REMOVE_INV);
        btnRemoveTagEpisode.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveTagEpisode.addActionListener(e -> {
            this.episodesChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)this.cbTagsEpisode.getSelectedItem();
            for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                episode.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        btnRemoveTag.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)this.cbTags.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        btnRemoveGenre.addActionListener(e -> {
            this.tvShowsChanged = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = (MediaGenres)this.cbGenres.getSelectedItem();
            for (TvShow tvShow : this.tvShowsToEdit) {
                tvShow.removeGenre(genre);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY_INV);
        btnClose.addActionListener(arg0 -> {
            if (this.tvShowsChanged) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShow tvShow : this.tvShowsToEdit) {
                    tvShow.writeNFO();
                    tvShow.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this.episodesChanged) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (TvShowEpisode tvShowEpisode : this.tvShowEpisodesToEdit) {
                    tvShowEpisode.writeNFO();
                    tvShowEpisode.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
                HashSet<TvShow> tvShows1 = new HashSet<TvShow>();
                for (TvShowEpisode episode : this.tvShowEpisodesToEdit) {
                    tvShows1.add(episode.getTvShow());
                }
                tvShows1.addAll(this.tvShowsToEdit);
                SyncTraktTvTask syncTraktTvTask = new SyncTraktTvTask(null, new ArrayList<TvShow>(tvShows1));
                TmmTaskManager.getInstance().addUnnamedTask(syncTraktTvTask);
            }
            this.setVisible(false);
        });
        this.addDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TvShowBulkEditorDialog.this.tvShowsChanged) {
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShow tvShow : TvShowBulkEditorDialog.this.tvShowsToEdit) {
                        tvShow.writeNFO();
                        tvShow.saveToDb();
                    }
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (TvShowBulkEditorDialog.this.episodesChanged) {
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    for (TvShowEpisode episode : TvShowBulkEditorDialog.this.tvShowEpisodesToEdit) {
                        episode.writeNFO();
                        episode.saveToDb();
                    }
                    TvShowBulkEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }
}

